/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.StripeConnectInvoiceStatusEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ShipperPayCourierStatement1 {
    private final int schemaVersion;
    private final List<String> shipperPayCourierLineItemGroupIds;
    private final List<String> taskGroupIds;
    private final Optional<String> offChrtShipperOrgId;
    private final Optional<String> shipperOrgId;
    private final String courierOrgId;
    private final Optional<String> shipperCustomerIdForCourierStripeConnectAccount;
    private final Optional<String> stripeInvoiceId;
    private final Optional<String> stripeInvoiceUrl;
    private final Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp;
    private final Optional<String> stripeInvoiceCreatedByUserId;
    private final double statementAmount;
    private final Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus;
    private final Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private ShipperPayCourierStatement1(int schemaVersion, List<String> shipperPayCourierLineItemGroupIds, List<String> taskGroupIds, Optional<String> offChrtShipperOrgId, Optional<String> shipperOrgId, String courierOrgId, Optional<String> shipperCustomerIdForCourierStripeConnectAccount, Optional<String> stripeInvoiceId, Optional<String> stripeInvoiceUrl, Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp, Optional<String> stripeInvoiceCreatedByUserId, double statementAmount, Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus, Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.shipperPayCourierLineItemGroupIds = shipperPayCourierLineItemGroupIds;
        this.taskGroupIds = taskGroupIds;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.shipperOrgId = shipperOrgId;
        this.courierOrgId = courierOrgId;
        this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
        this.stripeInvoiceId = stripeInvoiceId;
        this.stripeInvoiceUrl = stripeInvoiceUrl;
        this.stripeInvoiceCreatedTimestamp = stripeInvoiceCreatedTimestamp;
        this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
        this.statementAmount = statementAmount;
        this.stripeInvoiceStatus = stripeInvoiceStatus;
        this.stripeInvoiceCompletedTimestamp = stripeInvoiceCompletedTimestamp;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="shipper_pay_courier_line_item_group_ids")
    public List<String> getShipperPayCourierLineItemGroupIds() {
        return this.shipperPayCourierLineItemGroupIds;
    }

    @JsonProperty(value="task_group_ids")
    public List<String> getTaskGroupIds() {
        return this.taskGroupIds;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (this.offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.offChrtShipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (this.shipperOrgId == null) {
            return Optional.empty();
        }
        return this.shipperOrgId;
    }

    @JsonProperty(value="courier_org_id")
    public String getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForCourierStripeConnectAccount() {
        if (this.shipperCustomerIdForCourierStripeConnectAccount == null) {
            return Optional.empty();
        }
        return this.shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceId() {
        if (this.stripeInvoiceId == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceId;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceUrl() {
        if (this.stripeInvoiceUrl == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceUrl;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStripeInvoiceCreatedTimestamp() {
        if (this.stripeInvoiceCreatedTimestamp == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceCreatedTimestamp;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceCreatedByUserId() {
        if (this.stripeInvoiceCreatedByUserId == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceCreatedByUserId;
    }

    @JsonProperty(value="statement_amount")
    public double getStatementAmount() {
        return this.statementAmount;
    }

    @JsonProperty(value="stripe_invoice_status")
    public Optional<StripeConnectInvoiceStatusEnum> getStripeInvoiceStatus() {
        return this.stripeInvoiceStatus;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStripeInvoiceCompletedTimestamp() {
        if (this.stripeInvoiceCompletedTimestamp == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceCompletedTimestamp;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return this.offChrtShipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return this.shipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_customer_id_for_courier_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForCourierStripeConnectAccount() {
        return this.shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_id")
    private Optional<String> _getStripeInvoiceId() {
        return this.stripeInvoiceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_url")
    private Optional<String> _getStripeInvoiceUrl() {
        return this.stripeInvoiceUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_created_timestamp")
    private Optional<OffsetDateTime> _getStripeInvoiceCreatedTimestamp() {
        return this.stripeInvoiceCreatedTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_created_by_user_id")
    private Optional<String> _getStripeInvoiceCreatedByUserId() {
        return this.stripeInvoiceCreatedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_completed_timestamp")
    private Optional<OffsetDateTime> _getStripeInvoiceCompletedTimestamp() {
        return this.stripeInvoiceCompletedTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShipperPayCourierStatement1 && this.equalTo((ShipperPayCourierStatement1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperPayCourierStatement1 other) {
        return this.schemaVersion == other.schemaVersion && this.shipperPayCourierLineItemGroupIds.equals(other.shipperPayCourierLineItemGroupIds) && this.taskGroupIds.equals(other.taskGroupIds) && this.offChrtShipperOrgId.equals(other.offChrtShipperOrgId) && this.shipperOrgId.equals(other.shipperOrgId) && this.courierOrgId.equals(other.courierOrgId) && this.shipperCustomerIdForCourierStripeConnectAccount.equals(other.shipperCustomerIdForCourierStripeConnectAccount) && this.stripeInvoiceId.equals(other.stripeInvoiceId) && this.stripeInvoiceUrl.equals(other.stripeInvoiceUrl) && this.stripeInvoiceCreatedTimestamp.equals(other.stripeInvoiceCreatedTimestamp) && this.stripeInvoiceCreatedByUserId.equals(other.stripeInvoiceCreatedByUserId) && this.statementAmount == other.statementAmount && this.stripeInvoiceStatus.equals(other.stripeInvoiceStatus) && this.stripeInvoiceCompletedTimestamp.equals(other.stripeInvoiceCompletedTimestamp) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.shipperPayCourierLineItemGroupIds, this.taskGroupIds, this.offChrtShipperOrgId, this.shipperOrgId, this.courierOrgId, this.shipperCustomerIdForCourierStripeConnectAccount, this.stripeInvoiceId, this.stripeInvoiceUrl, this.stripeInvoiceCreatedTimestamp, this.stripeInvoiceCreatedByUserId, this.statementAmount, this.stripeInvoiceStatus, this.stripeInvoiceCompletedTimestamp, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    CourierOrgIdStage,
    StatementAmountStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String courierOrgId;
        private double statementAmount;
        private String id;
        private Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp = Optional.empty();
        private Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus = Optional.empty();
        private Optional<String> stripeInvoiceCreatedByUserId = Optional.empty();
        private Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp = Optional.empty();
        private Optional<String> stripeInvoiceUrl = Optional.empty();
        private Optional<String> stripeInvoiceId = Optional.empty();
        private Optional<String> shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();
        private Optional<String> shipperOrgId = Optional.empty();
        private Optional<String> offChrtShipperOrgId = Optional.empty();
        private List<String> taskGroupIds = new ArrayList<String>();
        private List<String> shipperPayCourierLineItemGroupIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ShipperPayCourierStatement1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.shipperPayCourierLineItemGroupIds(other.getShipperPayCourierLineItemGroupIds());
            this.taskGroupIds(other.getTaskGroupIds());
            this.offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            this.shipperOrgId(other.getShipperOrgId());
            this.courierOrgId(other.getCourierOrgId());
            this.shipperCustomerIdForCourierStripeConnectAccount(other.getShipperCustomerIdForCourierStripeConnectAccount());
            this.stripeInvoiceId(other.getStripeInvoiceId());
            this.stripeInvoiceUrl(other.getStripeInvoiceUrl());
            this.stripeInvoiceCreatedTimestamp(other.getStripeInvoiceCreatedTimestamp());
            this.stripeInvoiceCreatedByUserId(other.getStripeInvoiceCreatedByUserId());
            this.statementAmount(other.getStatementAmount());
            this.stripeInvoiceStatus(other.getStripeInvoiceStatus());
            this.stripeInvoiceCompletedTimestamp(other.getStripeInvoiceCompletedTimestamp());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public CourierOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id")
        public StatementAmountStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="statement_amount")
        public IdStage statementAmount(double statementAmount) {
            this.statementAmount = statementAmount;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCompletedTimestamp(Nullable<OffsetDateTime> stripeInvoiceCompletedTimestamp) {
            this.stripeInvoiceCompletedTimestamp = stripeInvoiceCompletedTimestamp.isNull() ? null : (stripeInvoiceCompletedTimestamp.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceCompletedTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCompletedTimestamp(OffsetDateTime stripeInvoiceCompletedTimestamp) {
            this.stripeInvoiceCompletedTimestamp = Optional.ofNullable(stripeInvoiceCompletedTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_completed_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceCompletedTimestamp(Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp) {
            this.stripeInvoiceCompletedTimestamp = stripeInvoiceCompletedTimestamp;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum stripeInvoiceStatus) {
            this.stripeInvoiceStatus = Optional.ofNullable(stripeInvoiceStatus);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_status", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus) {
            this.stripeInvoiceStatus = stripeInvoiceStatus;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId.isNull() ? null : (stripeInvoiceCreatedByUserId.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceCreatedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCreatedByUserId(String stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = Optional.ofNullable(stripeInvoiceCreatedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_created_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceCreatedByUserId(Optional<String> stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCreatedTimestamp(Nullable<OffsetDateTime> stripeInvoiceCreatedTimestamp) {
            this.stripeInvoiceCreatedTimestamp = stripeInvoiceCreatedTimestamp.isNull() ? null : (stripeInvoiceCreatedTimestamp.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceCreatedTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCreatedTimestamp(OffsetDateTime stripeInvoiceCreatedTimestamp) {
            this.stripeInvoiceCreatedTimestamp = Optional.ofNullable(stripeInvoiceCreatedTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_created_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceCreatedTimestamp(Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp) {
            this.stripeInvoiceCreatedTimestamp = stripeInvoiceCreatedTimestamp;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceUrl(Nullable<String> stripeInvoiceUrl) {
            this.stripeInvoiceUrl = stripeInvoiceUrl.isNull() ? null : (stripeInvoiceUrl.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceUrl.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceUrl(String stripeInvoiceUrl) {
            this.stripeInvoiceUrl = Optional.ofNullable(stripeInvoiceUrl);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_url", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceUrl(Optional<String> stripeInvoiceUrl) {
            this.stripeInvoiceUrl = stripeInvoiceUrl;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceId(Nullable<String> stripeInvoiceId) {
            this.stripeInvoiceId = stripeInvoiceId.isNull() ? null : (stripeInvoiceId.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceId.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceId(String stripeInvoiceId) {
            this.stripeInvoiceId = Optional.ofNullable(stripeInvoiceId);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_id", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceId(Optional<String> stripeInvoiceId) {
            this.stripeInvoiceId = stripeInvoiceId;
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Nullable<String> shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount.isNull() ? null : (shipperCustomerIdForCourierStripeConnectAccount.isEmpty() ? Optional.empty() : Optional.of(shipperCustomerIdForCourierStripeConnectAccount.get()));
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(String shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = Optional.ofNullable(shipperCustomerIdForCourierStripeConnectAccount);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_customer_id_for_courier_stripe_connect_account", nulls=Nulls.SKIP)
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Optional<String> shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId.isNull() ? null : (shipperOrgId.isEmpty() ? Optional.empty() : Optional.of(shipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId.isNull() ? null : (offChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(offChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage addAllTaskGroupIds(List<String> taskGroupIds) {
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @Override
        public _FinalStage addTaskGroupIds(String taskGroupIds) {
            this.taskGroupIds.add(taskGroupIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_group_ids", nulls=Nulls.SKIP)
        public _FinalStage taskGroupIds(List<String> taskGroupIds) {
            this.taskGroupIds.clear();
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAllShipperPayCourierLineItemGroupIds(List<String> shipperPayCourierLineItemGroupIds) {
            if (shipperPayCourierLineItemGroupIds != null) {
                this.shipperPayCourierLineItemGroupIds.addAll(shipperPayCourierLineItemGroupIds);
            }
            return this;
        }

        @Override
        public _FinalStage addShipperPayCourierLineItemGroupIds(String shipperPayCourierLineItemGroupIds) {
            this.shipperPayCourierLineItemGroupIds.add(shipperPayCourierLineItemGroupIds);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_pay_courier_line_item_group_ids", nulls=Nulls.SKIP)
        public _FinalStage shipperPayCourierLineItemGroupIds(List<String> shipperPayCourierLineItemGroupIds) {
            this.shipperPayCourierLineItemGroupIds.clear();
            if (shipperPayCourierLineItemGroupIds != null) {
                this.shipperPayCourierLineItemGroupIds.addAll(shipperPayCourierLineItemGroupIds);
            }
            return this;
        }

        @Override
        public ShipperPayCourierStatement1 build() {
            return new ShipperPayCourierStatement1(this.schemaVersion, this.shipperPayCourierLineItemGroupIds, this.taskGroupIds, this.offChrtShipperOrgId, this.shipperOrgId, this.courierOrgId, this.shipperCustomerIdForCourierStripeConnectAccount, this.stripeInvoiceId, this.stripeInvoiceUrl, this.stripeInvoiceCreatedTimestamp, this.stripeInvoiceCreatedByUserId, this.statementAmount, this.stripeInvoiceStatus, this.stripeInvoiceCompletedTimestamp, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ShipperPayCourierStatement1 build();

        public _FinalStage shipperPayCourierLineItemGroupIds(List<String> var1);

        public _FinalStage addShipperPayCourierLineItemGroupIds(String var1);

        public _FinalStage addAllShipperPayCourierLineItemGroupIds(List<String> var1);

        public _FinalStage taskGroupIds(List<String> var1);

        public _FinalStage addTaskGroupIds(String var1);

        public _FinalStage addAllTaskGroupIds(List<String> var1);

        public _FinalStage offChrtShipperOrgId(Optional<String> var1);

        public _FinalStage offChrtShipperOrgId(String var1);

        public _FinalStage offChrtShipperOrgId(Nullable<String> var1);

        public _FinalStage shipperOrgId(Optional<String> var1);

        public _FinalStage shipperOrgId(String var1);

        public _FinalStage shipperOrgId(Nullable<String> var1);

        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Optional<String> var1);

        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(String var1);

        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Nullable<String> var1);

        public _FinalStage stripeInvoiceId(Optional<String> var1);

        public _FinalStage stripeInvoiceId(String var1);

        public _FinalStage stripeInvoiceId(Nullable<String> var1);

        public _FinalStage stripeInvoiceUrl(Optional<String> var1);

        public _FinalStage stripeInvoiceUrl(String var1);

        public _FinalStage stripeInvoiceUrl(Nullable<String> var1);

        public _FinalStage stripeInvoiceCreatedTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stripeInvoiceCreatedTimestamp(OffsetDateTime var1);

        public _FinalStage stripeInvoiceCreatedTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage stripeInvoiceCreatedByUserId(Optional<String> var1);

        public _FinalStage stripeInvoiceCreatedByUserId(String var1);

        public _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> var1);

        public _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> var1);

        public _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum var1);

        public _FinalStage stripeInvoiceCompletedTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stripeInvoiceCompletedTimestamp(OffsetDateTime var1);

        public _FinalStage stripeInvoiceCompletedTimestamp(Nullable<OffsetDateTime> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface StatementAmountStage {
        public IdStage statementAmount(double var1);
    }

    public static interface CourierOrgIdStage {
        public StatementAmountStage courierOrgId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public CourierOrgIdStage schemaVersion(int var1);

        public Builder from(ShipperPayCourierStatement1 var1);
    }
}

