/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.chrt.api.types.TaskGroup1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StatementPreviewResponse {
    private final List<TaskGroup1> taskGroups;
    private final List<ShipperPayCourierLineItemGroup1> lineItemGroups;
    private final double totalAmount;
    private final boolean statementReady;
    private final Map<String, Object> additionalProperties;

    private StatementPreviewResponse(List<TaskGroup1> taskGroups, List<ShipperPayCourierLineItemGroup1> lineItemGroups, double totalAmount, boolean statementReady, Map<String, Object> additionalProperties) {
        this.taskGroups = taskGroups;
        this.lineItemGroups = lineItemGroups;
        this.totalAmount = totalAmount;
        this.statementReady = statementReady;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="task_groups")
    public List<TaskGroup1> getTaskGroups() {
        return this.taskGroups;
    }

    @JsonProperty(value="line_item_groups")
    public List<ShipperPayCourierLineItemGroup1> getLineItemGroups() {
        return this.lineItemGroups;
    }

    @JsonProperty(value="total_amount")
    public double getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="statement_ready")
    public boolean getStatementReady() {
        return this.statementReady;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StatementPreviewResponse && this.equalTo((StatementPreviewResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementPreviewResponse other) {
        return this.taskGroups.equals(other.taskGroups) && this.lineItemGroups.equals(other.lineItemGroups) && this.totalAmount == other.totalAmount && this.statementReady == other.statementReady;
    }

    public int hashCode() {
        return Objects.hash(this.taskGroups, this.lineItemGroups, this.totalAmount, this.statementReady);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalAmountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalAmountStage,
    StatementReadyStage,
    _FinalStage {
        private double totalAmount;
        private boolean statementReady;
        private List<ShipperPayCourierLineItemGroup1> lineItemGroups = new ArrayList<ShipperPayCourierLineItemGroup1>();
        private List<TaskGroup1> taskGroups = new ArrayList<TaskGroup1>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StatementPreviewResponse other) {
            this.taskGroups(other.getTaskGroups());
            this.lineItemGroups(other.getLineItemGroups());
            this.totalAmount(other.getTotalAmount());
            this.statementReady(other.getStatementReady());
            return this;
        }

        @Override
        @JsonSetter(value="total_amount")
        public StatementReadyStage totalAmount(double totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @Override
        @JsonSetter(value="statement_ready")
        public _FinalStage statementReady(boolean statementReady) {
            this.statementReady = statementReady;
            return this;
        }

        @Override
        public _FinalStage addAllLineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups) {
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addLineItemGroups(ShipperPayCourierLineItemGroup1 lineItemGroups) {
            this.lineItemGroups.add(lineItemGroups);
            return this;
        }

        @Override
        @JsonSetter(value="line_item_groups", nulls=Nulls.SKIP)
        public _FinalStage lineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups) {
            this.lineItemGroups.clear();
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addAllTaskGroups(List<TaskGroup1> taskGroups) {
            if (taskGroups != null) {
                this.taskGroups.addAll(taskGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addTaskGroups(TaskGroup1 taskGroups) {
            this.taskGroups.add(taskGroups);
            return this;
        }

        @Override
        @JsonSetter(value="task_groups", nulls=Nulls.SKIP)
        public _FinalStage taskGroups(List<TaskGroup1> taskGroups) {
            this.taskGroups.clear();
            if (taskGroups != null) {
                this.taskGroups.addAll(taskGroups);
            }
            return this;
        }

        @Override
        public StatementPreviewResponse build() {
            return new StatementPreviewResponse(this.taskGroups, this.lineItemGroups, this.totalAmount, this.statementReady, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StatementPreviewResponse build();

        public _FinalStage taskGroups(List<TaskGroup1> var1);

        public _FinalStage addTaskGroups(TaskGroup1 var1);

        public _FinalStage addAllTaskGroups(List<TaskGroup1> var1);

        public _FinalStage lineItemGroups(List<ShipperPayCourierLineItemGroup1> var1);

        public _FinalStage addLineItemGroups(ShipperPayCourierLineItemGroup1 var1);

        public _FinalStage addAllLineItemGroups(List<ShipperPayCourierLineItemGroup1> var1);
    }

    public static interface StatementReadyStage {
        public _FinalStage statementReady(boolean var1);
    }

    public static interface TotalAmountStage {
        public StatementReadyStage totalAmount(double var1);

        public Builder from(StatementPreviewResponse var1);
    }
}

