/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class StatementStatusEnum {
    public static final StatementStatusEnum COMPLETED = new StatementStatusEnum(Value.COMPLETED, "completed");
    public static final StatementStatusEnum READY_FOR_REVIEW = new StatementStatusEnum(Value.READY_FOR_REVIEW, "ready_for_review");
    public static final StatementStatusEnum CANCELLED = new StatementStatusEnum(Value.CANCELLED, "cancelled");
    public static final StatementStatusEnum CREATED = new StatementStatusEnum(Value.CREATED, "created");
    private final Value value;
    private final String string;

    StatementStatusEnum(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof StatementStatusEnum && this.string.equals(((StatementStatusEnum)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case COMPLETED: {
                return visitor.visitCompleted();
            }
            case READY_FOR_REVIEW: {
                return visitor.visitReadyForReview();
            }
            case CANCELLED: {
                return visitor.visitCancelled();
            }
            case CREATED: {
                return visitor.visitCreated();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static StatementStatusEnum valueOf(String value) {
        switch (value) {
            case "completed": {
                return COMPLETED;
            }
            case "ready_for_review": {
                return READY_FOR_REVIEW;
            }
            case "cancelled": {
                return CANCELLED;
            }
            case "created": {
                return CREATED;
            }
        }
        return new StatementStatusEnum(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitCreated();

        public T visitReadyForReview();

        public T visitCompleted();

        public T visitCancelled();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        CREATED,
        READY_FOR_REVIEW,
        COMPLETED,
        CANCELLED,
        UNKNOWN;

    }
}

