/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Action;
import com.chrt.api.types.LocationFeature;
import com.chrt.api.types.TaskStatusEnum1;
import com.chrt.api.types.TimeWindow1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Task1 {
    private final int schemaVersion;
    private final Optional<LocationFeature> location;
    private final Optional<Action> action;
    private final Optional<List<TimeWindow1>> timeWindows;
    private final Optional<String> orderPlacerComments;
    private final Optional<List<String>> shipperContactIds;
    private final Optional<String> flightNumber;
    private final String id;
    private final String orderId;
    private final String orderShortId;
    private final String taskGroupId;
    private final String createdByOrgId;
    private final String createdByUserId;
    private final Optional<String> completedByOrgId;
    private final Optional<String> completedByUserId;
    private final Optional<List<String>> cargoIds;
    private final Optional<List<String>> taskArtifactIds;
    private final Optional<TaskStatusEnum1> status;
    private final OffsetDateTime draftStartedAtTimestamp;
    private final Optional<OffsetDateTime> stagedAtTimestamp;
    private final Optional<OffsetDateTime> completedAtTimestamp;
    private final Optional<OffsetDateTime> skippedAtTimestamp;
    private final Optional<OffsetDateTime> exceptionAtTimestamp;
    private final Optional<Boolean> orderCancelled;
    private final Optional<List<String>> taskNotificationEmailIds;
    private final Optional<List<String>> taskNotificationSmsIds;
    private final Optional<List<String>> taskNotificationPushIds;
    private final Optional<List<String>> taskNotificationVoiceIds;
    private final Map<String, Object> additionalProperties;

    private Task1(int schemaVersion, Optional<LocationFeature> location, Optional<Action> action, Optional<List<TimeWindow1>> timeWindows, Optional<String> orderPlacerComments, Optional<List<String>> shipperContactIds, Optional<String> flightNumber, String id, String orderId, String orderShortId, String taskGroupId, String createdByOrgId, String createdByUserId, Optional<String> completedByOrgId, Optional<String> completedByUserId, Optional<List<String>> cargoIds, Optional<List<String>> taskArtifactIds, Optional<TaskStatusEnum1> status, OffsetDateTime draftStartedAtTimestamp, Optional<OffsetDateTime> stagedAtTimestamp, Optional<OffsetDateTime> completedAtTimestamp, Optional<OffsetDateTime> skippedAtTimestamp, Optional<OffsetDateTime> exceptionAtTimestamp, Optional<Boolean> orderCancelled, Optional<List<String>> taskNotificationEmailIds, Optional<List<String>> taskNotificationSmsIds, Optional<List<String>> taskNotificationPushIds, Optional<List<String>> taskNotificationVoiceIds, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.location = location;
        this.action = action;
        this.timeWindows = timeWindows;
        this.orderPlacerComments = orderPlacerComments;
        this.shipperContactIds = shipperContactIds;
        this.flightNumber = flightNumber;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.taskGroupId = taskGroupId;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.completedByOrgId = completedByOrgId;
        this.completedByUserId = completedByUserId;
        this.cargoIds = cargoIds;
        this.taskArtifactIds = taskArtifactIds;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.skippedAtTimestamp = skippedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.orderCancelled = orderCancelled;
        this.taskNotificationEmailIds = taskNotificationEmailIds;
        this.taskNotificationSmsIds = taskNotificationSmsIds;
        this.taskNotificationPushIds = taskNotificationPushIds;
        this.taskNotificationVoiceIds = taskNotificationVoiceIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLocation() {
        if (this.location == null) {
            return Optional.empty();
        }
        return this.location;
    }

    @JsonIgnore
    public Optional<Action> getAction() {
        if (this.action == null) {
            return Optional.empty();
        }
        return this.action;
    }

    @JsonProperty(value="time_windows")
    public Optional<List<TimeWindow1>> getTimeWindows() {
        return this.timeWindows;
    }

    @JsonIgnore
    public Optional<String> getOrderPlacerComments() {
        if (this.orderPlacerComments == null) {
            return Optional.empty();
        }
        return this.orderPlacerComments;
    }

    @JsonProperty(value="shipper_contact_ids")
    public Optional<List<String>> getShipperContactIds() {
        return this.shipperContactIds;
    }

    @JsonIgnore
    public Optional<String> getFlightNumber() {
        if (this.flightNumber == null) {
            return Optional.empty();
        }
        return this.flightNumber;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="order_short_id")
    public String getOrderShortId() {
        return this.orderShortId;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="created_by_org_id")
    public String getCreatedByOrgId() {
        return this.createdByOrgId;
    }

    @JsonProperty(value="created_by_user_id")
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonIgnore
    public Optional<String> getCompletedByOrgId() {
        if (this.completedByOrgId == null) {
            return Optional.empty();
        }
        return this.completedByOrgId;
    }

    @JsonIgnore
    public Optional<String> getCompletedByUserId() {
        if (this.completedByUserId == null) {
            return Optional.empty();
        }
        return this.completedByUserId;
    }

    @JsonProperty(value="cargo_ids")
    public Optional<List<String>> getCargoIds() {
        return this.cargoIds;
    }

    @JsonProperty(value="task_artifact_ids")
    public Optional<List<String>> getTaskArtifactIds() {
        return this.taskArtifactIds;
    }

    @JsonProperty(value="status")
    public Optional<TaskStatusEnum1> getStatus() {
        return this.status;
    }

    @JsonProperty(value="draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return this.draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (this.stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (this.completedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getSkippedAtTimestamp() {
        if (this.skippedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.skippedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (this.exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return this.exceptionAtTimestamp;
    }

    @JsonProperty(value="order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return this.orderCancelled;
    }

    @JsonProperty(value="task_notification_email_ids")
    public Optional<List<String>> getTaskNotificationEmailIds() {
        return this.taskNotificationEmailIds;
    }

    @JsonProperty(value="task_notification_sms_ids")
    public Optional<List<String>> getTaskNotificationSmsIds() {
        return this.taskNotificationSmsIds;
    }

    @JsonProperty(value="task_notification_push_ids")
    public Optional<List<String>> getTaskNotificationPushIds() {
        return this.taskNotificationPushIds;
    }

    @JsonProperty(value="task_notification_voice_ids")
    public Optional<List<String>> getTaskNotificationVoiceIds() {
        return this.taskNotificationVoiceIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location")
    private Optional<LocationFeature> _getLocation() {
        return this.location;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="action")
    private Optional<Action> _getAction() {
        return this.action;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_placer_comments")
    private Optional<String> _getOrderPlacerComments() {
        return this.orderPlacerComments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="flight_number")
    private Optional<String> _getFlightNumber() {
        return this.flightNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_by_org_id")
    private Optional<String> _getCompletedByOrgId() {
        return this.completedByOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_by_user_id")
    private Optional<String> _getCompletedByUserId() {
        return this.completedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return this.stagedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return this.completedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="skipped_at_timestamp")
    private Optional<OffsetDateTime> _getSkippedAtTimestamp() {
        return this.skippedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return this.exceptionAtTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Task1 && this.equalTo((Task1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Task1 other) {
        return this.schemaVersion == other.schemaVersion && this.location.equals(other.location) && this.action.equals(other.action) && this.timeWindows.equals(other.timeWindows) && this.orderPlacerComments.equals(other.orderPlacerComments) && this.shipperContactIds.equals(other.shipperContactIds) && this.flightNumber.equals(other.flightNumber) && this.id.equals(other.id) && this.orderId.equals(other.orderId) && this.orderShortId.equals(other.orderShortId) && this.taskGroupId.equals(other.taskGroupId) && this.createdByOrgId.equals(other.createdByOrgId) && this.createdByUserId.equals(other.createdByUserId) && this.completedByOrgId.equals(other.completedByOrgId) && this.completedByUserId.equals(other.completedByUserId) && this.cargoIds.equals(other.cargoIds) && this.taskArtifactIds.equals(other.taskArtifactIds) && this.status.equals(other.status) && this.draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp) && this.stagedAtTimestamp.equals(other.stagedAtTimestamp) && this.completedAtTimestamp.equals(other.completedAtTimestamp) && this.skippedAtTimestamp.equals(other.skippedAtTimestamp) && this.exceptionAtTimestamp.equals(other.exceptionAtTimestamp) && this.orderCancelled.equals(other.orderCancelled) && this.taskNotificationEmailIds.equals(other.taskNotificationEmailIds) && this.taskNotificationSmsIds.equals(other.taskNotificationSmsIds) && this.taskNotificationPushIds.equals(other.taskNotificationPushIds) && this.taskNotificationVoiceIds.equals(other.taskNotificationVoiceIds);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.location, this.action, this.timeWindows, this.orderPlacerComments, this.shipperContactIds, this.flightNumber, this.id, this.orderId, this.orderShortId, this.taskGroupId, this.createdByOrgId, this.createdByUserId, this.completedByOrgId, this.completedByUserId, this.cargoIds, this.taskArtifactIds, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.completedAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp, this.orderCancelled, this.taskNotificationEmailIds, this.taskNotificationSmsIds, this.taskNotificationPushIds, this.taskNotificationVoiceIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    OrderIdStage,
    OrderShortIdStage,
    TaskGroupIdStage,
    CreatedByOrgIdStage,
    CreatedByUserIdStage,
    DraftStartedAtTimestampStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private String orderId;
        private String orderShortId;
        private String taskGroupId;
        private String createdByOrgId;
        private String createdByUserId;
        private OffsetDateTime draftStartedAtTimestamp;
        private Optional<List<String>> taskNotificationVoiceIds = Optional.empty();
        private Optional<List<String>> taskNotificationPushIds = Optional.empty();
        private Optional<List<String>> taskNotificationSmsIds = Optional.empty();
        private Optional<List<String>> taskNotificationEmailIds = Optional.empty();
        private Optional<Boolean> orderCancelled = Optional.empty();
        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> skippedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();
        private Optional<TaskStatusEnum1> status = Optional.empty();
        private Optional<List<String>> taskArtifactIds = Optional.empty();
        private Optional<List<String>> cargoIds = Optional.empty();
        private Optional<String> completedByUserId = Optional.empty();
        private Optional<String> completedByOrgId = Optional.empty();
        private Optional<String> flightNumber = Optional.empty();
        private Optional<List<String>> shipperContactIds = Optional.empty();
        private Optional<String> orderPlacerComments = Optional.empty();
        private Optional<List<TimeWindow1>> timeWindows = Optional.empty();
        private Optional<Action> action = Optional.empty();
        private Optional<LocationFeature> location = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Task1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.location(other.getLocation());
            this.action(other.getAction());
            this.timeWindows(other.getTimeWindows());
            this.orderPlacerComments(other.getOrderPlacerComments());
            this.shipperContactIds(other.getShipperContactIds());
            this.flightNumber(other.getFlightNumber());
            this.id(other.getId());
            this.orderId(other.getOrderId());
            this.orderShortId(other.getOrderShortId());
            this.taskGroupId(other.getTaskGroupId());
            this.createdByOrgId(other.getCreatedByOrgId());
            this.createdByUserId(other.getCreatedByUserId());
            this.completedByOrgId(other.getCompletedByOrgId());
            this.completedByUserId(other.getCompletedByUserId());
            this.cargoIds(other.getCargoIds());
            this.taskArtifactIds(other.getTaskArtifactIds());
            this.status(other.getStatus());
            this.draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            this.stagedAtTimestamp(other.getStagedAtTimestamp());
            this.completedAtTimestamp(other.getCompletedAtTimestamp());
            this.skippedAtTimestamp(other.getSkippedAtTimestamp());
            this.exceptionAtTimestamp(other.getExceptionAtTimestamp());
            this.orderCancelled(other.getOrderCancelled());
            this.taskNotificationEmailIds(other.getTaskNotificationEmailIds());
            this.taskNotificationSmsIds(other.getTaskNotificationSmsIds());
            this.taskNotificationPushIds(other.getTaskNotificationPushIds());
            this.taskNotificationVoiceIds(other.getTaskNotificationVoiceIds());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_short_id")
        public TaskGroupIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public CreatedByOrgIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp = Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @Override
        public _FinalStage taskNotificationVoiceIds(List<String> taskNotificationVoiceIds) {
            this.taskNotificationVoiceIds = Optional.ofNullable(taskNotificationVoiceIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_notification_voice_ids", nulls=Nulls.SKIP)
        public _FinalStage taskNotificationVoiceIds(Optional<List<String>> taskNotificationVoiceIds) {
            this.taskNotificationVoiceIds = taskNotificationVoiceIds;
            return this;
        }

        @Override
        public _FinalStage taskNotificationPushIds(List<String> taskNotificationPushIds) {
            this.taskNotificationPushIds = Optional.ofNullable(taskNotificationPushIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_notification_push_ids", nulls=Nulls.SKIP)
        public _FinalStage taskNotificationPushIds(Optional<List<String>> taskNotificationPushIds) {
            this.taskNotificationPushIds = taskNotificationPushIds;
            return this;
        }

        @Override
        public _FinalStage taskNotificationSmsIds(List<String> taskNotificationSmsIds) {
            this.taskNotificationSmsIds = Optional.ofNullable(taskNotificationSmsIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_notification_sms_ids", nulls=Nulls.SKIP)
        public _FinalStage taskNotificationSmsIds(Optional<List<String>> taskNotificationSmsIds) {
            this.taskNotificationSmsIds = taskNotificationSmsIds;
            return this;
        }

        @Override
        public _FinalStage taskNotificationEmailIds(List<String> taskNotificationEmailIds) {
            this.taskNotificationEmailIds = Optional.ofNullable(taskNotificationEmailIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_notification_email_ids", nulls=Nulls.SKIP)
        public _FinalStage taskNotificationEmailIds(Optional<List<String>> taskNotificationEmailIds) {
            this.taskNotificationEmailIds = taskNotificationEmailIds;
            return this;
        }

        @Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @Override
        @JsonSetter(value="order_cancelled", nulls=Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp.isNull() ? null : (exceptionAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(exceptionAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="exception_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp.isNull() ? null : (skippedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(skippedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp) {
            this.skippedAtTimestamp = Optional.ofNullable(skippedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="skipped_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp.isNull() ? null : (completedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(completedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="completed_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp.isNull() ? null : (stagedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(stagedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="staged_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage status(TaskStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<TaskStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage taskArtifactIds(List<String> taskArtifactIds) {
            this.taskArtifactIds = Optional.ofNullable(taskArtifactIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_artifact_ids", nulls=Nulls.SKIP)
        public _FinalStage taskArtifactIds(Optional<List<String>> taskArtifactIds) {
            this.taskArtifactIds = taskArtifactIds;
            return this;
        }

        @Override
        public _FinalStage cargoIds(List<String> cargoIds) {
            this.cargoIds = Optional.ofNullable(cargoIds);
            return this;
        }

        @Override
        @JsonSetter(value="cargo_ids", nulls=Nulls.SKIP)
        public _FinalStage cargoIds(Optional<List<String>> cargoIds) {
            this.cargoIds = cargoIds;
            return this;
        }

        @Override
        public _FinalStage completedByUserId(Nullable<String> completedByUserId) {
            this.completedByUserId = completedByUserId.isNull() ? null : (completedByUserId.isEmpty() ? Optional.empty() : Optional.of(completedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage completedByUserId(String completedByUserId) {
            this.completedByUserId = Optional.ofNullable(completedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="completed_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage completedByUserId(Optional<String> completedByUserId) {
            this.completedByUserId = completedByUserId;
            return this;
        }

        @Override
        public _FinalStage completedByOrgId(Nullable<String> completedByOrgId) {
            this.completedByOrgId = completedByOrgId.isNull() ? null : (completedByOrgId.isEmpty() ? Optional.empty() : Optional.of(completedByOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage completedByOrgId(String completedByOrgId) {
            this.completedByOrgId = Optional.ofNullable(completedByOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="completed_by_org_id", nulls=Nulls.SKIP)
        public _FinalStage completedByOrgId(Optional<String> completedByOrgId) {
            this.completedByOrgId = completedByOrgId;
            return this;
        }

        @Override
        public _FinalStage flightNumber(Nullable<String> flightNumber) {
            this.flightNumber = flightNumber.isNull() ? null : (flightNumber.isEmpty() ? Optional.empty() : Optional.of(flightNumber.get()));
            return this;
        }

        @Override
        public _FinalStage flightNumber(String flightNumber) {
            this.flightNumber = Optional.ofNullable(flightNumber);
            return this;
        }

        @Override
        @JsonSetter(value="flight_number", nulls=Nulls.SKIP)
        public _FinalStage flightNumber(Optional<String> flightNumber) {
            this.flightNumber = flightNumber;
            return this;
        }

        @Override
        public _FinalStage shipperContactIds(List<String> shipperContactIds) {
            this.shipperContactIds = Optional.ofNullable(shipperContactIds);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_contact_ids", nulls=Nulls.SKIP)
        public _FinalStage shipperContactIds(Optional<List<String>> shipperContactIds) {
            this.shipperContactIds = shipperContactIds;
            return this;
        }

        @Override
        public _FinalStage orderPlacerComments(Nullable<String> orderPlacerComments) {
            this.orderPlacerComments = orderPlacerComments.isNull() ? null : (orderPlacerComments.isEmpty() ? Optional.empty() : Optional.of(orderPlacerComments.get()));
            return this;
        }

        @Override
        public _FinalStage orderPlacerComments(String orderPlacerComments) {
            this.orderPlacerComments = Optional.ofNullable(orderPlacerComments);
            return this;
        }

        @Override
        @JsonSetter(value="order_placer_comments", nulls=Nulls.SKIP)
        public _FinalStage orderPlacerComments(Optional<String> orderPlacerComments) {
            this.orderPlacerComments = orderPlacerComments;
            return this;
        }

        @Override
        public _FinalStage timeWindows(List<TimeWindow1> timeWindows) {
            this.timeWindows = Optional.ofNullable(timeWindows);
            return this;
        }

        @Override
        @JsonSetter(value="time_windows", nulls=Nulls.SKIP)
        public _FinalStage timeWindows(Optional<List<TimeWindow1>> timeWindows) {
            this.timeWindows = timeWindows;
            return this;
        }

        @Override
        public _FinalStage action(Nullable<Action> action) {
            this.action = action.isNull() ? null : (action.isEmpty() ? Optional.empty() : Optional.of(action.get()));
            return this;
        }

        @Override
        public _FinalStage action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @Override
        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public _FinalStage action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        @Override
        public _FinalStage location(Nullable<LocationFeature> location) {
            this.location = location.isNull() ? null : (location.isEmpty() ? Optional.empty() : Optional.of(location.get()));
            return this;
        }

        @Override
        public _FinalStage location(LocationFeature location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @Override
        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public _FinalStage location(Optional<LocationFeature> location) {
            this.location = location;
            return this;
        }

        @Override
        public Task1 build() {
            return new Task1(this.schemaVersion, this.location, this.action, this.timeWindows, this.orderPlacerComments, this.shipperContactIds, this.flightNumber, this.id, this.orderId, this.orderShortId, this.taskGroupId, this.createdByOrgId, this.createdByUserId, this.completedByOrgId, this.completedByUserId, this.cargoIds, this.taskArtifactIds, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.completedAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp, this.orderCancelled, this.taskNotificationEmailIds, this.taskNotificationSmsIds, this.taskNotificationPushIds, this.taskNotificationVoiceIds, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Task1 build();

        public _FinalStage location(Optional<LocationFeature> var1);

        public _FinalStage location(LocationFeature var1);

        public _FinalStage location(Nullable<LocationFeature> var1);

        public _FinalStage action(Optional<Action> var1);

        public _FinalStage action(Action var1);

        public _FinalStage action(Nullable<Action> var1);

        public _FinalStage timeWindows(Optional<List<TimeWindow1>> var1);

        public _FinalStage timeWindows(List<TimeWindow1> var1);

        public _FinalStage orderPlacerComments(Optional<String> var1);

        public _FinalStage orderPlacerComments(String var1);

        public _FinalStage orderPlacerComments(Nullable<String> var1);

        public _FinalStage shipperContactIds(Optional<List<String>> var1);

        public _FinalStage shipperContactIds(List<String> var1);

        public _FinalStage flightNumber(Optional<String> var1);

        public _FinalStage flightNumber(String var1);

        public _FinalStage flightNumber(Nullable<String> var1);

        public _FinalStage completedByOrgId(Optional<String> var1);

        public _FinalStage completedByOrgId(String var1);

        public _FinalStage completedByOrgId(Nullable<String> var1);

        public _FinalStage completedByUserId(Optional<String> var1);

        public _FinalStage completedByUserId(String var1);

        public _FinalStage completedByUserId(Nullable<String> var1);

        public _FinalStage cargoIds(Optional<List<String>> var1);

        public _FinalStage cargoIds(List<String> var1);

        public _FinalStage taskArtifactIds(Optional<List<String>> var1);

        public _FinalStage taskArtifactIds(List<String> var1);

        public _FinalStage status(Optional<TaskStatusEnum1> var1);

        public _FinalStage status(TaskStatusEnum1 var1);

        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stagedAtTimestamp(OffsetDateTime var1);

        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(OffsetDateTime var1);

        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(OffsetDateTime var1);

        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(OffsetDateTime var1);

        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage orderCancelled(Optional<Boolean> var1);

        public _FinalStage orderCancelled(Boolean var1);

        public _FinalStage taskNotificationEmailIds(Optional<List<String>> var1);

        public _FinalStage taskNotificationEmailIds(List<String> var1);

        public _FinalStage taskNotificationSmsIds(Optional<List<String>> var1);

        public _FinalStage taskNotificationSmsIds(List<String> var1);

        public _FinalStage taskNotificationPushIds(Optional<List<String>> var1);

        public _FinalStage taskNotificationPushIds(List<String> var1);

        public _FinalStage taskNotificationVoiceIds(Optional<List<String>> var1);

        public _FinalStage taskNotificationVoiceIds(List<String> var1);
    }

    public static interface DraftStartedAtTimestampStage {
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedByUserIdStage {
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String var1);
    }

    public static interface CreatedByOrgIdStage {
        public CreatedByUserIdStage createdByOrgId(@NotNull String var1);
    }

    public static interface TaskGroupIdStage {
        public CreatedByOrgIdStage taskGroupId(@NotNull String var1);
    }

    public static interface OrderShortIdStage {
        public TaskGroupIdStage orderShortId(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public OrderShortIdStage orderId(@NotNull String var1);
    }

    public static interface IdStage {
        public OrderIdStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(Task1 var1);
    }
}

