/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TaskArtifactStatusEnum1;
import com.chrt.api.types.TaskArtifactTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskArtifact1 {
    private final int schemaVersion;
    private final TaskArtifactTypeEnum1 type;
    private final String id;
    private final String orderId;
    private final String orderShortId;
    private final String taskGroupId;
    private final String taskId;
    private final Optional<List<String>> taskArtifactS3ObjectMetadataIds;
    private final String createdByOrgId;
    private final String createdByUserId;
    private final Optional<String> requestedByOrgId;
    private final Optional<String> requestedByUserId;
    private final Optional<String> completedByOrgId;
    private final Optional<String> completedByUserId;
    private final Optional<TaskArtifactStatusEnum1> status;
    private final OffsetDateTime draftStartedAtTimestamp;
    private final Optional<OffsetDateTime> stagedAtTimestamp;
    private final Optional<OffsetDateTime> completedAtTimestamp;
    private final Optional<OffsetDateTime> skippedAtTimestamp;
    private final Optional<OffsetDateTime> exceptionAtTimestamp;
    private final Map<String, Object> additionalProperties;

    private TaskArtifact1(int schemaVersion, TaskArtifactTypeEnum1 type, String id, String orderId, String orderShortId, String taskGroupId, String taskId, Optional<List<String>> taskArtifactS3ObjectMetadataIds, String createdByOrgId, String createdByUserId, Optional<String> requestedByOrgId, Optional<String> requestedByUserId, Optional<String> completedByOrgId, Optional<String> completedByUserId, Optional<TaskArtifactStatusEnum1> status, OffsetDateTime draftStartedAtTimestamp, Optional<OffsetDateTime> stagedAtTimestamp, Optional<OffsetDateTime> completedAtTimestamp, Optional<OffsetDateTime> skippedAtTimestamp, Optional<OffsetDateTime> exceptionAtTimestamp, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.type = type;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.taskGroupId = taskGroupId;
        this.taskId = taskId;
        this.taskArtifactS3ObjectMetadataIds = taskArtifactS3ObjectMetadataIds;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.requestedByOrgId = requestedByOrgId;
        this.requestedByUserId = requestedByUserId;
        this.completedByOrgId = completedByOrgId;
        this.completedByUserId = completedByUserId;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.skippedAtTimestamp = skippedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="type")
    public TaskArtifactTypeEnum1 getType() {
        return this.type;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="order_short_id")
    public String getOrderShortId() {
        return this.orderShortId;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="task_id")
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty(value="task_artifact_s3_object_metadata_ids")
    public Optional<List<String>> getTaskArtifactS3ObjectMetadataIds() {
        return this.taskArtifactS3ObjectMetadataIds;
    }

    @JsonProperty(value="created_by_org_id")
    public String getCreatedByOrgId() {
        return this.createdByOrgId;
    }

    @JsonProperty(value="created_by_user_id")
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonIgnore
    public Optional<String> getRequestedByOrgId() {
        if (this.requestedByOrgId == null) {
            return Optional.empty();
        }
        return this.requestedByOrgId;
    }

    @JsonIgnore
    public Optional<String> getRequestedByUserId() {
        if (this.requestedByUserId == null) {
            return Optional.empty();
        }
        return this.requestedByUserId;
    }

    @JsonIgnore
    public Optional<String> getCompletedByOrgId() {
        if (this.completedByOrgId == null) {
            return Optional.empty();
        }
        return this.completedByOrgId;
    }

    @JsonIgnore
    public Optional<String> getCompletedByUserId() {
        if (this.completedByUserId == null) {
            return Optional.empty();
        }
        return this.completedByUserId;
    }

    @JsonProperty(value="status")
    public Optional<TaskArtifactStatusEnum1> getStatus() {
        return this.status;
    }

    @JsonProperty(value="draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return this.draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (this.stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (this.completedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getSkippedAtTimestamp() {
        if (this.skippedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.skippedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (this.exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return this.exceptionAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="requested_by_org_id")
    private Optional<String> _getRequestedByOrgId() {
        return this.requestedByOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="requested_by_user_id")
    private Optional<String> _getRequestedByUserId() {
        return this.requestedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_by_org_id")
    private Optional<String> _getCompletedByOrgId() {
        return this.completedByOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_by_user_id")
    private Optional<String> _getCompletedByUserId() {
        return this.completedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return this.stagedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return this.completedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="skipped_at_timestamp")
    private Optional<OffsetDateTime> _getSkippedAtTimestamp() {
        return this.skippedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return this.exceptionAtTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskArtifact1 && this.equalTo((TaskArtifact1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskArtifact1 other) {
        return this.schemaVersion == other.schemaVersion && this.type.equals(other.type) && this.id.equals(other.id) && this.orderId.equals(other.orderId) && this.orderShortId.equals(other.orderShortId) && this.taskGroupId.equals(other.taskGroupId) && this.taskId.equals(other.taskId) && this.taskArtifactS3ObjectMetadataIds.equals(other.taskArtifactS3ObjectMetadataIds) && this.createdByOrgId.equals(other.createdByOrgId) && this.createdByUserId.equals(other.createdByUserId) && this.requestedByOrgId.equals(other.requestedByOrgId) && this.requestedByUserId.equals(other.requestedByUserId) && this.completedByOrgId.equals(other.completedByOrgId) && this.completedByUserId.equals(other.completedByUserId) && this.status.equals(other.status) && this.draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp) && this.stagedAtTimestamp.equals(other.stagedAtTimestamp) && this.completedAtTimestamp.equals(other.completedAtTimestamp) && this.skippedAtTimestamp.equals(other.skippedAtTimestamp) && this.exceptionAtTimestamp.equals(other.exceptionAtTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.type, this.id, this.orderId, this.orderShortId, this.taskGroupId, this.taskId, this.taskArtifactS3ObjectMetadataIds, this.createdByOrgId, this.createdByUserId, this.requestedByOrgId, this.requestedByUserId, this.completedByOrgId, this.completedByUserId, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.completedAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    TypeStage,
    IdStage,
    OrderIdStage,
    OrderShortIdStage,
    TaskGroupIdStage,
    TaskIdStage,
    CreatedByOrgIdStage,
    CreatedByUserIdStage,
    DraftStartedAtTimestampStage,
    _FinalStage {
        private int schemaVersion;
        private TaskArtifactTypeEnum1 type;
        private String id;
        private String orderId;
        private String orderShortId;
        private String taskGroupId;
        private String taskId;
        private String createdByOrgId;
        private String createdByUserId;
        private OffsetDateTime draftStartedAtTimestamp;
        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> skippedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();
        private Optional<TaskArtifactStatusEnum1> status = Optional.empty();
        private Optional<String> completedByUserId = Optional.empty();
        private Optional<String> completedByOrgId = Optional.empty();
        private Optional<String> requestedByUserId = Optional.empty();
        private Optional<String> requestedByOrgId = Optional.empty();
        private Optional<List<String>> taskArtifactS3ObjectMetadataIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskArtifact1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.type(other.getType());
            this.id(other.getId());
            this.orderId(other.getOrderId());
            this.orderShortId(other.getOrderShortId());
            this.taskGroupId(other.getTaskGroupId());
            this.taskId(other.getTaskId());
            this.taskArtifactS3ObjectMetadataIds(other.getTaskArtifactS3ObjectMetadataIds());
            this.createdByOrgId(other.getCreatedByOrgId());
            this.createdByUserId(other.getCreatedByUserId());
            this.requestedByOrgId(other.getRequestedByOrgId());
            this.requestedByUserId(other.getRequestedByUserId());
            this.completedByOrgId(other.getCompletedByOrgId());
            this.completedByUserId(other.getCompletedByUserId());
            this.status(other.getStatus());
            this.draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            this.stagedAtTimestamp(other.getStagedAtTimestamp());
            this.completedAtTimestamp(other.getCompletedAtTimestamp());
            this.skippedAtTimestamp(other.getSkippedAtTimestamp());
            this.exceptionAtTimestamp(other.getExceptionAtTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public TypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull TaskArtifactTypeEnum1 type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_short_id")
        public TaskGroupIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public TaskIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_id")
        public CreatedByOrgIdStage taskId(@NotNull String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp = Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp.isNull() ? null : (exceptionAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(exceptionAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="exception_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp.isNull() ? null : (skippedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(skippedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp) {
            this.skippedAtTimestamp = Optional.ofNullable(skippedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="skipped_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp.isNull() ? null : (completedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(completedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="completed_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp.isNull() ? null : (stagedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(stagedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="staged_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage status(TaskArtifactStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<TaskArtifactStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage completedByUserId(Nullable<String> completedByUserId) {
            this.completedByUserId = completedByUserId.isNull() ? null : (completedByUserId.isEmpty() ? Optional.empty() : Optional.of(completedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage completedByUserId(String completedByUserId) {
            this.completedByUserId = Optional.ofNullable(completedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="completed_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage completedByUserId(Optional<String> completedByUserId) {
            this.completedByUserId = completedByUserId;
            return this;
        }

        @Override
        public _FinalStage completedByOrgId(Nullable<String> completedByOrgId) {
            this.completedByOrgId = completedByOrgId.isNull() ? null : (completedByOrgId.isEmpty() ? Optional.empty() : Optional.of(completedByOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage completedByOrgId(String completedByOrgId) {
            this.completedByOrgId = Optional.ofNullable(completedByOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="completed_by_org_id", nulls=Nulls.SKIP)
        public _FinalStage completedByOrgId(Optional<String> completedByOrgId) {
            this.completedByOrgId = completedByOrgId;
            return this;
        }

        @Override
        public _FinalStage requestedByUserId(Nullable<String> requestedByUserId) {
            this.requestedByUserId = requestedByUserId.isNull() ? null : (requestedByUserId.isEmpty() ? Optional.empty() : Optional.of(requestedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage requestedByUserId(String requestedByUserId) {
            this.requestedByUserId = Optional.ofNullable(requestedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="requested_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage requestedByUserId(Optional<String> requestedByUserId) {
            this.requestedByUserId = requestedByUserId;
            return this;
        }

        @Override
        public _FinalStage requestedByOrgId(Nullable<String> requestedByOrgId) {
            this.requestedByOrgId = requestedByOrgId.isNull() ? null : (requestedByOrgId.isEmpty() ? Optional.empty() : Optional.of(requestedByOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage requestedByOrgId(String requestedByOrgId) {
            this.requestedByOrgId = Optional.ofNullable(requestedByOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="requested_by_org_id", nulls=Nulls.SKIP)
        public _FinalStage requestedByOrgId(Optional<String> requestedByOrgId) {
            this.requestedByOrgId = requestedByOrgId;
            return this;
        }

        @Override
        public _FinalStage taskArtifactS3ObjectMetadataIds(List<String> taskArtifactS3ObjectMetadataIds) {
            this.taskArtifactS3ObjectMetadataIds = Optional.ofNullable(taskArtifactS3ObjectMetadataIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_artifact_s3_object_metadata_ids", nulls=Nulls.SKIP)
        public _FinalStage taskArtifactS3ObjectMetadataIds(Optional<List<String>> taskArtifactS3ObjectMetadataIds) {
            this.taskArtifactS3ObjectMetadataIds = taskArtifactS3ObjectMetadataIds;
            return this;
        }

        @Override
        public TaskArtifact1 build() {
            return new TaskArtifact1(this.schemaVersion, this.type, this.id, this.orderId, this.orderShortId, this.taskGroupId, this.taskId, this.taskArtifactS3ObjectMetadataIds, this.createdByOrgId, this.createdByUserId, this.requestedByOrgId, this.requestedByUserId, this.completedByOrgId, this.completedByUserId, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.completedAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskArtifact1 build();

        public _FinalStage taskArtifactS3ObjectMetadataIds(Optional<List<String>> var1);

        public _FinalStage taskArtifactS3ObjectMetadataIds(List<String> var1);

        public _FinalStage requestedByOrgId(Optional<String> var1);

        public _FinalStage requestedByOrgId(String var1);

        public _FinalStage requestedByOrgId(Nullable<String> var1);

        public _FinalStage requestedByUserId(Optional<String> var1);

        public _FinalStage requestedByUserId(String var1);

        public _FinalStage requestedByUserId(Nullable<String> var1);

        public _FinalStage completedByOrgId(Optional<String> var1);

        public _FinalStage completedByOrgId(String var1);

        public _FinalStage completedByOrgId(Nullable<String> var1);

        public _FinalStage completedByUserId(Optional<String> var1);

        public _FinalStage completedByUserId(String var1);

        public _FinalStage completedByUserId(Nullable<String> var1);

        public _FinalStage status(Optional<TaskArtifactStatusEnum1> var1);

        public _FinalStage status(TaskArtifactStatusEnum1 var1);

        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stagedAtTimestamp(OffsetDateTime var1);

        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(OffsetDateTime var1);

        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(OffsetDateTime var1);

        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(OffsetDateTime var1);

        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> var1);
    }

    public static interface DraftStartedAtTimestampStage {
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedByUserIdStage {
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String var1);
    }

    public static interface CreatedByOrgIdStage {
        public CreatedByUserIdStage createdByOrgId(@NotNull String var1);
    }

    public static interface TaskIdStage {
        public CreatedByOrgIdStage taskId(@NotNull String var1);
    }

    public static interface TaskGroupIdStage {
        public TaskIdStage taskGroupId(@NotNull String var1);
    }

    public static interface OrderShortIdStage {
        public TaskGroupIdStage orderShortId(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public OrderShortIdStage orderId(@NotNull String var1);
    }

    public static interface IdStage {
        public OrderIdStage id(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull TaskArtifactTypeEnum1 var1);
    }

    public static interface SchemaVersionStage {
        public TypeStage schemaVersion(int var1);

        public Builder from(TaskArtifact1 var1);
    }
}

