/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Action;
import com.chrt.api.types.LocationFeature;
import com.chrt.api.types.TimeWindow1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskClientCreate1 {
    private final int schemaVersion;
    private final Optional<LocationFeature> location;
    private final Optional<Action> action;
    private final Optional<List<TimeWindow1>> timeWindows;
    private final Optional<String> orderPlacerComments;
    private final Optional<List<String>> shipperContactIds;
    private final Optional<String> flightNumber;
    private final Map<String, Object> additionalProperties;

    private TaskClientCreate1(int schemaVersion, Optional<LocationFeature> location, Optional<Action> action, Optional<List<TimeWindow1>> timeWindows, Optional<String> orderPlacerComments, Optional<List<String>> shipperContactIds, Optional<String> flightNumber, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.location = location;
        this.action = action;
        this.timeWindows = timeWindows;
        this.orderPlacerComments = orderPlacerComments;
        this.shipperContactIds = shipperContactIds;
        this.flightNumber = flightNumber;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLocation() {
        if (this.location == null) {
            return Optional.empty();
        }
        return this.location;
    }

    @JsonIgnore
    public Optional<Action> getAction() {
        if (this.action == null) {
            return Optional.empty();
        }
        return this.action;
    }

    @JsonProperty(value="time_windows")
    public Optional<List<TimeWindow1>> getTimeWindows() {
        return this.timeWindows;
    }

    @JsonIgnore
    public Optional<String> getOrderPlacerComments() {
        if (this.orderPlacerComments == null) {
            return Optional.empty();
        }
        return this.orderPlacerComments;
    }

    @JsonProperty(value="shipper_contact_ids")
    public Optional<List<String>> getShipperContactIds() {
        return this.shipperContactIds;
    }

    @JsonIgnore
    public Optional<String> getFlightNumber() {
        if (this.flightNumber == null) {
            return Optional.empty();
        }
        return this.flightNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location")
    private Optional<LocationFeature> _getLocation() {
        return this.location;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="action")
    private Optional<Action> _getAction() {
        return this.action;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_placer_comments")
    private Optional<String> _getOrderPlacerComments() {
        return this.orderPlacerComments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="flight_number")
    private Optional<String> _getFlightNumber() {
        return this.flightNumber;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskClientCreate1 && this.equalTo((TaskClientCreate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskClientCreate1 other) {
        return this.schemaVersion == other.schemaVersion && this.location.equals(other.location) && this.action.equals(other.action) && this.timeWindows.equals(other.timeWindows) && this.orderPlacerComments.equals(other.orderPlacerComments) && this.shipperContactIds.equals(other.shipperContactIds) && this.flightNumber.equals(other.flightNumber);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.location, this.action, this.timeWindows, this.orderPlacerComments, this.shipperContactIds, this.flightNumber);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    _FinalStage {
        private int schemaVersion;
        private Optional<String> flightNumber = Optional.empty();
        private Optional<List<String>> shipperContactIds = Optional.empty();
        private Optional<String> orderPlacerComments = Optional.empty();
        private Optional<List<TimeWindow1>> timeWindows = Optional.empty();
        private Optional<Action> action = Optional.empty();
        private Optional<LocationFeature> location = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskClientCreate1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.location(other.getLocation());
            this.action(other.getAction());
            this.timeWindows(other.getTimeWindows());
            this.orderPlacerComments(other.getOrderPlacerComments());
            this.shipperContactIds(other.getShipperContactIds());
            this.flightNumber(other.getFlightNumber());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public _FinalStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public _FinalStage flightNumber(Nullable<String> flightNumber) {
            this.flightNumber = flightNumber.isNull() ? null : (flightNumber.isEmpty() ? Optional.empty() : Optional.of(flightNumber.get()));
            return this;
        }

        @Override
        public _FinalStage flightNumber(String flightNumber) {
            this.flightNumber = Optional.ofNullable(flightNumber);
            return this;
        }

        @Override
        @JsonSetter(value="flight_number", nulls=Nulls.SKIP)
        public _FinalStage flightNumber(Optional<String> flightNumber) {
            this.flightNumber = flightNumber;
            return this;
        }

        @Override
        public _FinalStage shipperContactIds(List<String> shipperContactIds) {
            this.shipperContactIds = Optional.ofNullable(shipperContactIds);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_contact_ids", nulls=Nulls.SKIP)
        public _FinalStage shipperContactIds(Optional<List<String>> shipperContactIds) {
            this.shipperContactIds = shipperContactIds;
            return this;
        }

        @Override
        public _FinalStage orderPlacerComments(Nullable<String> orderPlacerComments) {
            this.orderPlacerComments = orderPlacerComments.isNull() ? null : (orderPlacerComments.isEmpty() ? Optional.empty() : Optional.of(orderPlacerComments.get()));
            return this;
        }

        @Override
        public _FinalStage orderPlacerComments(String orderPlacerComments) {
            this.orderPlacerComments = Optional.ofNullable(orderPlacerComments);
            return this;
        }

        @Override
        @JsonSetter(value="order_placer_comments", nulls=Nulls.SKIP)
        public _FinalStage orderPlacerComments(Optional<String> orderPlacerComments) {
            this.orderPlacerComments = orderPlacerComments;
            return this;
        }

        @Override
        public _FinalStage timeWindows(List<TimeWindow1> timeWindows) {
            this.timeWindows = Optional.ofNullable(timeWindows);
            return this;
        }

        @Override
        @JsonSetter(value="time_windows", nulls=Nulls.SKIP)
        public _FinalStage timeWindows(Optional<List<TimeWindow1>> timeWindows) {
            this.timeWindows = timeWindows;
            return this;
        }

        @Override
        public _FinalStage action(Nullable<Action> action) {
            this.action = action.isNull() ? null : (action.isEmpty() ? Optional.empty() : Optional.of(action.get()));
            return this;
        }

        @Override
        public _FinalStage action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @Override
        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public _FinalStage action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        @Override
        public _FinalStage location(Nullable<LocationFeature> location) {
            this.location = location.isNull() ? null : (location.isEmpty() ? Optional.empty() : Optional.of(location.get()));
            return this;
        }

        @Override
        public _FinalStage location(LocationFeature location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @Override
        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public _FinalStage location(Optional<LocationFeature> location) {
            this.location = location;
            return this;
        }

        @Override
        public TaskClientCreate1 build() {
            return new TaskClientCreate1(this.schemaVersion, this.location, this.action, this.timeWindows, this.orderPlacerComments, this.shipperContactIds, this.flightNumber, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskClientCreate1 build();

        public _FinalStage location(Optional<LocationFeature> var1);

        public _FinalStage location(LocationFeature var1);

        public _FinalStage location(Nullable<LocationFeature> var1);

        public _FinalStage action(Optional<Action> var1);

        public _FinalStage action(Action var1);

        public _FinalStage action(Nullable<Action> var1);

        public _FinalStage timeWindows(Optional<List<TimeWindow1>> var1);

        public _FinalStage timeWindows(List<TimeWindow1> var1);

        public _FinalStage orderPlacerComments(Optional<String> var1);

        public _FinalStage orderPlacerComments(String var1);

        public _FinalStage orderPlacerComments(Nullable<String> var1);

        public _FinalStage shipperContactIds(Optional<List<String>> var1);

        public _FinalStage shipperContactIds(List<String> var1);

        public _FinalStage flightNumber(Optional<String> var1);

        public _FinalStage flightNumber(String var1);

        public _FinalStage flightNumber(Nullable<String> var1);
    }

    public static interface SchemaVersionStage {
        public _FinalStage schemaVersion(int var1);

        public Builder from(TaskClientCreate1 var1);
    }
}

