/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TaskGroupMessage1;
import com.chrt.api.types.TaskGroupMileage1;
import com.chrt.api.types.TaskGroupStatusEnum1;
import com.chrt.api.types.TaskGroupTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskGroup1 {
    private final int schemaVersion;
    private final String id;
    private final String orderId;
    private final String orderShortId;
    private final Optional<List<String>> taskIds;
    private final String createdByOrgId;
    private final String createdByUserId;
    private final Optional<String> courierOrgId;
    private final Optional<String> driverId;
    private final Optional<List<String>> taskGroupS3ObjectMetadataIds;
    private final Optional<TaskGroupStatusEnum1> status;
    private final OffsetDateTime draftStartedAtTimestamp;
    private final Optional<OffsetDateTime> stagedAtTimestamp;
    private final Optional<OffsetDateTime> inProgressAtTimestamp;
    private final Optional<OffsetDateTime> completedAtTimestamp;
    private final Optional<OffsetDateTime> skippedAtTimestamp;
    private final Optional<OffsetDateTime> exceptionAtTimestamp;
    private final Optional<Boolean> orderCancelled;
    private final TaskGroupTypeEnum1 taskGroupType;
    private final Optional<TaskGroupMileage1> taskGroupMileage;
    private final Optional<String> flightNumber;
    private final Optional<List<TaskGroupMessage1>> messages;
    private final Map<String, Object> additionalProperties;

    private TaskGroup1(int schemaVersion, String id, String orderId, String orderShortId, Optional<List<String>> taskIds, String createdByOrgId, String createdByUserId, Optional<String> courierOrgId, Optional<String> driverId, Optional<List<String>> taskGroupS3ObjectMetadataIds, Optional<TaskGroupStatusEnum1> status, OffsetDateTime draftStartedAtTimestamp, Optional<OffsetDateTime> stagedAtTimestamp, Optional<OffsetDateTime> inProgressAtTimestamp, Optional<OffsetDateTime> completedAtTimestamp, Optional<OffsetDateTime> skippedAtTimestamp, Optional<OffsetDateTime> exceptionAtTimestamp, Optional<Boolean> orderCancelled, TaskGroupTypeEnum1 taskGroupType, Optional<TaskGroupMileage1> taskGroupMileage, Optional<String> flightNumber, Optional<List<TaskGroupMessage1>> messages, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.taskIds = taskIds;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.courierOrgId = courierOrgId;
        this.driverId = driverId;
        this.taskGroupS3ObjectMetadataIds = taskGroupS3ObjectMetadataIds;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.inProgressAtTimestamp = inProgressAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.skippedAtTimestamp = skippedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.orderCancelled = orderCancelled;
        this.taskGroupType = taskGroupType;
        this.taskGroupMileage = taskGroupMileage;
        this.flightNumber = flightNumber;
        this.messages = messages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="order_short_id")
    public String getOrderShortId() {
        return this.orderShortId;
    }

    @JsonProperty(value="task_ids")
    public Optional<List<String>> getTaskIds() {
        return this.taskIds;
    }

    @JsonProperty(value="created_by_org_id")
    public String getCreatedByOrgId() {
        return this.createdByOrgId;
    }

    @JsonProperty(value="created_by_user_id")
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonIgnore
    public Optional<String> getCourierOrgId() {
        if (this.courierOrgId == null) {
            return Optional.empty();
        }
        return this.courierOrgId;
    }

    @JsonIgnore
    public Optional<String> getDriverId() {
        if (this.driverId == null) {
            return Optional.empty();
        }
        return this.driverId;
    }

    @JsonProperty(value="task_group_s3_object_metadata_ids")
    public Optional<List<String>> getTaskGroupS3ObjectMetadataIds() {
        return this.taskGroupS3ObjectMetadataIds;
    }

    @JsonProperty(value="status")
    public Optional<TaskGroupStatusEnum1> getStatus() {
        return this.status;
    }

    @JsonProperty(value="draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return this.draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (this.stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getInProgressAtTimestamp() {
        if (this.inProgressAtTimestamp == null) {
            return Optional.empty();
        }
        return this.inProgressAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (this.completedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getSkippedAtTimestamp() {
        if (this.skippedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.skippedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (this.exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return this.exceptionAtTimestamp;
    }

    @JsonProperty(value="order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return this.orderCancelled;
    }

    @JsonProperty(value="task_group_type")
    public TaskGroupTypeEnum1 getTaskGroupType() {
        return this.taskGroupType;
    }

    @JsonIgnore
    public Optional<TaskGroupMileage1> getTaskGroupMileage() {
        if (this.taskGroupMileage == null) {
            return Optional.empty();
        }
        return this.taskGroupMileage;
    }

    @JsonIgnore
    public Optional<String> getFlightNumber() {
        if (this.flightNumber == null) {
            return Optional.empty();
        }
        return this.flightNumber;
    }

    @JsonProperty(value="messages")
    public Optional<List<TaskGroupMessage1>> getMessages() {
        return this.messages;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="courier_org_id")
    private Optional<String> _getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="driver_id")
    private Optional<String> _getDriverId() {
        return this.driverId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return this.stagedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="in_progress_at_timestamp")
    private Optional<OffsetDateTime> _getInProgressAtTimestamp() {
        return this.inProgressAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return this.completedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="skipped_at_timestamp")
    private Optional<OffsetDateTime> _getSkippedAtTimestamp() {
        return this.skippedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return this.exceptionAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="task_group_mileage")
    private Optional<TaskGroupMileage1> _getTaskGroupMileage() {
        return this.taskGroupMileage;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="flight_number")
    private Optional<String> _getFlightNumber() {
        return this.flightNumber;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskGroup1 && this.equalTo((TaskGroup1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroup1 other) {
        return this.schemaVersion == other.schemaVersion && this.id.equals(other.id) && this.orderId.equals(other.orderId) && this.orderShortId.equals(other.orderShortId) && this.taskIds.equals(other.taskIds) && this.createdByOrgId.equals(other.createdByOrgId) && this.createdByUserId.equals(other.createdByUserId) && this.courierOrgId.equals(other.courierOrgId) && this.driverId.equals(other.driverId) && this.taskGroupS3ObjectMetadataIds.equals(other.taskGroupS3ObjectMetadataIds) && this.status.equals(other.status) && this.draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp) && this.stagedAtTimestamp.equals(other.stagedAtTimestamp) && this.inProgressAtTimestamp.equals(other.inProgressAtTimestamp) && this.completedAtTimestamp.equals(other.completedAtTimestamp) && this.skippedAtTimestamp.equals(other.skippedAtTimestamp) && this.exceptionAtTimestamp.equals(other.exceptionAtTimestamp) && this.orderCancelled.equals(other.orderCancelled) && this.taskGroupType.equals(other.taskGroupType) && this.taskGroupMileage.equals(other.taskGroupMileage) && this.flightNumber.equals(other.flightNumber) && this.messages.equals(other.messages);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.id, this.orderId, this.orderShortId, this.taskIds, this.createdByOrgId, this.createdByUserId, this.courierOrgId, this.driverId, this.taskGroupS3ObjectMetadataIds, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.inProgressAtTimestamp, this.completedAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp, this.orderCancelled, this.taskGroupType, this.taskGroupMileage, this.flightNumber, this.messages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    OrderIdStage,
    OrderShortIdStage,
    CreatedByOrgIdStage,
    CreatedByUserIdStage,
    DraftStartedAtTimestampStage,
    TaskGroupTypeStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private String orderId;
        private String orderShortId;
        private String createdByOrgId;
        private String createdByUserId;
        private OffsetDateTime draftStartedAtTimestamp;
        private TaskGroupTypeEnum1 taskGroupType;
        private Optional<List<TaskGroupMessage1>> messages = Optional.empty();
        private Optional<String> flightNumber = Optional.empty();
        private Optional<TaskGroupMileage1> taskGroupMileage = Optional.empty();
        private Optional<Boolean> orderCancelled = Optional.empty();
        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> skippedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> inProgressAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();
        private Optional<TaskGroupStatusEnum1> status = Optional.empty();
        private Optional<List<String>> taskGroupS3ObjectMetadataIds = Optional.empty();
        private Optional<String> driverId = Optional.empty();
        private Optional<String> courierOrgId = Optional.empty();
        private Optional<List<String>> taskIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskGroup1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.id(other.getId());
            this.orderId(other.getOrderId());
            this.orderShortId(other.getOrderShortId());
            this.taskIds(other.getTaskIds());
            this.createdByOrgId(other.getCreatedByOrgId());
            this.createdByUserId(other.getCreatedByUserId());
            this.courierOrgId(other.getCourierOrgId());
            this.driverId(other.getDriverId());
            this.taskGroupS3ObjectMetadataIds(other.getTaskGroupS3ObjectMetadataIds());
            this.status(other.getStatus());
            this.draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            this.stagedAtTimestamp(other.getStagedAtTimestamp());
            this.inProgressAtTimestamp(other.getInProgressAtTimestamp());
            this.completedAtTimestamp(other.getCompletedAtTimestamp());
            this.skippedAtTimestamp(other.getSkippedAtTimestamp());
            this.exceptionAtTimestamp(other.getExceptionAtTimestamp());
            this.orderCancelled(other.getOrderCancelled());
            this.taskGroupType(other.getTaskGroupType());
            this.taskGroupMileage(other.getTaskGroupMileage());
            this.flightNumber(other.getFlightNumber());
            this.messages(other.getMessages());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_short_id")
        public CreatedByOrgIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="draft_started_at_timestamp")
        public TaskGroupTypeStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp = Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_type")
        public _FinalStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType) {
            this.taskGroupType = Objects.requireNonNull(taskGroupType, "taskGroupType must not be null");
            return this;
        }

        @Override
        public _FinalStage messages(List<TaskGroupMessage1> messages) {
            this.messages = Optional.ofNullable(messages);
            return this;
        }

        @Override
        @JsonSetter(value="messages", nulls=Nulls.SKIP)
        public _FinalStage messages(Optional<List<TaskGroupMessage1>> messages) {
            this.messages = messages;
            return this;
        }

        @Override
        public _FinalStage flightNumber(Nullable<String> flightNumber) {
            this.flightNumber = flightNumber.isNull() ? null : (flightNumber.isEmpty() ? Optional.empty() : Optional.of(flightNumber.get()));
            return this;
        }

        @Override
        public _FinalStage flightNumber(String flightNumber) {
            this.flightNumber = Optional.ofNullable(flightNumber);
            return this;
        }

        @Override
        @JsonSetter(value="flight_number", nulls=Nulls.SKIP)
        public _FinalStage flightNumber(Optional<String> flightNumber) {
            this.flightNumber = flightNumber;
            return this;
        }

        @Override
        public _FinalStage taskGroupMileage(Nullable<TaskGroupMileage1> taskGroupMileage) {
            this.taskGroupMileage = taskGroupMileage.isNull() ? null : (taskGroupMileage.isEmpty() ? Optional.empty() : Optional.of(taskGroupMileage.get()));
            return this;
        }

        @Override
        public _FinalStage taskGroupMileage(TaskGroupMileage1 taskGroupMileage) {
            this.taskGroupMileage = Optional.ofNullable(taskGroupMileage);
            return this;
        }

        @Override
        @JsonSetter(value="task_group_mileage", nulls=Nulls.SKIP)
        public _FinalStage taskGroupMileage(Optional<TaskGroupMileage1> taskGroupMileage) {
            this.taskGroupMileage = taskGroupMileage;
            return this;
        }

        @Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @Override
        @JsonSetter(value="order_cancelled", nulls=Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp.isNull() ? null : (exceptionAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(exceptionAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="exception_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp.isNull() ? null : (skippedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(skippedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp) {
            this.skippedAtTimestamp = Optional.ofNullable(skippedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="skipped_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp.isNull() ? null : (completedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(completedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="completed_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp) {
            this.inProgressAtTimestamp = inProgressAtTimestamp.isNull() ? null : (inProgressAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(inProgressAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp) {
            this.inProgressAtTimestamp = Optional.ofNullable(inProgressAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="in_progress_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp) {
            this.inProgressAtTimestamp = inProgressAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp.isNull() ? null : (stagedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(stagedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="staged_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage status(TaskGroupStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<TaskGroupStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage taskGroupS3ObjectMetadataIds(List<String> taskGroupS3ObjectMetadataIds) {
            this.taskGroupS3ObjectMetadataIds = Optional.ofNullable(taskGroupS3ObjectMetadataIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_group_s3_object_metadata_ids", nulls=Nulls.SKIP)
        public _FinalStage taskGroupS3ObjectMetadataIds(Optional<List<String>> taskGroupS3ObjectMetadataIds) {
            this.taskGroupS3ObjectMetadataIds = taskGroupS3ObjectMetadataIds;
            return this;
        }

        @Override
        public _FinalStage driverId(Nullable<String> driverId) {
            this.driverId = driverId.isNull() ? null : (driverId.isEmpty() ? Optional.empty() : Optional.of(driverId.get()));
            return this;
        }

        @Override
        public _FinalStage driverId(String driverId) {
            this.driverId = Optional.ofNullable(driverId);
            return this;
        }

        @Override
        @JsonSetter(value="driver_id", nulls=Nulls.SKIP)
        public _FinalStage driverId(Optional<String> driverId) {
            this.driverId = driverId;
            return this;
        }

        @Override
        public _FinalStage courierOrgId(Nullable<String> courierOrgId) {
            this.courierOrgId = courierOrgId.isNull() ? null : (courierOrgId.isEmpty() ? Optional.empty() : Optional.of(courierOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage courierOrgId(String courierOrgId) {
            this.courierOrgId = Optional.ofNullable(courierOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id", nulls=Nulls.SKIP)
        public _FinalStage courierOrgId(Optional<String> courierOrgId) {
            this.courierOrgId = courierOrgId;
            return this;
        }

        @Override
        public _FinalStage taskIds(List<String> taskIds) {
            this.taskIds = Optional.ofNullable(taskIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_ids", nulls=Nulls.SKIP)
        public _FinalStage taskIds(Optional<List<String>> taskIds) {
            this.taskIds = taskIds;
            return this;
        }

        @Override
        public TaskGroup1 build() {
            return new TaskGroup1(this.schemaVersion, this.id, this.orderId, this.orderShortId, this.taskIds, this.createdByOrgId, this.createdByUserId, this.courierOrgId, this.driverId, this.taskGroupS3ObjectMetadataIds, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.inProgressAtTimestamp, this.completedAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp, this.orderCancelled, this.taskGroupType, this.taskGroupMileage, this.flightNumber, this.messages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskGroup1 build();

        public _FinalStage taskIds(Optional<List<String>> var1);

        public _FinalStage taskIds(List<String> var1);

        public _FinalStage courierOrgId(Optional<String> var1);

        public _FinalStage courierOrgId(String var1);

        public _FinalStage courierOrgId(Nullable<String> var1);

        public _FinalStage driverId(Optional<String> var1);

        public _FinalStage driverId(String var1);

        public _FinalStage driverId(Nullable<String> var1);

        public _FinalStage taskGroupS3ObjectMetadataIds(Optional<List<String>> var1);

        public _FinalStage taskGroupS3ObjectMetadataIds(List<String> var1);

        public _FinalStage status(Optional<TaskGroupStatusEnum1> var1);

        public _FinalStage status(TaskGroupStatusEnum1 var1);

        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stagedAtTimestamp(OffsetDateTime var1);

        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage inProgressAtTimestamp(OffsetDateTime var1);

        public _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(OffsetDateTime var1);

        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(OffsetDateTime var1);

        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(OffsetDateTime var1);

        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage orderCancelled(Optional<Boolean> var1);

        public _FinalStage orderCancelled(Boolean var1);

        public _FinalStage taskGroupMileage(Optional<TaskGroupMileage1> var1);

        public _FinalStage taskGroupMileage(TaskGroupMileage1 var1);

        public _FinalStage taskGroupMileage(Nullable<TaskGroupMileage1> var1);

        public _FinalStage flightNumber(Optional<String> var1);

        public _FinalStage flightNumber(String var1);

        public _FinalStage flightNumber(Nullable<String> var1);

        public _FinalStage messages(Optional<List<TaskGroupMessage1>> var1);

        public _FinalStage messages(List<TaskGroupMessage1> var1);
    }

    public static interface TaskGroupTypeStage {
        public _FinalStage taskGroupType(@NotNull TaskGroupTypeEnum1 var1);
    }

    public static interface DraftStartedAtTimestampStage {
        public TaskGroupTypeStage draftStartedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedByUserIdStage {
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String var1);
    }

    public static interface CreatedByOrgIdStage {
        public CreatedByUserIdStage createdByOrgId(@NotNull String var1);
    }

    public static interface OrderShortIdStage {
        public CreatedByOrgIdStage orderShortId(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public OrderShortIdStage orderId(@NotNull String var1);
    }

    public static interface IdStage {
        public OrderIdStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(TaskGroup1 var1);
    }
}

