/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskGroupByDriverSharingSettings1 {
    private final int schemaVersion;
    private final String taskGroupId;
    private final String driverId;
    private final Optional<Boolean> public_;
    private final Optional<String> lastChangedByUserId;
    private final Optional<String> lastChangedByOrgId;
    private final Optional<OffsetDateTime> lastChangedTimestamp;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private TaskGroupByDriverSharingSettings1(int schemaVersion, String taskGroupId, String driverId, Optional<Boolean> public_, Optional<String> lastChangedByUserId, Optional<String> lastChangedByOrgId, Optional<OffsetDateTime> lastChangedTimestamp, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.taskGroupId = taskGroupId;
        this.driverId = driverId;
        this.public_ = public_;
        this.lastChangedByUserId = lastChangedByUserId;
        this.lastChangedByOrgId = lastChangedByOrgId;
        this.lastChangedTimestamp = lastChangedTimestamp;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="driver_id")
    public String getDriverId() {
        return this.driverId;
    }

    @JsonProperty(value="public")
    public Optional<Boolean> getPublic() {
        return this.public_;
    }

    @JsonIgnore
    public Optional<String> getLastChangedByUserId() {
        if (this.lastChangedByUserId == null) {
            return Optional.empty();
        }
        return this.lastChangedByUserId;
    }

    @JsonIgnore
    public Optional<String> getLastChangedByOrgId() {
        if (this.lastChangedByOrgId == null) {
            return Optional.empty();
        }
        return this.lastChangedByOrgId;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLastChangedTimestamp() {
        if (this.lastChangedTimestamp == null) {
            return Optional.empty();
        }
        return this.lastChangedTimestamp;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_changed_by_user_id")
    private Optional<String> _getLastChangedByUserId() {
        return this.lastChangedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_changed_by_org_id")
    private Optional<String> _getLastChangedByOrgId() {
        return this.lastChangedByOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_changed_timestamp")
    private Optional<OffsetDateTime> _getLastChangedTimestamp() {
        return this.lastChangedTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskGroupByDriverSharingSettings1 && this.equalTo((TaskGroupByDriverSharingSettings1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupByDriverSharingSettings1 other) {
        return this.schemaVersion == other.schemaVersion && this.taskGroupId.equals(other.taskGroupId) && this.driverId.equals(other.driverId) && this.public_.equals(other.public_) && this.lastChangedByUserId.equals(other.lastChangedByUserId) && this.lastChangedByOrgId.equals(other.lastChangedByOrgId) && this.lastChangedTimestamp.equals(other.lastChangedTimestamp) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.taskGroupId, this.driverId, this.public_, this.lastChangedByUserId, this.lastChangedByOrgId, this.lastChangedTimestamp, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    TaskGroupIdStage,
    DriverIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String taskGroupId;
        private String driverId;
        private String id;
        private Optional<OffsetDateTime> lastChangedTimestamp = Optional.empty();
        private Optional<String> lastChangedByOrgId = Optional.empty();
        private Optional<String> lastChangedByUserId = Optional.empty();
        private Optional<Boolean> public_ = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskGroupByDriverSharingSettings1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.taskGroupId(other.getTaskGroupId());
            this.driverId(other.getDriverId());
            this.public_(other.getPublic());
            this.lastChangedByUserId(other.getLastChangedByUserId());
            this.lastChangedByOrgId(other.getLastChangedByOrgId());
            this.lastChangedTimestamp(other.getLastChangedTimestamp());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public TaskGroupIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public DriverIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="driver_id")
        public IdStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage lastChangedTimestamp(Nullable<OffsetDateTime> lastChangedTimestamp) {
            this.lastChangedTimestamp = lastChangedTimestamp.isNull() ? null : (lastChangedTimestamp.isEmpty() ? Optional.empty() : Optional.of(lastChangedTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage lastChangedTimestamp(OffsetDateTime lastChangedTimestamp) {
            this.lastChangedTimestamp = Optional.ofNullable(lastChangedTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="last_changed_timestamp", nulls=Nulls.SKIP)
        public _FinalStage lastChangedTimestamp(Optional<OffsetDateTime> lastChangedTimestamp) {
            this.lastChangedTimestamp = lastChangedTimestamp;
            return this;
        }

        @Override
        public _FinalStage lastChangedByOrgId(Nullable<String> lastChangedByOrgId) {
            this.lastChangedByOrgId = lastChangedByOrgId.isNull() ? null : (lastChangedByOrgId.isEmpty() ? Optional.empty() : Optional.of(lastChangedByOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage lastChangedByOrgId(String lastChangedByOrgId) {
            this.lastChangedByOrgId = Optional.ofNullable(lastChangedByOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="last_changed_by_org_id", nulls=Nulls.SKIP)
        public _FinalStage lastChangedByOrgId(Optional<String> lastChangedByOrgId) {
            this.lastChangedByOrgId = lastChangedByOrgId;
            return this;
        }

        @Override
        public _FinalStage lastChangedByUserId(Nullable<String> lastChangedByUserId) {
            this.lastChangedByUserId = lastChangedByUserId.isNull() ? null : (lastChangedByUserId.isEmpty() ? Optional.empty() : Optional.of(lastChangedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage lastChangedByUserId(String lastChangedByUserId) {
            this.lastChangedByUserId = Optional.ofNullable(lastChangedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="last_changed_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage lastChangedByUserId(Optional<String> lastChangedByUserId) {
            this.lastChangedByUserId = lastChangedByUserId;
            return this;
        }

        @Override
        public _FinalStage public_(Boolean public_) {
            this.public_ = Optional.ofNullable(public_);
            return this;
        }

        @Override
        @JsonSetter(value="public", nulls=Nulls.SKIP)
        public _FinalStage public_(Optional<Boolean> public_) {
            this.public_ = public_;
            return this;
        }

        @Override
        public TaskGroupByDriverSharingSettings1 build() {
            return new TaskGroupByDriverSharingSettings1(this.schemaVersion, this.taskGroupId, this.driverId, this.public_, this.lastChangedByUserId, this.lastChangedByOrgId, this.lastChangedTimestamp, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskGroupByDriverSharingSettings1 build();

        public _FinalStage public_(Optional<Boolean> var1);

        public _FinalStage public_(Boolean var1);

        public _FinalStage lastChangedByUserId(Optional<String> var1);

        public _FinalStage lastChangedByUserId(String var1);

        public _FinalStage lastChangedByUserId(Nullable<String> var1);

        public _FinalStage lastChangedByOrgId(Optional<String> var1);

        public _FinalStage lastChangedByOrgId(String var1);

        public _FinalStage lastChangedByOrgId(Nullable<String> var1);

        public _FinalStage lastChangedTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage lastChangedTimestamp(OffsetDateTime var1);

        public _FinalStage lastChangedTimestamp(Nullable<OffsetDateTime> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface DriverIdStage {
        public IdStage driverId(@NotNull String var1);
    }

    public static interface TaskGroupIdStage {
        public DriverIdStage taskGroupId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public TaskGroupIdStage schemaVersion(int var1);

        public Builder from(TaskGroupByDriverSharingSettings1 var1);
    }
}

