/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskGroupMessage1 {
    private final String message;
    private final String userId;
    private final String orgId;
    private final OffsetDateTime timestamp;
    private final Map<String, Object> additionalProperties;

    private TaskGroupMessage1(String message, String userId, String orgId, OffsetDateTime timestamp, Map<String, Object> additionalProperties) {
        this.message = message;
        this.userId = userId;
        this.orgId = orgId;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskGroupMessage1 && this.equalTo((TaskGroupMessage1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupMessage1 other) {
        return this.message.equals(other.message) && this.userId.equals(other.userId) && this.orgId.equals(other.orgId) && this.timestamp.equals(other.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.userId, this.orgId, this.timestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageStage,
    UserIdStage,
    OrgIdStage,
    TimestampStage,
    _FinalStage {
        private String message;
        private String userId;
        private String orgId;
        private OffsetDateTime timestamp;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskGroupMessage1 other) {
            this.message(other.getMessage());
            this.userId(other.getUserId());
            this.orgId(other.getOrgId());
            this.timestamp(other.getTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public UserIdStage message(@NotNull String message) {
            this.message = Objects.requireNonNull(message, "message must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public OrgIdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="org_id")
        public TimestampStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public _FinalStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        public TaskGroupMessage1 build() {
            return new TaskGroupMessage1(this.message, this.userId, this.orgId, this.timestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskGroupMessage1 build();
    }

    public static interface TimestampStage {
        public _FinalStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface OrgIdStage {
        public TimestampStage orgId(@NotNull String var1);
    }

    public static interface UserIdStage {
        public OrgIdStage userId(@NotNull String var1);
    }

    public static interface MessageStage {
        public UserIdStage message(@NotNull String var1);

        public Builder from(TaskGroupMessage1 var1);
    }
}

