/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TimeWindow1 {
    private final Optional<OffsetDateTime> leftBoundaryTimestamp;
    private final Optional<OffsetDateTime> rightBoundaryTimestamp;
    private final Map<String, Object> additionalProperties;

    private TimeWindow1(Optional<OffsetDateTime> leftBoundaryTimestamp, Optional<OffsetDateTime> rightBoundaryTimestamp, Map<String, Object> additionalProperties) {
        this.leftBoundaryTimestamp = leftBoundaryTimestamp;
        this.rightBoundaryTimestamp = rightBoundaryTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLeftBoundaryTimestamp() {
        if (this.leftBoundaryTimestamp == null) {
            return Optional.empty();
        }
        return this.leftBoundaryTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getRightBoundaryTimestamp() {
        if (this.rightBoundaryTimestamp == null) {
            return Optional.empty();
        }
        return this.rightBoundaryTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="left_boundary_timestamp")
    private Optional<OffsetDateTime> _getLeftBoundaryTimestamp() {
        return this.leftBoundaryTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="right_boundary_timestamp")
    private Optional<OffsetDateTime> _getRightBoundaryTimestamp() {
        return this.rightBoundaryTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TimeWindow1 && this.equalTo((TimeWindow1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimeWindow1 other) {
        return this.leftBoundaryTimestamp.equals(other.leftBoundaryTimestamp) && this.rightBoundaryTimestamp.equals(other.rightBoundaryTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.leftBoundaryTimestamp, this.rightBoundaryTimestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> leftBoundaryTimestamp = Optional.empty();
        private Optional<OffsetDateTime> rightBoundaryTimestamp = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TimeWindow1 other) {
            this.leftBoundaryTimestamp(other.getLeftBoundaryTimestamp());
            this.rightBoundaryTimestamp(other.getRightBoundaryTimestamp());
            return this;
        }

        @JsonSetter(value="left_boundary_timestamp", nulls=Nulls.SKIP)
        public Builder leftBoundaryTimestamp(Optional<OffsetDateTime> leftBoundaryTimestamp) {
            this.leftBoundaryTimestamp = leftBoundaryTimestamp;
            return this;
        }

        public Builder leftBoundaryTimestamp(OffsetDateTime leftBoundaryTimestamp) {
            this.leftBoundaryTimestamp = Optional.ofNullable(leftBoundaryTimestamp);
            return this;
        }

        public Builder leftBoundaryTimestamp(Nullable<OffsetDateTime> leftBoundaryTimestamp) {
            this.leftBoundaryTimestamp = leftBoundaryTimestamp.isNull() ? null : (leftBoundaryTimestamp.isEmpty() ? Optional.empty() : Optional.of(leftBoundaryTimestamp.get()));
            return this;
        }

        @JsonSetter(value="right_boundary_timestamp", nulls=Nulls.SKIP)
        public Builder rightBoundaryTimestamp(Optional<OffsetDateTime> rightBoundaryTimestamp) {
            this.rightBoundaryTimestamp = rightBoundaryTimestamp;
            return this;
        }

        public Builder rightBoundaryTimestamp(OffsetDateTime rightBoundaryTimestamp) {
            this.rightBoundaryTimestamp = Optional.ofNullable(rightBoundaryTimestamp);
            return this;
        }

        public Builder rightBoundaryTimestamp(Nullable<OffsetDateTime> rightBoundaryTimestamp) {
            this.rightBoundaryTimestamp = rightBoundaryTimestamp.isNull() ? null : (rightBoundaryTimestamp.isEmpty() ? Optional.empty() : Optional.of(rightBoundaryTimestamp.get()));
            return this;
        }

        public TimeWindow1 build() {
            return new TimeWindow1(this.leftBoundaryTimestamp, this.rightBoundaryTimestamp, this.additionalProperties);
        }
    }
}

