/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ValidationErrorLocItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ValidationError {
    private final List<ValidationErrorLocItem> loc;
    private final String msg;
    private final String type;
    private final Map<String, Object> additionalProperties;

    private ValidationError(List<ValidationErrorLocItem> loc, String msg, String type, Map<String, Object> additionalProperties) {
        this.loc = loc;
        this.msg = msg;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="loc")
    public List<ValidationErrorLocItem> getLoc() {
        return this.loc;
    }

    @JsonProperty(value="msg")
    public String getMsg() {
        return this.msg;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ValidationError && this.equalTo((ValidationError)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ValidationError other) {
        return this.loc.equals(other.loc) && this.msg.equals(other.msg) && this.type.equals(other.type);
    }

    public int hashCode() {
        return Objects.hash(this.loc, this.msg, this.type);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MsgStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MsgStage,
    TypeStage,
    _FinalStage {
        private String msg;
        private String type;
        private List<ValidationErrorLocItem> loc = new ArrayList<ValidationErrorLocItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ValidationError other) {
            this.loc(other.getLoc());
            this.msg(other.getMsg());
            this.type(other.getType());
            return this;
        }

        @Override
        @JsonSetter(value="msg")
        public TypeStage msg(@NotNull String msg) {
            this.msg = Objects.requireNonNull(msg, "msg must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllLoc(List<ValidationErrorLocItem> loc) {
            if (loc != null) {
                this.loc.addAll(loc);
            }
            return this;
        }

        @Override
        public _FinalStage addLoc(ValidationErrorLocItem loc) {
            this.loc.add(loc);
            return this;
        }

        @Override
        @JsonSetter(value="loc", nulls=Nulls.SKIP)
        public _FinalStage loc(List<ValidationErrorLocItem> loc) {
            this.loc.clear();
            if (loc != null) {
                this.loc.addAll(loc);
            }
            return this;
        }

        @Override
        public ValidationError build() {
            return new ValidationError(this.loc, this.msg, this.type, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ValidationError build();

        public _FinalStage loc(List<ValidationErrorLocItem> var1);

        public _FinalStage addLoc(ValidationErrorLocItem var1);

        public _FinalStage addAllLoc(List<ValidationErrorLocItem> var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull String var1);
    }

    public static interface MsgStage {
        public TypeStage msg(@NotNull String var1);

        public Builder from(ValidationError var1);
    }
}

