/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.billing.BillingClient;
import com.chrt.api.resources.cargos.CargosClient;
import com.chrt.api.resources.connections.ConnectionsClient;
import com.chrt.api.resources.dev.DevClient;
import com.chrt.api.resources.drivers.DriversClient;
import com.chrt.api.resources.flights.FlightsClient;
import com.chrt.api.resources.notifications.NotificationsClient;
import com.chrt.api.resources.offchrtshipperorg.OffChrtShipperOrgClient;
import com.chrt.api.resources.orderdrafts.OrderDraftsClient;
import com.chrt.api.resources.orders.OrdersClient;
import com.chrt.api.resources.orginfoforconnections.OrgInfoForConnectionsClient;
import com.chrt.api.resources.orgprofiles.OrgProfilesClient;
import com.chrt.api.resources.orgs.OrgsClient;
import com.chrt.api.resources.payments.PaymentsClient;
import com.chrt.api.resources.root.RootClient;
import com.chrt.api.resources.shippercontactinfo.ShipperContactInfoClient;
import com.chrt.api.resources.taskartifactnotifications.TaskArtifactNotificationsClient;
import com.chrt.api.resources.taskartifacts.TaskArtifactsClient;
import com.chrt.api.resources.taskgroups.TaskGroupsClient;
import com.chrt.api.resources.tasks.TasksClient;
import com.chrt.api.resources.tracking.TrackingClient;
import com.chrt.api.resources.users.UsersClient;
import com.chrt.api.resources.utils.UtilsClient;
import java.util.function.Supplier;

public class ChrtApiClient {
    protected final ClientOptions clientOptions;

    protected final Supplier<PaymentsClient> paymentsClient;

    protected final Supplier<ConnectionsClient> connectionsClient;

    protected final Supplier<OrgProfilesClient> orgProfilesClient;

    protected final Supplier<DevClient> devClient;

    protected final Supplier<FlightsClient> flightsClient;

    protected final Supplier<TaskArtifactNotificationsClient> taskArtifactNotificationsClient;

    protected final Supplier<DriversClient> driversClient;

    protected final Supplier<CargosClient> cargosClient;

    protected final Supplier<TaskArtifactsClient> taskArtifactsClient;

    protected final Supplier<OffChrtShipperOrgClient> offChrtShipperOrgClient;

    protected final Supplier<OrdersClient> ordersClient;

    protected final Supplier<OrderDraftsClient> orderDraftsClient;

    protected final Supplier<TaskGroupsClient> taskGroupsClient;

    protected final Supplier<TasksClient> tasksClient;

    protected final Supplier<ShipperContactInfoClient> shipperContactInfoClient;

    protected final Supplier<OrgsClient> orgsClient;

    protected final Supplier<RootClient> rootClient;

    protected final Supplier<UsersClient> usersClient;

    protected final Supplier<UtilsClient> utilsClient;

    protected final Supplier<BillingClient> billingClient;

    protected final Supplier<NotificationsClient> notificationsClient;

    protected final Supplier<OrgInfoForConnectionsClient> orgInfoForConnectionsClient;

    protected final Supplier<TrackingClient> trackingClient;

    public ChrtApiClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.paymentsClient = Suppliers.memoize(() -> new PaymentsClient(clientOptions));
        this.connectionsClient = Suppliers.memoize(() -> new ConnectionsClient(clientOptions));
        this.orgProfilesClient = Suppliers.memoize(() -> new OrgProfilesClient(clientOptions));
        this.devClient = Suppliers.memoize(() -> new DevClient(clientOptions));
        this.flightsClient = Suppliers.memoize(() -> new FlightsClient(clientOptions));
        this.taskArtifactNotificationsClient =
                Suppliers.memoize(() -> new TaskArtifactNotificationsClient(clientOptions));
        this.driversClient = Suppliers.memoize(() -> new DriversClient(clientOptions));
        this.cargosClient = Suppliers.memoize(() -> new CargosClient(clientOptions));
        this.taskArtifactsClient = Suppliers.memoize(() -> new TaskArtifactsClient(clientOptions));
        this.offChrtShipperOrgClient = Suppliers.memoize(() -> new OffChrtShipperOrgClient(clientOptions));
        this.ordersClient = Suppliers.memoize(() -> new OrdersClient(clientOptions));
        this.orderDraftsClient = Suppliers.memoize(() -> new OrderDraftsClient(clientOptions));
        this.taskGroupsClient = Suppliers.memoize(() -> new TaskGroupsClient(clientOptions));
        this.tasksClient = Suppliers.memoize(() -> new TasksClient(clientOptions));
        this.shipperContactInfoClient = Suppliers.memoize(() -> new ShipperContactInfoClient(clientOptions));
        this.orgsClient = Suppliers.memoize(() -> new OrgsClient(clientOptions));
        this.rootClient = Suppliers.memoize(() -> new RootClient(clientOptions));
        this.usersClient = Suppliers.memoize(() -> new UsersClient(clientOptions));
        this.utilsClient = Suppliers.memoize(() -> new UtilsClient(clientOptions));
        this.billingClient = Suppliers.memoize(() -> new BillingClient(clientOptions));
        this.notificationsClient = Suppliers.memoize(() -> new NotificationsClient(clientOptions));
        this.orgInfoForConnectionsClient = Suppliers.memoize(() -> new OrgInfoForConnectionsClient(clientOptions));
        this.trackingClient = Suppliers.memoize(() -> new TrackingClient(clientOptions));
    }

    public PaymentsClient payments() {
        return this.paymentsClient.get();
    }

    public ConnectionsClient connections() {
        return this.connectionsClient.get();
    }

    public OrgProfilesClient orgProfiles() {
        return this.orgProfilesClient.get();
    }

    public DevClient dev() {
        return this.devClient.get();
    }

    public FlightsClient flights() {
        return this.flightsClient.get();
    }

    public TaskArtifactNotificationsClient taskArtifactNotifications() {
        return this.taskArtifactNotificationsClient.get();
    }

    public DriversClient drivers() {
        return this.driversClient.get();
    }

    public CargosClient cargos() {
        return this.cargosClient.get();
    }

    public TaskArtifactsClient taskArtifacts() {
        return this.taskArtifactsClient.get();
    }

    public OffChrtShipperOrgClient offChrtShipperOrg() {
        return this.offChrtShipperOrgClient.get();
    }

    public OrdersClient orders() {
        return this.ordersClient.get();
    }

    public OrderDraftsClient orderDrafts() {
        return this.orderDraftsClient.get();
    }

    public TaskGroupsClient taskGroups() {
        return this.taskGroupsClient.get();
    }

    public TasksClient tasks() {
        return this.tasksClient.get();
    }

    public ShipperContactInfoClient shipperContactInfo() {
        return this.shipperContactInfoClient.get();
    }

    public OrgsClient orgs() {
        return this.orgsClient.get();
    }

    public RootClient root() {
        return this.rootClient.get();
    }

    public UsersClient users() {
        return this.usersClient.get();
    }

    public UtilsClient utils() {
        return this.utilsClient.get();
    }

    public BillingClient billing() {
        return this.billingClient.get();
    }

    public NotificationsClient notifications() {
        return this.notificationsClient.get();
    }

    public OrgInfoForConnectionsClient orgInfoForConnections() {
        return this.orgInfoForConnectionsClient.get();
    }

    public TrackingClient tracking() {
        return this.trackingClient.get();
    }

    public static ChrtApiClientBuilder builder() {
        return new ChrtApiClientBuilder();
    }
}
