/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.billing.lineitemgroups.LineItemGroupsClient;
import com.chrt.api.resources.billing.ratesheets.RateSheetsClient;
import com.chrt.api.resources.billing.statements.StatementsClient;
import com.chrt.api.resources.billing.stripeconnect.StripeConnectClient;
import java.util.function.Supplier;

public class BillingClient {
    protected final ClientOptions clientOptions;

    protected final Supplier<LineItemGroupsClient> lineItemGroupsClient;

    protected final Supplier<RateSheetsClient> rateSheetsClient;

    protected final Supplier<StatementsClient> statementsClient;

    protected final Supplier<StripeConnectClient> stripeConnectClient;

    public BillingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.lineItemGroupsClient = Suppliers.memoize(() -> new LineItemGroupsClient(clientOptions));
        this.rateSheetsClient = Suppliers.memoize(() -> new RateSheetsClient(clientOptions));
        this.statementsClient = Suppliers.memoize(() -> new StatementsClient(clientOptions));
        this.stripeConnectClient = Suppliers.memoize(() -> new StripeConnectClient(clientOptions));
    }

    public LineItemGroupsClient lineItemGroups() {
        return this.lineItemGroupsClient.get();
    }

    public RateSheetsClient rateSheets() {
        return this.rateSheetsClient.get();
    }

    public StatementsClient statements() {
        return this.statementsClient.get();
    }

    public StripeConnectClient stripeConnect() {
        return this.stripeConnectClient.get();
    }
}
