/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.AsyncAdHocClient;
import com.chrt.api.resources.billing.lineitemgroups.messages.AsyncMessagesClient;
import com.chrt.api.resources.billing.lineitemgroups.requests.AdjustLineItemReq;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsAssociateWithStatementV1Request;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsListForCourierOrgV1Request;
import com.chrt.api.resources.billing.lineitemgroups.s3objects.AsyncS3ObjectsClient;
import com.chrt.api.types.LineItemGroup1;
import com.chrt.api.types.LineItemGroupListRes;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncLineItemGroupsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawLineItemGroupsClient rawClient;

    protected final Supplier<AsyncAdHocClient> adHocClient;

    protected final Supplier<AsyncMessagesClient> messagesClient;

    protected final Supplier<AsyncS3ObjectsClient> s3ObjectsClient;

    public AsyncLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawLineItemGroupsClient(clientOptions);
        this.adHocClient = Suppliers.memoize(() -> new AsyncAdHocClient(clientOptions));
        this.messagesClient = Suppliers.memoize(() -> new AsyncMessagesClient(clientOptions));
        this.s3ObjectsClient = Suppliers.memoize(() -> new AsyncS3ObjectsClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Gets a line item group by ID. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> getV1(String lineItemGroupId) {
        return this.rawClient.getV1(lineItemGroupId).thenApply(response -> response.body());
    }

    /**
     * Gets a line item group by ID. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> getV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.getV1(lineItemGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists line item groups for the authenticated courier organization with filtering and pagination. | org_type=[courier], min_org_role=operator | () -&gt; (LineItemGroupListRes)
     */
    public CompletableFuture<LineItemGroupListRes> listForCourierOrgV1() {
        return this.rawClient.listForCourierOrgV1().thenApply(response -> response.body());
    }

    /**
     * Lists line item groups for the authenticated courier organization with filtering and pagination. | org_type=[courier], min_org_role=operator | () -&gt; (LineItemGroupListRes)
     */
    public CompletableFuture<LineItemGroupListRes> listForCourierOrgV1(
            LineItemGroupsListForCourierOrgV1Request request) {
        return this.rawClient.listForCourierOrgV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists line item groups for the authenticated courier organization with filtering and pagination. | org_type=[courier], min_org_role=operator | () -&gt; (LineItemGroupListRes)
     */
    public CompletableFuture<LineItemGroupListRes> listForCourierOrgV1(
            LineItemGroupsListForCourierOrgV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForCourierOrgV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Finalizes a line item group. LIG must be in ADJUSTABLE status. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> finalizeV1(String lineItemGroupId) {
        return this.rawClient.finalizeV1(lineItemGroupId).thenApply(response -> response.body());
    }

    /**
     * Finalizes a line item group. LIG must be in ADJUSTABLE status. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> finalizeV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.finalizeV1(lineItemGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * (Re)calculates line items for a line item group. LIG must be PENDING_CALCULATION or ADJUSTABLE and must be associated with a TaskGroup. Note: Line item calculation normally happens automatically; this route is primarily for PENDING_CALCULATION LIGs where automatic calculation failed (e.g., due to third-party service failure). | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> calculateLineItemsV1(String lineItemGroupId) {
        return this.rawClient.calculateLineItemsV1(lineItemGroupId).thenApply(response -> response.body());
    }

    /**
     * (Re)calculates line items for a line item group. LIG must be PENDING_CALCULATION or ADJUSTABLE and must be associated with a TaskGroup. Note: Line item calculation normally happens automatically; this route is primarily for PENDING_CALCULATION LIGs where automatic calculation failed (e.g., due to third-party service failure). | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> calculateLineItemsV1(
            String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient
                .calculateLineItemsV1(lineItemGroupId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Associates a line item group with a statement. LIG must be PENDING_RATES, PENDING_CALCULATION, ADJUSTABLE, or FINALIZED (before OPEN). Statement must be OPEN. LIG payment info must match Statement. Also removes from previous statement if any. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators, statement_owner_operators] | (PydanticObjectId) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> associateWithStatementV1(
            String lineItemGroupId, LineItemGroupsAssociateWithStatementV1Request request) {
        return this.rawClient.associateWithStatementV1(lineItemGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Associates a line item group with a statement. LIG must be PENDING_RATES, PENDING_CALCULATION, ADJUSTABLE, or FINALIZED (before OPEN). Statement must be OPEN. LIG payment info must match Statement. Also removes from previous statement if any. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators, statement_owner_operators] | (PydanticObjectId) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> associateWithStatementV1(
            String lineItemGroupId,
            LineItemGroupsAssociateWithStatementV1Request request,
            RequestOptions requestOptions) {
        return this.rawClient
                .associateWithStatementV1(lineItemGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Adjusts a line item within a line item group. LIG must be ADJUSTABLE. Adjustment can be negative beyond item.amount to serve as a credit. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (AdjustLineItemReq) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> adjustLineItemV1(String lineItemGroupId, AdjustLineItemReq request) {
        return this.rawClient.adjustLineItemV1(lineItemGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Adjusts a line item within a line item group. LIG must be ADJUSTABLE. Adjustment can be negative beyond item.amount to serve as a credit. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (AdjustLineItemReq) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<LineItemGroup1> adjustLineItemV1(
            String lineItemGroupId, AdjustLineItemReq request, RequestOptions requestOptions) {
        return this.rawClient
                .adjustLineItemV1(lineItemGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    public AsyncAdHocClient adHoc() {
        return this.adHocClient.get();
    }

    public AsyncMessagesClient messages() {
        return this.messagesClient.get();
    }

    public AsyncS3ObjectsClient s3Objects() {
        return this.s3ObjectsClient.get();
    }
}
