/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.adhoc;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.AdHocRemoveLineItemV1Request;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.CreateAdHocLineItemGroupReq;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.LineItemClientCreate1;
import com.chrt.api.types.LineItemGroup1;

public class AdHocClient {
    protected final ClientOptions clientOptions;

    private final RawAdHocClient rawClient;

    public AdHocClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAdHocClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawAdHocClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates an ad-hoc line item group (not associated with a TaskGroup). Starts as ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator | (CreateAdHocLineItemGroupReq) -&gt; (LineItemGroup1)
     */
    public LineItemGroup1 createV1(CreateAdHocLineItemGroupReq request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates an ad-hoc line item group (not associated with a TaskGroup). Starts as ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator | (CreateAdHocLineItemGroupReq) -&gt; (LineItemGroup1)
     */
    public LineItemGroup1 createV1(CreateAdHocLineItemGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Adds a line item to an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (LineItemClientCreate1) -&gt; (LineItemGroup1)
     */
    public LineItemGroup1 addLineItemV1(String lineItemGroupId, LineItemClientCreate1 request) {
        return this.rawClient.addLineItemV1(lineItemGroupId, request).body();
    }

    /**
     * Adds a line item to an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (LineItemClientCreate1) -&gt; (LineItemGroup1)
     */
    public LineItemGroup1 addLineItemV1(
            String lineItemGroupId, LineItemClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient
                .addLineItemV1(lineItemGroupId, request, requestOptions)
                .body();
    }

    /**
     * Removes a line item from an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (line_item_uuid_str) -&gt; (LineItemGroup1)
     */
    public LineItemGroup1 removeLineItemV1(String lineItemGroupId, AdHocRemoveLineItemV1Request request) {
        return this.rawClient.removeLineItemV1(lineItemGroupId, request).body();
    }

    /**
     * Removes a line item from an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (line_item_uuid_str) -&gt; (LineItemGroup1)
     */
    public LineItemGroup1 removeLineItemV1(
            String lineItemGroupId, AdHocRemoveLineItemV1Request request, RequestOptions requestOptions) {
        return this.rawClient
                .removeLineItemV1(lineItemGroupId, request, requestOptions)
                .body();
    }

    /**
     * Deletes an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE or FINALIZED. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public boolean deleteV1(String lineItemGroupId) {
        return this.rawClient.deleteV1(lineItemGroupId).body();
    }

    /**
     * Deletes an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE or FINALIZED. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public boolean deleteV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(lineItemGroupId, requestOptions).body();
    }
}
