/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.adhoc;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.AdHocRemoveLineItemV1Request;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.CreateAdHocLineItemGroupReq;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.LineItemClientCreate1;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.LineItemGroup1;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawAdHocClient {
    protected final ClientOptions clientOptions;

    public AsyncRawAdHocClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Creates an ad-hoc line item group (not associated with a TaskGroup). Starts as ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator | (CreateAdHocLineItemGroupReq) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> createV1(CreateAdHocLineItemGroupReq request) {
        return createV1(request, null);
    }

    /**
     * Creates an ad-hoc line item group (not associated with a TaskGroup). Starts as ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator | (CreateAdHocLineItemGroupReq) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> createV1(
            CreateAdHocLineItemGroupReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("billing/line_item_groups/ad_hoc/create/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Adds a line item to an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (LineItemClientCreate1) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> addLineItemV1(
            String lineItemGroupId, LineItemClientCreate1 request) {
        return addLineItemV1(lineItemGroupId, request, null);
    }

    /**
     * Adds a line item to an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (LineItemClientCreate1) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> addLineItemV1(
            String lineItemGroupId, LineItemClientCreate1 request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("billing/line_item_groups/ad_hoc/add_line_item/v1")
                .addPathSegment(lineItemGroupId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Removes a line item from an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (line_item_uuid_str) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> removeLineItemV1(
            String lineItemGroupId, AdHocRemoveLineItemV1Request request) {
        return removeLineItemV1(lineItemGroupId, request, null);
    }

    /**
     * Removes a line item from an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | (line_item_uuid_str) -&gt; (LineItemGroup1)
     */
    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> removeLineItemV1(
            String lineItemGroupId, AdHocRemoveLineItemV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("billing/line_item_groups/ad_hoc/remove_line_item/v1")
                .addPathSegment(lineItemGroupId);
        QueryStringMapper.addQueryParameter(httpUrl, "line_item_uuid_str", request.getLineItemUuidStr(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Deletes an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE or FINALIZED. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> deleteV1(String lineItemGroupId) {
        return deleteV1(lineItemGroupId, null);
    }

    /**
     * Deletes an ad-hoc line item group. LIG must be ad-hoc (task_group_id is None) and ADJUSTABLE or FINALIZED. | org_type=[courier, forwarder], min_org_role=operator, authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> deleteV1(
            String lineItemGroupId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("billing/line_item_groups/ad_hoc/delete/v1")
                .addPathSegment(lineItemGroupId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
