/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.adhoc.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AdHocRemoveLineItemV1Request.Builder.class)
public final class AdHocRemoveLineItemV1Request {
    private final String lineItemUuidStr;

    private final Map<String, Object> additionalProperties;

    private AdHocRemoveLineItemV1Request(String lineItemUuidStr, Map<String, Object> additionalProperties) {
        this.lineItemUuidStr = lineItemUuidStr;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return UUID of the line item to remove from the LIG
     */
    @JsonProperty("line_item_uuid_str")
    public String getLineItemUuidStr() {
        return lineItemUuidStr;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AdHocRemoveLineItemV1Request && equalTo((AdHocRemoveLineItemV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdHocRemoveLineItemV1Request other) {
        return lineItemUuidStr.equals(other.lineItemUuidStr);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.lineItemUuidStr);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LineItemUuidStrStage builder() {
        return new Builder();
    }

    public interface LineItemUuidStrStage {
        /**
         * <p>UUID of the line item to remove from the LIG</p>
         */
        _FinalStage lineItemUuidStr(@NotNull String lineItemUuidStr);

        Builder from(AdHocRemoveLineItemV1Request other);
    }

    public interface _FinalStage {
        AdHocRemoveLineItemV1Request build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LineItemUuidStrStage, _FinalStage {
        private String lineItemUuidStr;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AdHocRemoveLineItemV1Request other) {
            lineItemUuidStr(other.getLineItemUuidStr());
            return this;
        }

        /**
         * <p>UUID of the line item to remove from the LIG</p>
         * <p>UUID of the line item to remove from the LIG</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("line_item_uuid_str")
        public _FinalStage lineItemUuidStr(@NotNull String lineItemUuidStr) {
            this.lineItemUuidStr = Objects.requireNonNull(lineItemUuidStr, "lineItemUuidStr must not be null");
            return this;
        }

        @java.lang.Override
        public AdHocRemoveLineItemV1Request build() {
            return new AdHocRemoveLineItemV1Request(lineItemUuidStr, additionalProperties);
        }
    }
}
