/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.adhoc.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.SettlementTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateAdHocLineItemGroupReq.Builder.class)
public final class CreateAdHocLineItemGroupReq {
    private final PaymentVectorTypeEnum1 paymentVectorType;

    private final SettlementTypeEnum1 settlementType;

    private final Optional<String> paymentOriginOrgId;

    private final Optional<String> paymentOriginOffChrtShipperOrgId;

    private final Optional<String> paymentDestinationOrgId;

    private final Optional<String> paymentDestinationDriverId;

    private final Map<String, Object> additionalProperties;

    private CreateAdHocLineItemGroupReq(
            PaymentVectorTypeEnum1 paymentVectorType,
            SettlementTypeEnum1 settlementType,
            Optional<String> paymentOriginOrgId,
            Optional<String> paymentOriginOffChrtShipperOrgId,
            Optional<String> paymentDestinationOrgId,
            Optional<String> paymentDestinationDriverId,
            Map<String, Object> additionalProperties) {
        this.paymentVectorType = paymentVectorType;
        this.settlementType = settlementType;
        this.paymentOriginOrgId = paymentOriginOrgId;
        this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
        this.paymentDestinationOrgId = paymentDestinationOrgId;
        this.paymentDestinationDriverId = paymentDestinationDriverId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Payment vector type
     */
    @JsonProperty("payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return paymentVectorType;
    }

    /**
     * @return Settlement type for this line item group
     */
    @JsonProperty("settlement_type")
    public SettlementTypeEnum1 getSettlementType() {
        return settlementType;
    }

    /**
     * @return Payment origin org ID (on-CHRT org)
     */
    @JsonIgnore
    public Optional<String> getPaymentOriginOrgId() {
        if (paymentOriginOrgId == null) {
            return Optional.empty();
        }
        return paymentOriginOrgId;
    }

    /**
     * @return Payment origin off-CHRT shipper org ID
     */
    @JsonIgnore
    public Optional<String> getPaymentOriginOffChrtShipperOrgId() {
        if (paymentOriginOffChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return paymentOriginOffChrtShipperOrgId;
    }

    /**
     * @return Payment destination org ID (on-CHRT org)
     */
    @JsonIgnore
    public Optional<String> getPaymentDestinationOrgId() {
        if (paymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return paymentDestinationOrgId;
    }

    /**
     * @return Payment destination driver ID
     */
    @JsonIgnore
    public Optional<String> getPaymentDestinationDriverId() {
        if (paymentDestinationDriverId == null) {
            return Optional.empty();
        }
        return paymentDestinationDriverId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_origin_org_id")
    private Optional<String> _getPaymentOriginOrgId() {
        return paymentOriginOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_origin_off_chrt_shipper_org_id")
    private Optional<String> _getPaymentOriginOffChrtShipperOrgId() {
        return paymentOriginOffChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_destination_org_id")
    private Optional<String> _getPaymentDestinationOrgId() {
        return paymentDestinationOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_destination_driver_id")
    private Optional<String> _getPaymentDestinationDriverId() {
        return paymentDestinationDriverId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateAdHocLineItemGroupReq && equalTo((CreateAdHocLineItemGroupReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateAdHocLineItemGroupReq other) {
        return paymentVectorType.equals(other.paymentVectorType)
                && settlementType.equals(other.settlementType)
                && paymentOriginOrgId.equals(other.paymentOriginOrgId)
                && paymentOriginOffChrtShipperOrgId.equals(other.paymentOriginOffChrtShipperOrgId)
                && paymentDestinationOrgId.equals(other.paymentDestinationOrgId)
                && paymentDestinationDriverId.equals(other.paymentDestinationDriverId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.paymentVectorType,
                this.settlementType,
                this.paymentOriginOrgId,
                this.paymentOriginOffChrtShipperOrgId,
                this.paymentDestinationOrgId,
                this.paymentDestinationDriverId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentVectorTypeStage builder() {
        return new Builder();
    }

    public interface PaymentVectorTypeStage {
        /**
         * <p>Payment vector type</p>
         */
        SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType);

        Builder from(CreateAdHocLineItemGroupReq other);
    }

    public interface SettlementTypeStage {
        /**
         * <p>Settlement type for this line item group</p>
         */
        _FinalStage settlementType(@NotNull SettlementTypeEnum1 settlementType);
    }

    public interface _FinalStage {
        CreateAdHocLineItemGroupReq build();

        /**
         * <p>Payment origin org ID (on-CHRT org)</p>
         */
        _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId);

        _FinalStage paymentOriginOrgId(String paymentOriginOrgId);

        _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId);

        /**
         * <p>Payment origin off-CHRT shipper org ID</p>
         */
        _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId);

        /**
         * <p>Payment destination org ID (on-CHRT org)</p>
         */
        _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId);

        _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId);

        _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId);

        /**
         * <p>Payment destination driver ID</p>
         */
        _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId);

        _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId);

        _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PaymentVectorTypeStage, SettlementTypeStage, _FinalStage {
        private PaymentVectorTypeEnum1 paymentVectorType;

        private SettlementTypeEnum1 settlementType;

        private Optional<String> paymentDestinationDriverId = Optional.empty();

        private Optional<String> paymentDestinationOrgId = Optional.empty();

        private Optional<String> paymentOriginOffChrtShipperOrgId = Optional.empty();

        private Optional<String> paymentOriginOrgId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateAdHocLineItemGroupReq other) {
            paymentVectorType(other.getPaymentVectorType());
            settlementType(other.getSettlementType());
            paymentOriginOrgId(other.getPaymentOriginOrgId());
            paymentOriginOffChrtShipperOrgId(other.getPaymentOriginOffChrtShipperOrgId());
            paymentDestinationOrgId(other.getPaymentDestinationOrgId());
            paymentDestinationDriverId(other.getPaymentDestinationDriverId());
            return this;
        }

        /**
         * <p>Payment vector type</p>
         * <p>Payment vector type</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("payment_vector_type")
        public SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        /**
         * <p>Settlement type for this line item group</p>
         * <p>Settlement type for this line item group</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("settlement_type")
        public _FinalStage settlementType(@NotNull SettlementTypeEnum1 settlementType) {
            this.settlementType = Objects.requireNonNull(settlementType, "settlementType must not be null");
            return this;
        }

        /**
         * <p>Payment destination driver ID</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId) {
            if (paymentDestinationDriverId.isNull()) {
                this.paymentDestinationDriverId = null;
            } else if (paymentDestinationDriverId.isEmpty()) {
                this.paymentDestinationDriverId = Optional.empty();
            } else {
                this.paymentDestinationDriverId = Optional.of(paymentDestinationDriverId.get());
            }
            return this;
        }

        /**
         * <p>Payment destination driver ID</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId) {
            this.paymentDestinationDriverId = Optional.ofNullable(paymentDestinationDriverId);
            return this;
        }

        /**
         * <p>Payment destination driver ID</p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_destination_driver_id", nulls = Nulls.SKIP)
        public _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId;
            return this;
        }

        /**
         * <p>Payment destination org ID (on-CHRT org)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId) {
            if (paymentDestinationOrgId.isNull()) {
                this.paymentDestinationOrgId = null;
            } else if (paymentDestinationOrgId.isEmpty()) {
                this.paymentDestinationOrgId = Optional.empty();
            } else {
                this.paymentDestinationOrgId = Optional.of(paymentDestinationOrgId.get());
            }
            return this;
        }

        /**
         * <p>Payment destination org ID (on-CHRT org)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId) {
            this.paymentDestinationOrgId = Optional.ofNullable(paymentDestinationOrgId);
            return this;
        }

        /**
         * <p>Payment destination org ID (on-CHRT org)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_destination_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId;
            return this;
        }

        /**
         * <p>Payment origin off-CHRT shipper org ID</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId) {
            if (paymentOriginOffChrtShipperOrgId.isNull()) {
                this.paymentOriginOffChrtShipperOrgId = null;
            } else if (paymentOriginOffChrtShipperOrgId.isEmpty()) {
                this.paymentOriginOffChrtShipperOrgId = Optional.empty();
            } else {
                this.paymentOriginOffChrtShipperOrgId = Optional.of(paymentOriginOffChrtShipperOrgId.get());
            }
            return this;
        }

        /**
         * <p>Payment origin off-CHRT shipper org ID</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = Optional.ofNullable(paymentOriginOffChrtShipperOrgId);
            return this;
        }

        /**
         * <p>Payment origin off-CHRT shipper org ID</p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_origin_off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
            return this;
        }

        /**
         * <p>Payment origin org ID (on-CHRT org)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId) {
            if (paymentOriginOrgId.isNull()) {
                this.paymentOriginOrgId = null;
            } else if (paymentOriginOrgId.isEmpty()) {
                this.paymentOriginOrgId = Optional.empty();
            } else {
                this.paymentOriginOrgId = Optional.of(paymentOriginOrgId.get());
            }
            return this;
        }

        /**
         * <p>Payment origin org ID (on-CHRT org)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOrgId(String paymentOriginOrgId) {
            this.paymentOriginOrgId = Optional.ofNullable(paymentOriginOrgId);
            return this;
        }

        /**
         * <p>Payment origin org ID (on-CHRT org)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_origin_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId;
            return this;
        }

        @java.lang.Override
        public CreateAdHocLineItemGroupReq build() {
            return new CreateAdHocLineItemGroupReq(
                    paymentVectorType,
                    settlementType,
                    paymentOriginOrgId,
                    paymentOriginOffChrtShipperOrgId,
                    paymentDestinationOrgId,
                    paymentDestinationDriverId,
                    additionalProperties);
        }
    }
}
