/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.adhoc.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItemEnum1;
import com.chrt.api.types.UnitsEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LineItemClientCreate1.Builder.class)
public final class LineItemClientCreate1 {
    private final Optional<Integer> schemaVersion;

    private final LineItemEnum1 item;

    private final double quantity;

    private final double rate;

    private final Optional<UnitsEnum> units;

    private final Optional<String> comments;

    private final Optional<Double> adjustment;

    private final Optional<String> adjustmentComments;

    private final Map<String, Object> additionalProperties;

    private LineItemClientCreate1(
            Optional<Integer> schemaVersion,
            LineItemEnum1 item,
            double quantity,
            double rate,
            Optional<UnitsEnum> units,
            Optional<String> comments,
            Optional<Double> adjustment,
            Optional<String> adjustmentComments,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.item = item;
        this.quantity = quantity;
        this.rate = rate;
        this.units = units;
        this.comments = comments;
        this.adjustment = adjustment;
        this.adjustmentComments = adjustmentComments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public Optional<Integer> getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("item")
    public LineItemEnum1 getItem() {
        return item;
    }

    @JsonProperty("quantity")
    public double getQuantity() {
        return quantity;
    }

    @JsonProperty("rate")
    public double getRate() {
        return rate;
    }

    @JsonProperty("units")
    public Optional<UnitsEnum> getUnits() {
        return units;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonIgnore
    public Optional<Double> getAdjustment() {
        if (adjustment == null) {
            return Optional.empty();
        }
        return adjustment;
    }

    @JsonIgnore
    public Optional<String> getAdjustmentComments() {
        if (adjustmentComments == null) {
            return Optional.empty();
        }
        return adjustmentComments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("adjustment")
    private Optional<Double> _getAdjustment() {
        return adjustment;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("adjustment_comments")
    private Optional<String> _getAdjustmentComments() {
        return adjustmentComments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LineItemClientCreate1 && equalTo((LineItemClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItemClientCreate1 other) {
        return schemaVersion.equals(other.schemaVersion)
                && item.equals(other.item)
                && quantity == other.quantity
                && rate == other.rate
                && units.equals(other.units)
                && comments.equals(other.comments)
                && adjustment.equals(other.adjustment)
                && adjustmentComments.equals(other.adjustmentComments);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.item,
                this.quantity,
                this.rate,
                this.units,
                this.comments,
                this.adjustment,
                this.adjustmentComments);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ItemStage builder() {
        return new Builder();
    }

    public interface ItemStage {
        QuantityStage item(@NotNull LineItemEnum1 item);

        Builder from(LineItemClientCreate1 other);
    }

    public interface QuantityStage {
        RateStage quantity(double quantity);
    }

    public interface RateStage {
        _FinalStage rate(double rate);
    }

    public interface _FinalStage {
        LineItemClientCreate1 build();

        _FinalStage schemaVersion(Optional<Integer> schemaVersion);

        _FinalStage schemaVersion(Integer schemaVersion);

        _FinalStage units(Optional<UnitsEnum> units);

        _FinalStage units(UnitsEnum units);

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);

        _FinalStage adjustment(Optional<Double> adjustment);

        _FinalStage adjustment(Double adjustment);

        _FinalStage adjustment(Nullable<Double> adjustment);

        _FinalStage adjustmentComments(Optional<String> adjustmentComments);

        _FinalStage adjustmentComments(String adjustmentComments);

        _FinalStage adjustmentComments(Nullable<String> adjustmentComments);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ItemStage, QuantityStage, RateStage, _FinalStage {
        private LineItemEnum1 item;

        private double quantity;

        private double rate;

        private Optional<String> adjustmentComments = Optional.empty();

        private Optional<Double> adjustment = Optional.empty();

        private Optional<String> comments = Optional.empty();

        private Optional<UnitsEnum> units = Optional.empty();

        private Optional<Integer> schemaVersion = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LineItemClientCreate1 other) {
            schemaVersion(other.getSchemaVersion());
            item(other.getItem());
            quantity(other.getQuantity());
            rate(other.getRate());
            units(other.getUnits());
            comments(other.getComments());
            adjustment(other.getAdjustment());
            adjustmentComments(other.getAdjustmentComments());
            return this;
        }

        @java.lang.Override
        @JsonSetter("item")
        public QuantityStage item(@NotNull LineItemEnum1 item) {
            this.item = Objects.requireNonNull(item, "item must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public RateStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("rate")
        public _FinalStage rate(double rate) {
            this.rate = rate;
            return this;
        }

        @java.lang.Override
        public _FinalStage adjustmentComments(Nullable<String> adjustmentComments) {
            if (adjustmentComments.isNull()) {
                this.adjustmentComments = null;
            } else if (adjustmentComments.isEmpty()) {
                this.adjustmentComments = Optional.empty();
            } else {
                this.adjustmentComments = Optional.of(adjustmentComments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage adjustmentComments(String adjustmentComments) {
            this.adjustmentComments = Optional.ofNullable(adjustmentComments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "adjustment_comments", nulls = Nulls.SKIP)
        public _FinalStage adjustmentComments(Optional<String> adjustmentComments) {
            this.adjustmentComments = adjustmentComments;
            return this;
        }

        @java.lang.Override
        public _FinalStage adjustment(Nullable<Double> adjustment) {
            if (adjustment.isNull()) {
                this.adjustment = null;
            } else if (adjustment.isEmpty()) {
                this.adjustment = Optional.empty();
            } else {
                this.adjustment = Optional.of(adjustment.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage adjustment(Double adjustment) {
            this.adjustment = Optional.ofNullable(adjustment);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "adjustment", nulls = Nulls.SKIP)
        public _FinalStage adjustment(Optional<Double> adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public _FinalStage units(UnitsEnum units) {
            this.units = Optional.ofNullable(units);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "units", nulls = Nulls.SKIP)
        public _FinalStage units(Optional<UnitsEnum> units) {
            this.units = units;
            return this;
        }

        @java.lang.Override
        public _FinalStage schemaVersion(Integer schemaVersion) {
            this.schemaVersion = Optional.ofNullable(schemaVersion);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "schema_version", nulls = Nulls.SKIP)
        public _FinalStage schemaVersion(Optional<Integer> schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        public LineItemClientCreate1 build() {
            return new LineItemClientCreate1(
                    schemaVersion,
                    item,
                    quantity,
                    rate,
                    units,
                    comments,
                    adjustment,
                    adjustmentComments,
                    additionalProperties);
        }
    }
}
