/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AdjustLineItemReq.Builder.class)
public final class AdjustLineItemReq {
    private final String lineItemUuidStr;

    private final double adjustment;

    private final Optional<String> adjustmentComments;

    private final Map<String, Object> additionalProperties;

    private AdjustLineItemReq(
            String lineItemUuidStr,
            double adjustment,
            Optional<String> adjustmentComments,
            Map<String, Object> additionalProperties) {
        this.lineItemUuidStr = lineItemUuidStr;
        this.adjustment = adjustment;
        this.adjustmentComments = adjustmentComments;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return UUID of the line item to adjust
     */
    @JsonProperty("line_item_uuid_str")
    public String getLineItemUuidStr() {
        return lineItemUuidStr;
    }

    /**
     * @return Adjustment amount (can be positive or negative, can exceed item.amount negatively for credits)
     */
    @JsonProperty("adjustment")
    public double getAdjustment() {
        return adjustment;
    }

    /**
     * @return Comments explaining the adjustment
     */
    @JsonIgnore
    public Optional<String> getAdjustmentComments() {
        if (adjustmentComments == null) {
            return Optional.empty();
        }
        return adjustmentComments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("adjustment_comments")
    private Optional<String> _getAdjustmentComments() {
        return adjustmentComments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AdjustLineItemReq && equalTo((AdjustLineItemReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdjustLineItemReq other) {
        return lineItemUuidStr.equals(other.lineItemUuidStr)
                && adjustment == other.adjustment
                && adjustmentComments.equals(other.adjustmentComments);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.lineItemUuidStr, this.adjustment, this.adjustmentComments);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LineItemUuidStrStage builder() {
        return new Builder();
    }

    public interface LineItemUuidStrStage {
        /**
         * <p>UUID of the line item to adjust</p>
         */
        AdjustmentStage lineItemUuidStr(@NotNull String lineItemUuidStr);

        Builder from(AdjustLineItemReq other);
    }

    public interface AdjustmentStage {
        /**
         * <p>Adjustment amount (can be positive or negative, can exceed item.amount negatively for credits)</p>
         */
        _FinalStage adjustment(double adjustment);
    }

    public interface _FinalStage {
        AdjustLineItemReq build();

        /**
         * <p>Comments explaining the adjustment</p>
         */
        _FinalStage adjustmentComments(Optional<String> adjustmentComments);

        _FinalStage adjustmentComments(String adjustmentComments);

        _FinalStage adjustmentComments(Nullable<String> adjustmentComments);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LineItemUuidStrStage, AdjustmentStage, _FinalStage {
        private String lineItemUuidStr;

        private double adjustment;

        private Optional<String> adjustmentComments = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AdjustLineItemReq other) {
            lineItemUuidStr(other.getLineItemUuidStr());
            adjustment(other.getAdjustment());
            adjustmentComments(other.getAdjustmentComments());
            return this;
        }

        /**
         * <p>UUID of the line item to adjust</p>
         * <p>UUID of the line item to adjust</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("line_item_uuid_str")
        public AdjustmentStage lineItemUuidStr(@NotNull String lineItemUuidStr) {
            this.lineItemUuidStr = Objects.requireNonNull(lineItemUuidStr, "lineItemUuidStr must not be null");
            return this;
        }

        /**
         * <p>Adjustment amount (can be positive or negative, can exceed item.amount negatively for credits)</p>
         * <p>Adjustment amount (can be positive or negative, can exceed item.amount negatively for credits)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("adjustment")
        public _FinalStage adjustment(double adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        /**
         * <p>Comments explaining the adjustment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adjustmentComments(Nullable<String> adjustmentComments) {
            if (adjustmentComments.isNull()) {
                this.adjustmentComments = null;
            } else if (adjustmentComments.isEmpty()) {
                this.adjustmentComments = Optional.empty();
            } else {
                this.adjustmentComments = Optional.of(adjustmentComments.get());
            }
            return this;
        }

        /**
         * <p>Comments explaining the adjustment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adjustmentComments(String adjustmentComments) {
            this.adjustmentComments = Optional.ofNullable(adjustmentComments);
            return this;
        }

        /**
         * <p>Comments explaining the adjustment</p>
         */
        @java.lang.Override
        @JsonSetter(value = "adjustment_comments", nulls = Nulls.SKIP)
        public _FinalStage adjustmentComments(Optional<String> adjustmentComments) {
            this.adjustmentComments = adjustmentComments;
            return this;
        }

        @java.lang.Override
        public AdjustLineItemReq build() {
            return new AdjustLineItemReq(lineItemUuidStr, adjustment, adjustmentComments, additionalProperties);
        }
    }
}
