/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItemGroupStatusEnum1;
import com.chrt.api.types.PaymentRoleFilterEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LineItemGroupsListForCourierOrgV1Request.Builder.class)
public final class LineItemGroupsListForCourierOrgV1Request {
    private final Optional<List<LineItemGroupStatusEnum1>> filterStatus;

    private final Optional<String> filterDriverId;

    private final Optional<Boolean> filterAttachedToStatement;

    private final Optional<PaymentRoleFilterEnum> filterPaymentRole;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Map<String, Object> additionalProperties;

    private LineItemGroupsListForCourierOrgV1Request(
            Optional<List<LineItemGroupStatusEnum1>> filterStatus,
            Optional<String> filterDriverId,
            Optional<Boolean> filterAttachedToStatement,
            Optional<PaymentRoleFilterEnum> filterPaymentRole,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Map<String, Object> additionalProperties) {
        this.filterStatus = filterStatus;
        this.filterDriverId = filterDriverId;
        this.filterAttachedToStatement = filterAttachedToStatement;
        this.filterPaymentRole = filterPaymentRole;
        this.page = page;
        this.pageSize = pageSize;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter by line item group status(es)
     */
    @JsonIgnore
    public Optional<List<LineItemGroupStatusEnum1>> getFilterStatus() {
        if (filterStatus == null) {
            return Optional.empty();
        }
        return filterStatus;
    }

    /**
     * @return Filter by driver ID (payment_destination_driver_id)
     */
    @JsonIgnore
    public Optional<String> getFilterDriverId() {
        if (filterDriverId == null) {
            return Optional.empty();
        }
        return filterDriverId;
    }

    /**
     * @return Filter by whether line item group is attached to a statement
     */
    @JsonIgnore
    public Optional<Boolean> getFilterAttachedToStatement() {
        if (filterAttachedToStatement == null) {
            return Optional.empty();
        }
        return filterAttachedToStatement;
    }

    /**
     * @return Filter by payment role: origin (courier pays) or destination (courier receives). Returns both if not specified.
     */
    @JsonIgnore
    public Optional<PaymentRoleFilterEnum> getFilterPaymentRole() {
        if (filterPaymentRole == null) {
            return Optional.empty();
        }
        return filterPaymentRole;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_status")
    private Optional<List<LineItemGroupStatusEnum1>> _getFilterStatus() {
        return filterStatus;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_driver_id")
    private Optional<String> _getFilterDriverId() {
        return filterDriverId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_attached_to_statement")
    private Optional<Boolean> _getFilterAttachedToStatement() {
        return filterAttachedToStatement;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_payment_role")
    private Optional<PaymentRoleFilterEnum> _getFilterPaymentRole() {
        return filterPaymentRole;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LineItemGroupsListForCourierOrgV1Request
                && equalTo((LineItemGroupsListForCourierOrgV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItemGroupsListForCourierOrgV1Request other) {
        return filterStatus.equals(other.filterStatus)
                && filterDriverId.equals(other.filterDriverId)
                && filterAttachedToStatement.equals(other.filterAttachedToStatement)
                && filterPaymentRole.equals(other.filterPaymentRole)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.filterStatus,
                this.filterDriverId,
                this.filterAttachedToStatement,
                this.filterPaymentRole,
                this.page,
                this.pageSize);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<LineItemGroupStatusEnum1>> filterStatus = Optional.empty();

        private Optional<String> filterDriverId = Optional.empty();

        private Optional<Boolean> filterAttachedToStatement = Optional.empty();

        private Optional<PaymentRoleFilterEnum> filterPaymentRole = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(LineItemGroupsListForCourierOrgV1Request other) {
            filterStatus(other.getFilterStatus());
            filterDriverId(other.getFilterDriverId());
            filterAttachedToStatement(other.getFilterAttachedToStatement());
            filterPaymentRole(other.getFilterPaymentRole());
            page(other.getPage());
            pageSize(other.getPageSize());
            return this;
        }

        /**
         * <p>Filter by line item group status(es)</p>
         */
        @JsonSetter(value = "filter_status", nulls = Nulls.SKIP)
        public Builder filterStatus(Optional<List<LineItemGroupStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public Builder filterStatus(List<LineItemGroupStatusEnum1> filterStatus) {
            this.filterStatus = Optional.ofNullable(filterStatus);
            return this;
        }

        public Builder filterStatus(Nullable<List<LineItemGroupStatusEnum1>> filterStatus) {
            if (filterStatus.isNull()) {
                this.filterStatus = null;
            } else if (filterStatus.isEmpty()) {
                this.filterStatus = Optional.empty();
            } else {
                this.filterStatus = Optional.of(filterStatus.get());
            }
            return this;
        }

        public Builder filterStatus(LineItemGroupStatusEnum1 filterStatus) {
            this.filterStatus = Optional.of(Collections.singletonList(filterStatus));
            return this;
        }

        /**
         * <p>Filter by driver ID (payment_destination_driver_id)</p>
         */
        @JsonSetter(value = "filter_driver_id", nulls = Nulls.SKIP)
        public Builder filterDriverId(Optional<String> filterDriverId) {
            this.filterDriverId = filterDriverId;
            return this;
        }

        public Builder filterDriverId(String filterDriverId) {
            this.filterDriverId = Optional.ofNullable(filterDriverId);
            return this;
        }

        public Builder filterDriverId(Nullable<String> filterDriverId) {
            if (filterDriverId.isNull()) {
                this.filterDriverId = null;
            } else if (filterDriverId.isEmpty()) {
                this.filterDriverId = Optional.empty();
            } else {
                this.filterDriverId = Optional.of(filterDriverId.get());
            }
            return this;
        }

        /**
         * <p>Filter by whether line item group is attached to a statement</p>
         */
        @JsonSetter(value = "filter_attached_to_statement", nulls = Nulls.SKIP)
        public Builder filterAttachedToStatement(Optional<Boolean> filterAttachedToStatement) {
            this.filterAttachedToStatement = filterAttachedToStatement;
            return this;
        }

        public Builder filterAttachedToStatement(Boolean filterAttachedToStatement) {
            this.filterAttachedToStatement = Optional.ofNullable(filterAttachedToStatement);
            return this;
        }

        public Builder filterAttachedToStatement(Nullable<Boolean> filterAttachedToStatement) {
            if (filterAttachedToStatement.isNull()) {
                this.filterAttachedToStatement = null;
            } else if (filterAttachedToStatement.isEmpty()) {
                this.filterAttachedToStatement = Optional.empty();
            } else {
                this.filterAttachedToStatement = Optional.of(filterAttachedToStatement.get());
            }
            return this;
        }

        /**
         * <p>Filter by payment role: origin (courier pays) or destination (courier receives). Returns both if not specified.</p>
         */
        @JsonSetter(value = "filter_payment_role", nulls = Nulls.SKIP)
        public Builder filterPaymentRole(Optional<PaymentRoleFilterEnum> filterPaymentRole) {
            this.filterPaymentRole = filterPaymentRole;
            return this;
        }

        public Builder filterPaymentRole(PaymentRoleFilterEnum filterPaymentRole) {
            this.filterPaymentRole = Optional.ofNullable(filterPaymentRole);
            return this;
        }

        public Builder filterPaymentRole(Nullable<PaymentRoleFilterEnum> filterPaymentRole) {
            if (filterPaymentRole.isNull()) {
                this.filterPaymentRole = null;
            } else if (filterPaymentRole.isEmpty()) {
                this.filterPaymentRole = Optional.empty();
            } else {
                this.filterPaymentRole = Optional.of(filterPaymentRole.get());
            }
            return this;
        }

        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        public Builder page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        public Builder pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        public LineItemGroupsListForCourierOrgV1Request build() {
            return new LineItemGroupsListForCourierOrgV1Request(
                    filterStatus,
                    filterDriverId,
                    filterAttachedToStatement,
                    filterPaymentRole,
                    page,
                    pageSize,
                    additionalProperties);
        }
    }
}
