/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.lineitemgroups.s3objects;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.lineitemgroups.s3objects.requests.BodyLineItemGroupsS3ObjectPostAddV1BillingLineItemGroupsS3ObjectsAddV1LineItemGroupIdPost;
import com.chrt.api.types.LineItemGroupS3ObjectMetadata1;
import java.io.File;
import java.io.InputStream;

public class S3ObjectsClient {
    protected final ClientOptions clientOptions;

    private final RawS3ObjectsClient rawClient;

    public S3ObjectsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawS3ObjectsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawS3ObjectsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the metadata for a line item group S3 object, including blurhash for placeholder loading. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (LineItemGroupS3ObjectMetadata1)
     */
    public LineItemGroupS3ObjectMetadata1 getS3ObjectMetadataV1(String lineItemGroupS3ObjectMetadataId) {
        return this.rawClient
                .getS3ObjectMetadataV1(lineItemGroupS3ObjectMetadataId)
                .body();
    }

    /**
     * Retrieves the metadata for a line item group S3 object, including blurhash for placeholder loading. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (LineItemGroupS3ObjectMetadata1)
     */
    public LineItemGroupS3ObjectMetadata1 getS3ObjectMetadataV1(
            String lineItemGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getS3ObjectMetadataV1(lineItemGroupS3ObjectMetadataId, requestOptions)
                .body();
    }

    /**
     * Streams a line item group S3 object file from storage. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (binary)
     */
    public InputStream getV1(String lineItemGroupS3ObjectMetadataId) {
        return this.rawClient.getV1(lineItemGroupS3ObjectMetadataId).body();
    }

    /**
     * Streams a line item group S3 object file from storage. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (binary)
     */
    public InputStream getV1(String lineItemGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getV1(lineItemGroupS3ObjectMetadataId, requestOptions)
                .body();
    }

    /**
     * Uploads an image file to a line item group with automatic blurhash generation. | authz_personas=[lig_org_operators, lig_driver] | (UploadFile) -&gt; (bool)
     */
    public boolean addV1(
            String lineItemGroupId,
            File image,
            BodyLineItemGroupsS3ObjectPostAddV1BillingLineItemGroupsS3ObjectsAddV1LineItemGroupIdPost request) {
        return this.rawClient.addV1(lineItemGroupId, image, request).body();
    }

    /**
     * Uploads an image file to a line item group with automatic blurhash generation. | authz_personas=[lig_org_operators, lig_driver] | (UploadFile) -&gt; (bool)
     */
    public boolean addV1(
            String lineItemGroupId,
            File image,
            BodyLineItemGroupsS3ObjectPostAddV1BillingLineItemGroupsS3ObjectsAddV1LineItemGroupIdPost request,
            RequestOptions requestOptions) {
        return this.rawClient
                .addV1(lineItemGroupId, image, request, requestOptions)
                .body();
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a line item group. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (bool)
     */
    public boolean deleteV1(String lineItemGroupS3ObjectMetadataId) {
        return this.rawClient.deleteV1(lineItemGroupS3ObjectMetadataId).body();
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a line item group. | authz_personas=[lig_org_operators, lig_driver] | () -&gt; (bool)
     */
    public boolean deleteV1(String lineItemGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(lineItemGroupS3ObjectMetadataId, requestOptions)
                .body();
    }
}
