/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.ratesheets;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetClientCreate1;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetClientUpdate1;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsArchiveV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsListByOrgV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsUpdateDefaultForConnectionV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsUpdateDefaultForDriverV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsUpdateOrgDefaultForServiceTypeV1Request;
import com.chrt.api.types.RateSheet1;
import com.chrt.api.types.RateSheetListResponse;

public class RateSheetsClient {
    protected final ClientOptions clientOptions;

    private final RawRateSheetsClient rawClient;

    public RateSheetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawRateSheetsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawRateSheetsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a rate sheet by ID. Only the owning org can fetch. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (RateSheet1)
     */
    public RateSheet1 getV1(String rateSheetId) {
        return this.rawClient.getV1(rateSheetId).body();
    }

    /**
     * Retrieves a rate sheet by ID. Only the owning org can fetch. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (RateSheet1)
     */
    public RateSheet1 getV1(String rateSheetId, RequestOptions requestOptions) {
        return this.rawClient.getV1(rateSheetId, requestOptions).body();
    }

    /**
     * Updates a rate sheet. Only name, comments, cargo_types, and vehicle_types can be changed. Use the archive endpoint for archiving. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | (RateSheetClientUpdate1) -&gt; (RateSheet1)
     */
    public RateSheet1 updateV1(String rateSheetId) {
        return this.rawClient.updateV1(rateSheetId).body();
    }

    /**
     * Updates a rate sheet. Only name, comments, cargo_types, and vehicle_types can be changed. Use the archive endpoint for archiving. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | (RateSheetClientUpdate1) -&gt; (RateSheet1)
     */
    public RateSheet1 updateV1(String rateSheetId, RateSheetClientUpdate1 request) {
        return this.rawClient.updateV1(rateSheetId, request).body();
    }

    /**
     * Updates a rate sheet. Only name, comments, cargo_types, and vehicle_types can be changed. Use the archive endpoint for archiving. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | (RateSheetClientUpdate1) -&gt; (RateSheet1)
     */
    public RateSheet1 updateV1(String rateSheetId, RateSheetClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(rateSheetId, request, requestOptions).body();
    }

    /**
     * Lists rate sheets for the caller's organization with filtering, sorting, and pagination. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (RateSheetListResponse)
     */
    public RateSheetListResponse listByOrgV1() {
        return this.rawClient.listByOrgV1().body();
    }

    /**
     * Lists rate sheets for the caller's organization with filtering, sorting, and pagination. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (RateSheetListResponse)
     */
    public RateSheetListResponse listByOrgV1(RateSheetsListByOrgV1Request request) {
        return this.rawClient.listByOrgV1(request).body();
    }

    /**
     * Lists rate sheets for the caller's organization with filtering, sorting, and pagination. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (RateSheetListResponse)
     */
    public RateSheetListResponse listByOrgV1(RateSheetsListByOrgV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listByOrgV1(request, requestOptions).body();
    }

    /**
     * Creates a rate sheet. Couriers and forwarders only. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | (RateSheetClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(RateSheetClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a rate sheet. Couriers and forwarders only. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | (RateSheetClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(RateSheetClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Archives or unarchives a rate sheet. When archiving, automatically removes the rate sheet from all default assignments (OrgPrivateData, Connections, Drivers). | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean archiveV1(String rateSheetId, RateSheetsArchiveV1Request request) {
        return this.rawClient.archiveV1(rateSheetId, request).body();
    }

    /**
     * Archives or unarchives a rate sheet. When archiving, automatically removes the rate sheet from all default assignments (OrgPrivateData, Connections, Drivers). | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean archiveV1(String rateSheetId, RateSheetsArchiveV1Request request, RequestOptions requestOptions) {
        return this.rawClient.archiveV1(rateSheetId, request, requestOptions).body();
    }

    /**
     * Sets or clears the org's default rate sheet for a payment vector type and service type. Pass rate_sheet_id to set a default, or omit it to clear the default. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean updateOrgDefaultForServiceTypeV1(RateSheetsUpdateOrgDefaultForServiceTypeV1Request request) {
        return this.rawClient.updateOrgDefaultForServiceTypeV1(request).body();
    }

    /**
     * Sets or clears the org's default rate sheet for a payment vector type and service type. Pass rate_sheet_id to set a default, or omit it to clear the default. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean updateOrgDefaultForServiceTypeV1(
            RateSheetsUpdateOrgDefaultForServiceTypeV1Request request, RequestOptions requestOptions) {
        return this.rawClient
                .updateOrgDefaultForServiceTypeV1(request, requestOptions)
                .body();
    }

    /**
     * Sets or clears a rate sheet as the default for a connection. Pass rate_sheet_id to set a default, or omit it to clear the default. One default per service type per connection. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean updateDefaultForConnectionV1(RateSheetsUpdateDefaultForConnectionV1Request request) {
        return this.rawClient.updateDefaultForConnectionV1(request).body();
    }

    /**
     * Sets or clears a rate sheet as the default for a connection. Pass rate_sheet_id to set a default, or omit it to clear the default. One default per service type per connection. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean updateDefaultForConnectionV1(
            RateSheetsUpdateDefaultForConnectionV1Request request, RequestOptions requestOptions) {
        return this.rawClient
                .updateDefaultForConnectionV1(request, requestOptions)
                .body();
    }

    /**
     * Sets or clears a rate sheet as the default for a driver. Pass rate_sheet_id to set a default, or omit it to clear the default. One default per service type per driver. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean updateDefaultForDriverV1(RateSheetsUpdateDefaultForDriverV1Request request) {
        return this.rawClient.updateDefaultForDriverV1(request).body();
    }

    /**
     * Sets or clears a rate sheet as the default for a driver. Pass rate_sheet_id to set a default, or omit it to clear the default. One default per service type per driver. | authz: allowed_org_types=[courier, forwarder], min_org_role=operator | () -&gt; (bool)
     */
    public boolean updateDefaultForDriverV1(
            RateSheetsUpdateDefaultForDriverV1Request request, RequestOptions requestOptions) {
        return this.rawClient.updateDefaultForDriverV1(request, requestOptions).body();
    }
}
