/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.ServiceTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RateSheetClientCreate1.Builder.class)
public final class RateSheetClientCreate1 {
    private final PaymentVectorTypeEnum1 paymentVectorType;

    private final int schemaVersion;

    private final Optional<Boolean> archived;

    private final Optional<String> name;

    private final Optional<String> comments;

    private final Optional<List<CargoTypeEnum1>> cargoTypes;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final ServiceTypeEnum1 serviceType;

    private final Optional<Double> baseMileageDistanceMiles;

    private final Optional<Double> baseMileageRateUsdPerInstance;

    private final Optional<Double> additionalMileageRateUsdPerMile;

    private final Optional<Double> longDistanceSurchargeMilesBeforeSurcharge;

    private final Optional<Double> longDistanceSurchargeRateUsdPerMile;

    private final Optional<Double> fuelSurchargeRateUsdPerMile;

    private final Optional<Double> waitTimeBeforeChargeMinutes;

    private final Optional<Double> waitTimeRateUsdPerMinute;

    private final Optional<Double> extraStopRateUsd;

    private final Optional<Double> dangerousGoodsRateUsdPerInstance;

    private final Optional<Double> afterHoursRateUsdPerInstance;

    private final Optional<Double> weekendRateUsdPerInstance;

    private final Optional<Double> holidayRateUsdPerInstance;

    private final Map<String, Object> additionalProperties;

    private RateSheetClientCreate1(
            PaymentVectorTypeEnum1 paymentVectorType,
            int schemaVersion,
            Optional<Boolean> archived,
            Optional<String> name,
            Optional<String> comments,
            Optional<List<CargoTypeEnum1>> cargoTypes,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            ServiceTypeEnum1 serviceType,
            Optional<Double> baseMileageDistanceMiles,
            Optional<Double> baseMileageRateUsdPerInstance,
            Optional<Double> additionalMileageRateUsdPerMile,
            Optional<Double> longDistanceSurchargeMilesBeforeSurcharge,
            Optional<Double> longDistanceSurchargeRateUsdPerMile,
            Optional<Double> fuelSurchargeRateUsdPerMile,
            Optional<Double> waitTimeBeforeChargeMinutes,
            Optional<Double> waitTimeRateUsdPerMinute,
            Optional<Double> extraStopRateUsd,
            Optional<Double> dangerousGoodsRateUsdPerInstance,
            Optional<Double> afterHoursRateUsdPerInstance,
            Optional<Double> weekendRateUsdPerInstance,
            Optional<Double> holidayRateUsdPerInstance,
            Map<String, Object> additionalProperties) {
        this.paymentVectorType = paymentVectorType;
        this.schemaVersion = schemaVersion;
        this.archived = archived;
        this.name = name;
        this.comments = comments;
        this.cargoTypes = cargoTypes;
        this.vehicleTypes = vehicleTypes;
        this.serviceType = serviceType;
        this.baseMileageDistanceMiles = baseMileageDistanceMiles;
        this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
        this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
        this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
        this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
        this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
        this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
        this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
        this.extraStopRateUsd = extraStopRateUsd;
        this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
        this.afterHoursRateUsdPerInstance = afterHoursRateUsdPerInstance;
        this.weekendRateUsdPerInstance = weekendRateUsdPerInstance;
        this.holidayRateUsdPerInstance = holidayRateUsdPerInstance;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return paymentVectorType;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("archived")
    public Optional<Boolean> getArchived() {
        return archived;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (name == null) {
            return Optional.empty();
        }
        return name;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonProperty("cargo_types")
    public Optional<List<CargoTypeEnum1>> getCargoTypes() {
        return cargoTypes;
    }

    @JsonProperty("vehicle_types")
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        return vehicleTypes;
    }

    @JsonProperty("service_type")
    public ServiceTypeEnum1 getServiceType() {
        return serviceType;
    }

    @JsonIgnore
    public Optional<Double> getBaseMileageDistanceMiles() {
        if (baseMileageDistanceMiles == null) {
            return Optional.empty();
        }
        return baseMileageDistanceMiles;
    }

    @JsonIgnore
    public Optional<Double> getBaseMileageRateUsdPerInstance() {
        if (baseMileageRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return baseMileageRateUsdPerInstance;
    }

    /**
     * @return applies only to the additional/incremental miles
     */
    @JsonIgnore
    public Optional<Double> getAdditionalMileageRateUsdPerMile() {
        if (additionalMileageRateUsdPerMile == null) {
            return Optional.empty();
        }
        return additionalMileageRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getLongDistanceSurchargeMilesBeforeSurcharge() {
        if (longDistanceSurchargeMilesBeforeSurcharge == null) {
            return Optional.empty();
        }
        return longDistanceSurchargeMilesBeforeSurcharge;
    }

    /**
     * @return applies only to the additional/incremental miles
     */
    @JsonIgnore
    public Optional<Double> getLongDistanceSurchargeRateUsdPerMile() {
        if (longDistanceSurchargeRateUsdPerMile == null) {
            return Optional.empty();
        }
        return longDistanceSurchargeRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getFuelSurchargeRateUsdPerMile() {
        if (fuelSurchargeRateUsdPerMile == null) {
            return Optional.empty();
        }
        return fuelSurchargeRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getWaitTimeBeforeChargeMinutes() {
        if (waitTimeBeforeChargeMinutes == null) {
            return Optional.empty();
        }
        return waitTimeBeforeChargeMinutes;
    }

    @JsonIgnore
    public Optional<Double> getWaitTimeRateUsdPerMinute() {
        if (waitTimeRateUsdPerMinute == null) {
            return Optional.empty();
        }
        return waitTimeRateUsdPerMinute;
    }

    @JsonIgnore
    public Optional<Double> getExtraStopRateUsd() {
        if (extraStopRateUsd == null) {
            return Optional.empty();
        }
        return extraStopRateUsd;
    }

    @JsonIgnore
    public Optional<Double> getDangerousGoodsRateUsdPerInstance() {
        if (dangerousGoodsRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return dangerousGoodsRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getAfterHoursRateUsdPerInstance() {
        if (afterHoursRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return afterHoursRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getWeekendRateUsdPerInstance() {
        if (weekendRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return weekendRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getHolidayRateUsdPerInstance() {
        if (holidayRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return holidayRateUsdPerInstance;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("name")
    private Optional<String> _getName() {
        return name;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("base_mileage_distance_miles")
    private Optional<Double> _getBaseMileageDistanceMiles() {
        return baseMileageDistanceMiles;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("base_mileage_rate_usd_per_instance")
    private Optional<Double> _getBaseMileageRateUsdPerInstance() {
        return baseMileageRateUsdPerInstance;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("additional_mileage_rate_usd_per_mile")
    private Optional<Double> _getAdditionalMileageRateUsdPerMile() {
        return additionalMileageRateUsdPerMile;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("long_distance_surcharge_miles_before_surcharge")
    private Optional<Double> _getLongDistanceSurchargeMilesBeforeSurcharge() {
        return longDistanceSurchargeMilesBeforeSurcharge;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("long_distance_surcharge_rate_usd_per_mile")
    private Optional<Double> _getLongDistanceSurchargeRateUsdPerMile() {
        return longDistanceSurchargeRateUsdPerMile;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("fuel_surcharge_rate_usd_per_mile")
    private Optional<Double> _getFuelSurchargeRateUsdPerMile() {
        return fuelSurchargeRateUsdPerMile;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("wait_time_before_charge_minutes")
    private Optional<Double> _getWaitTimeBeforeChargeMinutes() {
        return waitTimeBeforeChargeMinutes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("wait_time_rate_usd_per_minute")
    private Optional<Double> _getWaitTimeRateUsdPerMinute() {
        return waitTimeRateUsdPerMinute;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("extra_stop_rate_usd")
    private Optional<Double> _getExtraStopRateUsd() {
        return extraStopRateUsd;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("dangerous_goods_rate_usd_per_instance")
    private Optional<Double> _getDangerousGoodsRateUsdPerInstance() {
        return dangerousGoodsRateUsdPerInstance;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("after_hours_rate_usd_per_instance")
    private Optional<Double> _getAfterHoursRateUsdPerInstance() {
        return afterHoursRateUsdPerInstance;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("weekend_rate_usd_per_instance")
    private Optional<Double> _getWeekendRateUsdPerInstance() {
        return weekendRateUsdPerInstance;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("holiday_rate_usd_per_instance")
    private Optional<Double> _getHolidayRateUsdPerInstance() {
        return holidayRateUsdPerInstance;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RateSheetClientCreate1 && equalTo((RateSheetClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetClientCreate1 other) {
        return paymentVectorType.equals(other.paymentVectorType)
                && schemaVersion == other.schemaVersion
                && archived.equals(other.archived)
                && name.equals(other.name)
                && comments.equals(other.comments)
                && cargoTypes.equals(other.cargoTypes)
                && vehicleTypes.equals(other.vehicleTypes)
                && serviceType.equals(other.serviceType)
                && baseMileageDistanceMiles.equals(other.baseMileageDistanceMiles)
                && baseMileageRateUsdPerInstance.equals(other.baseMileageRateUsdPerInstance)
                && additionalMileageRateUsdPerMile.equals(other.additionalMileageRateUsdPerMile)
                && longDistanceSurchargeMilesBeforeSurcharge.equals(other.longDistanceSurchargeMilesBeforeSurcharge)
                && longDistanceSurchargeRateUsdPerMile.equals(other.longDistanceSurchargeRateUsdPerMile)
                && fuelSurchargeRateUsdPerMile.equals(other.fuelSurchargeRateUsdPerMile)
                && waitTimeBeforeChargeMinutes.equals(other.waitTimeBeforeChargeMinutes)
                && waitTimeRateUsdPerMinute.equals(other.waitTimeRateUsdPerMinute)
                && extraStopRateUsd.equals(other.extraStopRateUsd)
                && dangerousGoodsRateUsdPerInstance.equals(other.dangerousGoodsRateUsdPerInstance)
                && afterHoursRateUsdPerInstance.equals(other.afterHoursRateUsdPerInstance)
                && weekendRateUsdPerInstance.equals(other.weekendRateUsdPerInstance)
                && holidayRateUsdPerInstance.equals(other.holidayRateUsdPerInstance);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.paymentVectorType,
                this.schemaVersion,
                this.archived,
                this.name,
                this.comments,
                this.cargoTypes,
                this.vehicleTypes,
                this.serviceType,
                this.baseMileageDistanceMiles,
                this.baseMileageRateUsdPerInstance,
                this.additionalMileageRateUsdPerMile,
                this.longDistanceSurchargeMilesBeforeSurcharge,
                this.longDistanceSurchargeRateUsdPerMile,
                this.fuelSurchargeRateUsdPerMile,
                this.waitTimeBeforeChargeMinutes,
                this.waitTimeRateUsdPerMinute,
                this.extraStopRateUsd,
                this.dangerousGoodsRateUsdPerInstance,
                this.afterHoursRateUsdPerInstance,
                this.weekendRateUsdPerInstance,
                this.holidayRateUsdPerInstance);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentVectorTypeStage builder() {
        return new Builder();
    }

    public interface PaymentVectorTypeStage {
        SchemaVersionStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType);

        Builder from(RateSheetClientCreate1 other);
    }

    public interface SchemaVersionStage {
        ServiceTypeStage schemaVersion(int schemaVersion);
    }

    public interface ServiceTypeStage {
        _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType);
    }

    public interface _FinalStage {
        RateSheetClientCreate1 build();

        _FinalStage archived(Optional<Boolean> archived);

        _FinalStage archived(Boolean archived);

        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        _FinalStage name(Nullable<String> name);

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);

        _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes);

        _FinalStage cargoTypes(List<CargoTypeEnum1> cargoTypes);

        _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes);

        _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes);

        _FinalStage baseMileageDistanceMiles(Optional<Double> baseMileageDistanceMiles);

        _FinalStage baseMileageDistanceMiles(Double baseMileageDistanceMiles);

        _FinalStage baseMileageDistanceMiles(Nullable<Double> baseMileageDistanceMiles);

        _FinalStage baseMileageRateUsdPerInstance(Optional<Double> baseMileageRateUsdPerInstance);

        _FinalStage baseMileageRateUsdPerInstance(Double baseMileageRateUsdPerInstance);

        _FinalStage baseMileageRateUsdPerInstance(Nullable<Double> baseMileageRateUsdPerInstance);

        /**
         * <p>applies only to the additional/incremental miles</p>
         */
        _FinalStage additionalMileageRateUsdPerMile(Optional<Double> additionalMileageRateUsdPerMile);

        _FinalStage additionalMileageRateUsdPerMile(Double additionalMileageRateUsdPerMile);

        _FinalStage additionalMileageRateUsdPerMile(Nullable<Double> additionalMileageRateUsdPerMile);

        _FinalStage longDistanceSurchargeMilesBeforeSurcharge(
                Optional<Double> longDistanceSurchargeMilesBeforeSurcharge);

        _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Double longDistanceSurchargeMilesBeforeSurcharge);

        _FinalStage longDistanceSurchargeMilesBeforeSurcharge(
                Nullable<Double> longDistanceSurchargeMilesBeforeSurcharge);

        /**
         * <p>applies only to the additional/incremental miles</p>
         */
        _FinalStage longDistanceSurchargeRateUsdPerMile(Optional<Double> longDistanceSurchargeRateUsdPerMile);

        _FinalStage longDistanceSurchargeRateUsdPerMile(Double longDistanceSurchargeRateUsdPerMile);

        _FinalStage longDistanceSurchargeRateUsdPerMile(Nullable<Double> longDistanceSurchargeRateUsdPerMile);

        _FinalStage fuelSurchargeRateUsdPerMile(Optional<Double> fuelSurchargeRateUsdPerMile);

        _FinalStage fuelSurchargeRateUsdPerMile(Double fuelSurchargeRateUsdPerMile);

        _FinalStage fuelSurchargeRateUsdPerMile(Nullable<Double> fuelSurchargeRateUsdPerMile);

        _FinalStage waitTimeBeforeChargeMinutes(Optional<Double> waitTimeBeforeChargeMinutes);

        _FinalStage waitTimeBeforeChargeMinutes(Double waitTimeBeforeChargeMinutes);

        _FinalStage waitTimeBeforeChargeMinutes(Nullable<Double> waitTimeBeforeChargeMinutes);

        _FinalStage waitTimeRateUsdPerMinute(Optional<Double> waitTimeRateUsdPerMinute);

        _FinalStage waitTimeRateUsdPerMinute(Double waitTimeRateUsdPerMinute);

        _FinalStage waitTimeRateUsdPerMinute(Nullable<Double> waitTimeRateUsdPerMinute);

        _FinalStage extraStopRateUsd(Optional<Double> extraStopRateUsd);

        _FinalStage extraStopRateUsd(Double extraStopRateUsd);

        _FinalStage extraStopRateUsd(Nullable<Double> extraStopRateUsd);

        _FinalStage dangerousGoodsRateUsdPerInstance(Optional<Double> dangerousGoodsRateUsdPerInstance);

        _FinalStage dangerousGoodsRateUsdPerInstance(Double dangerousGoodsRateUsdPerInstance);

        _FinalStage dangerousGoodsRateUsdPerInstance(Nullable<Double> dangerousGoodsRateUsdPerInstance);

        _FinalStage afterHoursRateUsdPerInstance(Optional<Double> afterHoursRateUsdPerInstance);

        _FinalStage afterHoursRateUsdPerInstance(Double afterHoursRateUsdPerInstance);

        _FinalStage afterHoursRateUsdPerInstance(Nullable<Double> afterHoursRateUsdPerInstance);

        _FinalStage weekendRateUsdPerInstance(Optional<Double> weekendRateUsdPerInstance);

        _FinalStage weekendRateUsdPerInstance(Double weekendRateUsdPerInstance);

        _FinalStage weekendRateUsdPerInstance(Nullable<Double> weekendRateUsdPerInstance);

        _FinalStage holidayRateUsdPerInstance(Optional<Double> holidayRateUsdPerInstance);

        _FinalStage holidayRateUsdPerInstance(Double holidayRateUsdPerInstance);

        _FinalStage holidayRateUsdPerInstance(Nullable<Double> holidayRateUsdPerInstance);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements PaymentVectorTypeStage, SchemaVersionStage, ServiceTypeStage, _FinalStage {
        private PaymentVectorTypeEnum1 paymentVectorType;

        private int schemaVersion;

        private ServiceTypeEnum1 serviceType;

        private Optional<Double> holidayRateUsdPerInstance = Optional.empty();

        private Optional<Double> weekendRateUsdPerInstance = Optional.empty();

        private Optional<Double> afterHoursRateUsdPerInstance = Optional.empty();

        private Optional<Double> dangerousGoodsRateUsdPerInstance = Optional.empty();

        private Optional<Double> extraStopRateUsd = Optional.empty();

        private Optional<Double> waitTimeRateUsdPerMinute = Optional.empty();

        private Optional<Double> waitTimeBeforeChargeMinutes = Optional.empty();

        private Optional<Double> fuelSurchargeRateUsdPerMile = Optional.empty();

        private Optional<Double> longDistanceSurchargeRateUsdPerMile = Optional.empty();

        private Optional<Double> longDistanceSurchargeMilesBeforeSurcharge = Optional.empty();

        private Optional<Double> additionalMileageRateUsdPerMile = Optional.empty();

        private Optional<Double> baseMileageRateUsdPerInstance = Optional.empty();

        private Optional<Double> baseMileageDistanceMiles = Optional.empty();

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        private Optional<List<CargoTypeEnum1>> cargoTypes = Optional.empty();

        private Optional<String> comments = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<Boolean> archived = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RateSheetClientCreate1 other) {
            paymentVectorType(other.getPaymentVectorType());
            schemaVersion(other.getSchemaVersion());
            archived(other.getArchived());
            name(other.getName());
            comments(other.getComments());
            cargoTypes(other.getCargoTypes());
            vehicleTypes(other.getVehicleTypes());
            serviceType(other.getServiceType());
            baseMileageDistanceMiles(other.getBaseMileageDistanceMiles());
            baseMileageRateUsdPerInstance(other.getBaseMileageRateUsdPerInstance());
            additionalMileageRateUsdPerMile(other.getAdditionalMileageRateUsdPerMile());
            longDistanceSurchargeMilesBeforeSurcharge(other.getLongDistanceSurchargeMilesBeforeSurcharge());
            longDistanceSurchargeRateUsdPerMile(other.getLongDistanceSurchargeRateUsdPerMile());
            fuelSurchargeRateUsdPerMile(other.getFuelSurchargeRateUsdPerMile());
            waitTimeBeforeChargeMinutes(other.getWaitTimeBeforeChargeMinutes());
            waitTimeRateUsdPerMinute(other.getWaitTimeRateUsdPerMinute());
            extraStopRateUsd(other.getExtraStopRateUsd());
            dangerousGoodsRateUsdPerInstance(other.getDangerousGoodsRateUsdPerInstance());
            afterHoursRateUsdPerInstance(other.getAfterHoursRateUsdPerInstance());
            weekendRateUsdPerInstance(other.getWeekendRateUsdPerInstance());
            holidayRateUsdPerInstance(other.getHolidayRateUsdPerInstance());
            return this;
        }

        @java.lang.Override
        @JsonSetter("payment_vector_type")
        public SchemaVersionStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public ServiceTypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("service_type")
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage holidayRateUsdPerInstance(Nullable<Double> holidayRateUsdPerInstance) {
            if (holidayRateUsdPerInstance.isNull()) {
                this.holidayRateUsdPerInstance = null;
            } else if (holidayRateUsdPerInstance.isEmpty()) {
                this.holidayRateUsdPerInstance = Optional.empty();
            } else {
                this.holidayRateUsdPerInstance = Optional.of(holidayRateUsdPerInstance.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage holidayRateUsdPerInstance(Double holidayRateUsdPerInstance) {
            this.holidayRateUsdPerInstance = Optional.ofNullable(holidayRateUsdPerInstance);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "holiday_rate_usd_per_instance", nulls = Nulls.SKIP)
        public _FinalStage holidayRateUsdPerInstance(Optional<Double> holidayRateUsdPerInstance) {
            this.holidayRateUsdPerInstance = holidayRateUsdPerInstance;
            return this;
        }

        @java.lang.Override
        public _FinalStage weekendRateUsdPerInstance(Nullable<Double> weekendRateUsdPerInstance) {
            if (weekendRateUsdPerInstance.isNull()) {
                this.weekendRateUsdPerInstance = null;
            } else if (weekendRateUsdPerInstance.isEmpty()) {
                this.weekendRateUsdPerInstance = Optional.empty();
            } else {
                this.weekendRateUsdPerInstance = Optional.of(weekendRateUsdPerInstance.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage weekendRateUsdPerInstance(Double weekendRateUsdPerInstance) {
            this.weekendRateUsdPerInstance = Optional.ofNullable(weekendRateUsdPerInstance);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "weekend_rate_usd_per_instance", nulls = Nulls.SKIP)
        public _FinalStage weekendRateUsdPerInstance(Optional<Double> weekendRateUsdPerInstance) {
            this.weekendRateUsdPerInstance = weekendRateUsdPerInstance;
            return this;
        }

        @java.lang.Override
        public _FinalStage afterHoursRateUsdPerInstance(Nullable<Double> afterHoursRateUsdPerInstance) {
            if (afterHoursRateUsdPerInstance.isNull()) {
                this.afterHoursRateUsdPerInstance = null;
            } else if (afterHoursRateUsdPerInstance.isEmpty()) {
                this.afterHoursRateUsdPerInstance = Optional.empty();
            } else {
                this.afterHoursRateUsdPerInstance = Optional.of(afterHoursRateUsdPerInstance.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage afterHoursRateUsdPerInstance(Double afterHoursRateUsdPerInstance) {
            this.afterHoursRateUsdPerInstance = Optional.ofNullable(afterHoursRateUsdPerInstance);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "after_hours_rate_usd_per_instance", nulls = Nulls.SKIP)
        public _FinalStage afterHoursRateUsdPerInstance(Optional<Double> afterHoursRateUsdPerInstance) {
            this.afterHoursRateUsdPerInstance = afterHoursRateUsdPerInstance;
            return this;
        }

        @java.lang.Override
        public _FinalStage dangerousGoodsRateUsdPerInstance(Nullable<Double> dangerousGoodsRateUsdPerInstance) {
            if (dangerousGoodsRateUsdPerInstance.isNull()) {
                this.dangerousGoodsRateUsdPerInstance = null;
            } else if (dangerousGoodsRateUsdPerInstance.isEmpty()) {
                this.dangerousGoodsRateUsdPerInstance = Optional.empty();
            } else {
                this.dangerousGoodsRateUsdPerInstance = Optional.of(dangerousGoodsRateUsdPerInstance.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage dangerousGoodsRateUsdPerInstance(Double dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = Optional.ofNullable(dangerousGoodsRateUsdPerInstance);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "dangerous_goods_rate_usd_per_instance", nulls = Nulls.SKIP)
        public _FinalStage dangerousGoodsRateUsdPerInstance(Optional<Double> dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
            return this;
        }

        @java.lang.Override
        public _FinalStage extraStopRateUsd(Nullable<Double> extraStopRateUsd) {
            if (extraStopRateUsd.isNull()) {
                this.extraStopRateUsd = null;
            } else if (extraStopRateUsd.isEmpty()) {
                this.extraStopRateUsd = Optional.empty();
            } else {
                this.extraStopRateUsd = Optional.of(extraStopRateUsd.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage extraStopRateUsd(Double extraStopRateUsd) {
            this.extraStopRateUsd = Optional.ofNullable(extraStopRateUsd);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "extra_stop_rate_usd", nulls = Nulls.SKIP)
        public _FinalStage extraStopRateUsd(Optional<Double> extraStopRateUsd) {
            this.extraStopRateUsd = extraStopRateUsd;
            return this;
        }

        @java.lang.Override
        public _FinalStage waitTimeRateUsdPerMinute(Nullable<Double> waitTimeRateUsdPerMinute) {
            if (waitTimeRateUsdPerMinute.isNull()) {
                this.waitTimeRateUsdPerMinute = null;
            } else if (waitTimeRateUsdPerMinute.isEmpty()) {
                this.waitTimeRateUsdPerMinute = Optional.empty();
            } else {
                this.waitTimeRateUsdPerMinute = Optional.of(waitTimeRateUsdPerMinute.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage waitTimeRateUsdPerMinute(Double waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = Optional.ofNullable(waitTimeRateUsdPerMinute);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "wait_time_rate_usd_per_minute", nulls = Nulls.SKIP)
        public _FinalStage waitTimeRateUsdPerMinute(Optional<Double> waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
            return this;
        }

        @java.lang.Override
        public _FinalStage waitTimeBeforeChargeMinutes(Nullable<Double> waitTimeBeforeChargeMinutes) {
            if (waitTimeBeforeChargeMinutes.isNull()) {
                this.waitTimeBeforeChargeMinutes = null;
            } else if (waitTimeBeforeChargeMinutes.isEmpty()) {
                this.waitTimeBeforeChargeMinutes = Optional.empty();
            } else {
                this.waitTimeBeforeChargeMinutes = Optional.of(waitTimeBeforeChargeMinutes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage waitTimeBeforeChargeMinutes(Double waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = Optional.ofNullable(waitTimeBeforeChargeMinutes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "wait_time_before_charge_minutes", nulls = Nulls.SKIP)
        public _FinalStage waitTimeBeforeChargeMinutes(Optional<Double> waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
            return this;
        }

        @java.lang.Override
        public _FinalStage fuelSurchargeRateUsdPerMile(Nullable<Double> fuelSurchargeRateUsdPerMile) {
            if (fuelSurchargeRateUsdPerMile.isNull()) {
                this.fuelSurchargeRateUsdPerMile = null;
            } else if (fuelSurchargeRateUsdPerMile.isEmpty()) {
                this.fuelSurchargeRateUsdPerMile = Optional.empty();
            } else {
                this.fuelSurchargeRateUsdPerMile = Optional.of(fuelSurchargeRateUsdPerMile.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage fuelSurchargeRateUsdPerMile(Double fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = Optional.ofNullable(fuelSurchargeRateUsdPerMile);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "fuel_surcharge_rate_usd_per_mile", nulls = Nulls.SKIP)
        public _FinalStage fuelSurchargeRateUsdPerMile(Optional<Double> fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
            return this;
        }

        /**
         * <p>applies only to the additional/incremental miles</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage longDistanceSurchargeRateUsdPerMile(Nullable<Double> longDistanceSurchargeRateUsdPerMile) {
            if (longDistanceSurchargeRateUsdPerMile.isNull()) {
                this.longDistanceSurchargeRateUsdPerMile = null;
            } else if (longDistanceSurchargeRateUsdPerMile.isEmpty()) {
                this.longDistanceSurchargeRateUsdPerMile = Optional.empty();
            } else {
                this.longDistanceSurchargeRateUsdPerMile = Optional.of(longDistanceSurchargeRateUsdPerMile.get());
            }
            return this;
        }

        /**
         * <p>applies only to the additional/incremental miles</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage longDistanceSurchargeRateUsdPerMile(Double longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = Optional.ofNullable(longDistanceSurchargeRateUsdPerMile);
            return this;
        }

        /**
         * <p>applies only to the additional/incremental miles</p>
         */
        @java.lang.Override
        @JsonSetter(value = "long_distance_surcharge_rate_usd_per_mile", nulls = Nulls.SKIP)
        public _FinalStage longDistanceSurchargeRateUsdPerMile(Optional<Double> longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
            return this;
        }

        @java.lang.Override
        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(
                Nullable<Double> longDistanceSurchargeMilesBeforeSurcharge) {
            if (longDistanceSurchargeMilesBeforeSurcharge.isNull()) {
                this.longDistanceSurchargeMilesBeforeSurcharge = null;
            } else if (longDistanceSurchargeMilesBeforeSurcharge.isEmpty()) {
                this.longDistanceSurchargeMilesBeforeSurcharge = Optional.empty();
            } else {
                this.longDistanceSurchargeMilesBeforeSurcharge =
                        Optional.of(longDistanceSurchargeMilesBeforeSurcharge.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Double longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge =
                    Optional.ofNullable(longDistanceSurchargeMilesBeforeSurcharge);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "long_distance_surcharge_miles_before_surcharge", nulls = Nulls.SKIP)
        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(
                Optional<Double> longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
            return this;
        }

        /**
         * <p>applies only to the additional/incremental miles</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage additionalMileageRateUsdPerMile(Nullable<Double> additionalMileageRateUsdPerMile) {
            if (additionalMileageRateUsdPerMile.isNull()) {
                this.additionalMileageRateUsdPerMile = null;
            } else if (additionalMileageRateUsdPerMile.isEmpty()) {
                this.additionalMileageRateUsdPerMile = Optional.empty();
            } else {
                this.additionalMileageRateUsdPerMile = Optional.of(additionalMileageRateUsdPerMile.get());
            }
            return this;
        }

        /**
         * <p>applies only to the additional/incremental miles</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage additionalMileageRateUsdPerMile(Double additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = Optional.ofNullable(additionalMileageRateUsdPerMile);
            return this;
        }

        /**
         * <p>applies only to the additional/incremental miles</p>
         */
        @java.lang.Override
        @JsonSetter(value = "additional_mileage_rate_usd_per_mile", nulls = Nulls.SKIP)
        public _FinalStage additionalMileageRateUsdPerMile(Optional<Double> additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
            return this;
        }

        @java.lang.Override
        public _FinalStage baseMileageRateUsdPerInstance(Nullable<Double> baseMileageRateUsdPerInstance) {
            if (baseMileageRateUsdPerInstance.isNull()) {
                this.baseMileageRateUsdPerInstance = null;
            } else if (baseMileageRateUsdPerInstance.isEmpty()) {
                this.baseMileageRateUsdPerInstance = Optional.empty();
            } else {
                this.baseMileageRateUsdPerInstance = Optional.of(baseMileageRateUsdPerInstance.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage baseMileageRateUsdPerInstance(Double baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = Optional.ofNullable(baseMileageRateUsdPerInstance);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "base_mileage_rate_usd_per_instance", nulls = Nulls.SKIP)
        public _FinalStage baseMileageRateUsdPerInstance(Optional<Double> baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
            return this;
        }

        @java.lang.Override
        public _FinalStage baseMileageDistanceMiles(Nullable<Double> baseMileageDistanceMiles) {
            if (baseMileageDistanceMiles.isNull()) {
                this.baseMileageDistanceMiles = null;
            } else if (baseMileageDistanceMiles.isEmpty()) {
                this.baseMileageDistanceMiles = Optional.empty();
            } else {
                this.baseMileageDistanceMiles = Optional.of(baseMileageDistanceMiles.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage baseMileageDistanceMiles(Double baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = Optional.ofNullable(baseMileageDistanceMiles);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "base_mileage_distance_miles", nulls = Nulls.SKIP)
        public _FinalStage baseMileageDistanceMiles(Optional<Double> baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = baseMileageDistanceMiles;
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoTypes(List<CargoTypeEnum1> cargoTypes) {
            this.cargoTypes = Optional.ofNullable(cargoTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargo_types", nulls = Nulls.SKIP)
        public _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes) {
            this.cargoTypes = cargoTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public _FinalStage name(Nullable<String> name) {
            if (name.isNull()) {
                this.name = null;
            } else if (name.isEmpty()) {
                this.name = Optional.empty();
            } else {
                this.name = Optional.of(name.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @java.lang.Override
        public _FinalStage archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "archived", nulls = Nulls.SKIP)
        public _FinalStage archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        @java.lang.Override
        public RateSheetClientCreate1 build() {
            return new RateSheetClientCreate1(
                    paymentVectorType,
                    schemaVersion,
                    archived,
                    name,
                    comments,
                    cargoTypes,
                    vehicleTypes,
                    serviceType,
                    baseMileageDistanceMiles,
                    baseMileageRateUsdPerInstance,
                    additionalMileageRateUsdPerMile,
                    longDistanceSurchargeMilesBeforeSurcharge,
                    longDistanceSurchargeRateUsdPerMile,
                    fuelSurchargeRateUsdPerMile,
                    waitTimeBeforeChargeMinutes,
                    waitTimeRateUsdPerMinute,
                    extraStopRateUsd,
                    dangerousGoodsRateUsdPerInstance,
                    afterHoursRateUsdPerInstance,
                    weekendRateUsdPerInstance,
                    holidayRateUsdPerInstance,
                    additionalProperties);
        }
    }
}
