/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RateSheetClientUpdate1.Builder.class)
public final class RateSheetClientUpdate1 {
    private final Optional<String> name;

    private final Optional<String> comments;

    private final Optional<List<CargoTypeEnum1>> cargoTypes;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final Map<String, Object> additionalProperties;

    private RateSheetClientUpdate1(
            Optional<String> name,
            Optional<String> comments,
            Optional<List<CargoTypeEnum1>> cargoTypes,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.comments = comments;
        this.cargoTypes = cargoTypes;
        this.vehicleTypes = vehicleTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (name == null) {
            return Optional.empty();
        }
        return name;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonIgnore
    public Optional<List<CargoTypeEnum1>> getCargoTypes() {
        if (cargoTypes == null) {
            return Optional.empty();
        }
        return cargoTypes;
    }

    @JsonIgnore
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        if (vehicleTypes == null) {
            return Optional.empty();
        }
        return vehicleTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("name")
    private Optional<String> _getName() {
        return name;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargo_types")
    private Optional<List<CargoTypeEnum1>> _getCargoTypes() {
        return cargoTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("vehicle_types")
    private Optional<List<VehicleTypeEnum>> _getVehicleTypes() {
        return vehicleTypes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RateSheetClientUpdate1 && equalTo((RateSheetClientUpdate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetClientUpdate1 other) {
        return name.equals(other.name)
                && comments.equals(other.comments)
                && cargoTypes.equals(other.cargoTypes)
                && vehicleTypes.equals(other.vehicleTypes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.comments, this.cargoTypes, this.vehicleTypes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();

        private Optional<String> comments = Optional.empty();

        private Optional<List<CargoTypeEnum1>> cargoTypes = Optional.empty();

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(RateSheetClientUpdate1 other) {
            name(other.getName());
            comments(other.getComments());
            cargoTypes(other.getCargoTypes());
            vehicleTypes(other.getVehicleTypes());
            return this;
        }

        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            if (name.isNull()) {
                this.name = null;
            } else if (name.isEmpty()) {
                this.name = Optional.empty();
            } else {
                this.name = Optional.of(name.get());
            }
            return this;
        }

        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public Builder comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        public Builder comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        public Builder comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @JsonSetter(value = "cargo_types", nulls = Nulls.SKIP)
        public Builder cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes) {
            this.cargoTypes = cargoTypes;
            return this;
        }

        public Builder cargoTypes(List<CargoTypeEnum1> cargoTypes) {
            this.cargoTypes = Optional.ofNullable(cargoTypes);
            return this;
        }

        public Builder cargoTypes(Nullable<List<CargoTypeEnum1>> cargoTypes) {
            if (cargoTypes.isNull()) {
                this.cargoTypes = null;
            } else if (cargoTypes.isEmpty()) {
                this.cargoTypes = Optional.empty();
            } else {
                this.cargoTypes = Optional.of(cargoTypes.get());
            }
            return this;
        }

        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public Builder vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        public Builder vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        public Builder vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes) {
            if (vehicleTypes.isNull()) {
                this.vehicleTypes = null;
            } else if (vehicleTypes.isEmpty()) {
                this.vehicleTypes = Optional.empty();
            } else {
                this.vehicleTypes = Optional.of(vehicleTypes.get());
            }
            return this;
        }

        public RateSheetClientUpdate1 build() {
            return new RateSheetClientUpdate1(name, comments, cargoTypes, vehicleTypes, additionalProperties);
        }
    }
}
