/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.resources.billing.ratesheets.types.RateSheetsListByOrgV1RequestSortOrder;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.RateSheetSortByEnum;
import com.chrt.api.types.ServiceTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RateSheetsListByOrgV1Request.Builder.class)
public final class RateSheetsListByOrgV1Request {
    private final Optional<RateSheetSortByEnum> sortBy;

    private final Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Optional<Boolean> filterArchived;

    private final Optional<PaymentVectorTypeEnum1> filterPaymentVectorType;

    private final Optional<ServiceTypeEnum1> filterServiceType;

    private final Optional<CargoTypeEnum1> filterCargoType;

    private final Optional<VehicleTypeEnum> filterVehicleType;

    private final Map<String, Object> additionalProperties;

    private RateSheetsListByOrgV1Request(
            Optional<RateSheetSortByEnum> sortBy,
            Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Optional<Boolean> filterArchived,
            Optional<PaymentVectorTypeEnum1> filterPaymentVectorType,
            Optional<ServiceTypeEnum1> filterServiceType,
            Optional<CargoTypeEnum1> filterCargoType,
            Optional<VehicleTypeEnum> filterVehicleType,
            Map<String, Object> additionalProperties) {
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterArchived = filterArchived;
        this.filterPaymentVectorType = filterPaymentVectorType;
        this.filterServiceType = filterServiceType;
        this.filterCargoType = filterCargoType;
        this.filterVehicleType = filterVehicleType;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<RateSheetSortByEnum> getSortBy() {
        if (sortBy == null) {
            return Optional.empty();
        }
        return sortBy;
    }

    @JsonIgnore
    public Optional<RateSheetsListByOrgV1RequestSortOrder> getSortOrder() {
        if (sortOrder == null) {
            return Optional.empty();
        }
        return sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    @JsonIgnore
    public Optional<Boolean> getFilterArchived() {
        if (filterArchived == null) {
            return Optional.empty();
        }
        return filterArchived;
    }

    @JsonIgnore
    public Optional<PaymentVectorTypeEnum1> getFilterPaymentVectorType() {
        if (filterPaymentVectorType == null) {
            return Optional.empty();
        }
        return filterPaymentVectorType;
    }

    /**
     * @return Filter by service type (exact match)
     */
    @JsonIgnore
    public Optional<ServiceTypeEnum1> getFilterServiceType() {
        if (filterServiceType == null) {
            return Optional.empty();
        }
        return filterServiceType;
    }

    /**
     * @return Filter by cargo type (checks if value is in cargo_types array)
     */
    @JsonIgnore
    public Optional<CargoTypeEnum1> getFilterCargoType() {
        if (filterCargoType == null) {
            return Optional.empty();
        }
        return filterCargoType;
    }

    /**
     * @return Filter by vehicle type (checks if value is in vehicle_types array)
     */
    @JsonIgnore
    public Optional<VehicleTypeEnum> getFilterVehicleType() {
        if (filterVehicleType == null) {
            return Optional.empty();
        }
        return filterVehicleType;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_by")
    private Optional<RateSheetSortByEnum> _getSortBy() {
        return sortBy;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_order")
    private Optional<RateSheetsListByOrgV1RequestSortOrder> _getSortOrder() {
        return sortOrder;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_archived")
    private Optional<Boolean> _getFilterArchived() {
        return filterArchived;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_payment_vector_type")
    private Optional<PaymentVectorTypeEnum1> _getFilterPaymentVectorType() {
        return filterPaymentVectorType;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_service_type")
    private Optional<ServiceTypeEnum1> _getFilterServiceType() {
        return filterServiceType;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_cargo_type")
    private Optional<CargoTypeEnum1> _getFilterCargoType() {
        return filterCargoType;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_vehicle_type")
    private Optional<VehicleTypeEnum> _getFilterVehicleType() {
        return filterVehicleType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RateSheetsListByOrgV1Request && equalTo((RateSheetsListByOrgV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetsListByOrgV1Request other) {
        return sortBy.equals(other.sortBy)
                && sortOrder.equals(other.sortOrder)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize)
                && filterArchived.equals(other.filterArchived)
                && filterPaymentVectorType.equals(other.filterPaymentVectorType)
                && filterServiceType.equals(other.filterServiceType)
                && filterCargoType.equals(other.filterCargoType)
                && filterVehicleType.equals(other.filterVehicleType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.sortBy,
                this.sortOrder,
                this.page,
                this.pageSize,
                this.filterArchived,
                this.filterPaymentVectorType,
                this.filterServiceType,
                this.filterCargoType,
                this.filterVehicleType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<RateSheetSortByEnum> sortBy = Optional.empty();

        private Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        private Optional<Boolean> filterArchived = Optional.empty();

        private Optional<PaymentVectorTypeEnum1> filterPaymentVectorType = Optional.empty();

        private Optional<ServiceTypeEnum1> filterServiceType = Optional.empty();

        private Optional<CargoTypeEnum1> filterCargoType = Optional.empty();

        private Optional<VehicleTypeEnum> filterVehicleType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(RateSheetsListByOrgV1Request other) {
            sortBy(other.getSortBy());
            sortOrder(other.getSortOrder());
            page(other.getPage());
            pageSize(other.getPageSize());
            filterArchived(other.getFilterArchived());
            filterPaymentVectorType(other.getFilterPaymentVectorType());
            filterServiceType(other.getFilterServiceType());
            filterCargoType(other.getFilterCargoType());
            filterVehicleType(other.getFilterVehicleType());
            return this;
        }

        @JsonSetter(value = "sort_by", nulls = Nulls.SKIP)
        public Builder sortBy(Optional<RateSheetSortByEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortBy(RateSheetSortByEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        public Builder sortBy(Nullable<RateSheetSortByEnum> sortBy) {
            if (sortBy.isNull()) {
                this.sortBy = null;
            } else if (sortBy.isEmpty()) {
                this.sortBy = Optional.empty();
            } else {
                this.sortBy = Optional.of(sortBy.get());
            }
            return this;
        }

        @JsonSetter(value = "sort_order", nulls = Nulls.SKIP)
        public Builder sortOrder(Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(RateSheetsListByOrgV1RequestSortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<RateSheetsListByOrgV1RequestSortOrder> sortOrder) {
            if (sortOrder.isNull()) {
                this.sortOrder = null;
            } else if (sortOrder.isEmpty()) {
                this.sortOrder = Optional.empty();
            } else {
                this.sortOrder = Optional.of(sortOrder.get());
            }
            return this;
        }

        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        public Builder page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        public Builder pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        @JsonSetter(value = "filter_archived", nulls = Nulls.SKIP)
        public Builder filterArchived(Optional<Boolean> filterArchived) {
            this.filterArchived = filterArchived;
            return this;
        }

        public Builder filterArchived(Boolean filterArchived) {
            this.filterArchived = Optional.ofNullable(filterArchived);
            return this;
        }

        public Builder filterArchived(Nullable<Boolean> filterArchived) {
            if (filterArchived.isNull()) {
                this.filterArchived = null;
            } else if (filterArchived.isEmpty()) {
                this.filterArchived = Optional.empty();
            } else {
                this.filterArchived = Optional.of(filterArchived.get());
            }
            return this;
        }

        @JsonSetter(value = "filter_payment_vector_type", nulls = Nulls.SKIP)
        public Builder filterPaymentVectorType(Optional<PaymentVectorTypeEnum1> filterPaymentVectorType) {
            this.filterPaymentVectorType = filterPaymentVectorType;
            return this;
        }

        public Builder filterPaymentVectorType(PaymentVectorTypeEnum1 filterPaymentVectorType) {
            this.filterPaymentVectorType = Optional.ofNullable(filterPaymentVectorType);
            return this;
        }

        public Builder filterPaymentVectorType(Nullable<PaymentVectorTypeEnum1> filterPaymentVectorType) {
            if (filterPaymentVectorType.isNull()) {
                this.filterPaymentVectorType = null;
            } else if (filterPaymentVectorType.isEmpty()) {
                this.filterPaymentVectorType = Optional.empty();
            } else {
                this.filterPaymentVectorType = Optional.of(filterPaymentVectorType.get());
            }
            return this;
        }

        /**
         * <p>Filter by service type (exact match)</p>
         */
        @JsonSetter(value = "filter_service_type", nulls = Nulls.SKIP)
        public Builder filterServiceType(Optional<ServiceTypeEnum1> filterServiceType) {
            this.filterServiceType = filterServiceType;
            return this;
        }

        public Builder filterServiceType(ServiceTypeEnum1 filterServiceType) {
            this.filterServiceType = Optional.ofNullable(filterServiceType);
            return this;
        }

        public Builder filterServiceType(Nullable<ServiceTypeEnum1> filterServiceType) {
            if (filterServiceType.isNull()) {
                this.filterServiceType = null;
            } else if (filterServiceType.isEmpty()) {
                this.filterServiceType = Optional.empty();
            } else {
                this.filterServiceType = Optional.of(filterServiceType.get());
            }
            return this;
        }

        /**
         * <p>Filter by cargo type (checks if value is in cargo_types array)</p>
         */
        @JsonSetter(value = "filter_cargo_type", nulls = Nulls.SKIP)
        public Builder filterCargoType(Optional<CargoTypeEnum1> filterCargoType) {
            this.filterCargoType = filterCargoType;
            return this;
        }

        public Builder filterCargoType(CargoTypeEnum1 filterCargoType) {
            this.filterCargoType = Optional.ofNullable(filterCargoType);
            return this;
        }

        public Builder filterCargoType(Nullable<CargoTypeEnum1> filterCargoType) {
            if (filterCargoType.isNull()) {
                this.filterCargoType = null;
            } else if (filterCargoType.isEmpty()) {
                this.filterCargoType = Optional.empty();
            } else {
                this.filterCargoType = Optional.of(filterCargoType.get());
            }
            return this;
        }

        /**
         * <p>Filter by vehicle type (checks if value is in vehicle_types array)</p>
         */
        @JsonSetter(value = "filter_vehicle_type", nulls = Nulls.SKIP)
        public Builder filterVehicleType(Optional<VehicleTypeEnum> filterVehicleType) {
            this.filterVehicleType = filterVehicleType;
            return this;
        }

        public Builder filterVehicleType(VehicleTypeEnum filterVehicleType) {
            this.filterVehicleType = Optional.ofNullable(filterVehicleType);
            return this;
        }

        public Builder filterVehicleType(Nullable<VehicleTypeEnum> filterVehicleType) {
            if (filterVehicleType.isNull()) {
                this.filterVehicleType = null;
            } else if (filterVehicleType.isEmpty()) {
                this.filterVehicleType = Optional.empty();
            } else {
                this.filterVehicleType = Optional.of(filterVehicleType.get());
            }
            return this;
        }

        public RateSheetsListByOrgV1Request build() {
            return new RateSheetsListByOrgV1Request(
                    sortBy,
                    sortOrder,
                    page,
                    pageSize,
                    filterArchived,
                    filterPaymentVectorType,
                    filterServiceType,
                    filterCargoType,
                    filterVehicleType,
                    additionalProperties);
        }
    }
}
