/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ServiceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RateSheetsUpdateDefaultForConnectionV1Request.Builder.class)
public final class RateSheetsUpdateDefaultForConnectionV1Request {
    private final String connectionId;

    private final ServiceTypeEnum1 serviceType;

    private final Optional<String> rateSheetId;

    private final Map<String, Object> additionalProperties;

    private RateSheetsUpdateDefaultForConnectionV1Request(
            String connectionId,
            ServiceTypeEnum1 serviceType,
            Optional<String> rateSheetId,
            Map<String, Object> additionalProperties) {
        this.connectionId = connectionId;
        this.serviceType = serviceType;
        this.rateSheetId = rateSheetId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("connection_id")
    public String getConnectionId() {
        return connectionId;
    }

    @JsonProperty("service_type")
    public ServiceTypeEnum1 getServiceType() {
        return serviceType;
    }

    @JsonIgnore
    public Optional<String> getRateSheetId() {
        if (rateSheetId == null) {
            return Optional.empty();
        }
        return rateSheetId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("rate_sheet_id")
    private Optional<String> _getRateSheetId() {
        return rateSheetId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RateSheetsUpdateDefaultForConnectionV1Request
                && equalTo((RateSheetsUpdateDefaultForConnectionV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetsUpdateDefaultForConnectionV1Request other) {
        return connectionId.equals(other.connectionId)
                && serviceType.equals(other.serviceType)
                && rateSheetId.equals(other.rateSheetId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.connectionId, this.serviceType, this.rateSheetId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConnectionIdStage builder() {
        return new Builder();
    }

    public interface ConnectionIdStage {
        ServiceTypeStage connectionId(@NotNull String connectionId);

        Builder from(RateSheetsUpdateDefaultForConnectionV1Request other);
    }

    public interface ServiceTypeStage {
        _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType);
    }

    public interface _FinalStage {
        RateSheetsUpdateDefaultForConnectionV1Request build();

        _FinalStage rateSheetId(Optional<String> rateSheetId);

        _FinalStage rateSheetId(String rateSheetId);

        _FinalStage rateSheetId(Nullable<String> rateSheetId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConnectionIdStage, ServiceTypeStage, _FinalStage {
        private String connectionId;

        private ServiceTypeEnum1 serviceType;

        private Optional<String> rateSheetId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RateSheetsUpdateDefaultForConnectionV1Request other) {
            connectionId(other.getConnectionId());
            serviceType(other.getServiceType());
            rateSheetId(other.getRateSheetId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("connection_id")
        public ServiceTypeStage connectionId(@NotNull String connectionId) {
            this.connectionId = Objects.requireNonNull(connectionId, "connectionId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("service_type")
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage rateSheetId(Nullable<String> rateSheetId) {
            if (rateSheetId.isNull()) {
                this.rateSheetId = null;
            } else if (rateSheetId.isEmpty()) {
                this.rateSheetId = Optional.empty();
            } else {
                this.rateSheetId = Optional.of(rateSheetId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage rateSheetId(String rateSheetId) {
            this.rateSheetId = Optional.ofNullable(rateSheetId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rate_sheet_id", nulls = Nulls.SKIP)
        public _FinalStage rateSheetId(Optional<String> rateSheetId) {
            this.rateSheetId = rateSheetId;
            return this;
        }

        @java.lang.Override
        public RateSheetsUpdateDefaultForConnectionV1Request build() {
            return new RateSheetsUpdateDefaultForConnectionV1Request(
                    connectionId, serviceType, rateSheetId, additionalProperties);
        }
    }
}
