/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.ServiceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RateSheetsUpdateOrgDefaultForServiceTypeV1Request.Builder.class)
public final class RateSheetsUpdateOrgDefaultForServiceTypeV1Request {
    private final PaymentVectorTypeEnum1 paymentVectorType;

    private final ServiceTypeEnum1 serviceType;

    private final Optional<String> rateSheetId;

    private final Map<String, Object> additionalProperties;

    private RateSheetsUpdateOrgDefaultForServiceTypeV1Request(
            PaymentVectorTypeEnum1 paymentVectorType,
            ServiceTypeEnum1 serviceType,
            Optional<String> rateSheetId,
            Map<String, Object> additionalProperties) {
        this.paymentVectorType = paymentVectorType;
        this.serviceType = serviceType;
        this.rateSheetId = rateSheetId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return paymentVectorType;
    }

    @JsonProperty("service_type")
    public ServiceTypeEnum1 getServiceType() {
        return serviceType;
    }

    @JsonIgnore
    public Optional<String> getRateSheetId() {
        if (rateSheetId == null) {
            return Optional.empty();
        }
        return rateSheetId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("rate_sheet_id")
    private Optional<String> _getRateSheetId() {
        return rateSheetId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RateSheetsUpdateOrgDefaultForServiceTypeV1Request
                && equalTo((RateSheetsUpdateOrgDefaultForServiceTypeV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetsUpdateOrgDefaultForServiceTypeV1Request other) {
        return paymentVectorType.equals(other.paymentVectorType)
                && serviceType.equals(other.serviceType)
                && rateSheetId.equals(other.rateSheetId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.paymentVectorType, this.serviceType, this.rateSheetId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentVectorTypeStage builder() {
        return new Builder();
    }

    public interface PaymentVectorTypeStage {
        ServiceTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType);

        Builder from(RateSheetsUpdateOrgDefaultForServiceTypeV1Request other);
    }

    public interface ServiceTypeStage {
        _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType);
    }

    public interface _FinalStage {
        RateSheetsUpdateOrgDefaultForServiceTypeV1Request build();

        _FinalStage rateSheetId(Optional<String> rateSheetId);

        _FinalStage rateSheetId(String rateSheetId);

        _FinalStage rateSheetId(Nullable<String> rateSheetId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PaymentVectorTypeStage, ServiceTypeStage, _FinalStage {
        private PaymentVectorTypeEnum1 paymentVectorType;

        private ServiceTypeEnum1 serviceType;

        private Optional<String> rateSheetId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RateSheetsUpdateOrgDefaultForServiceTypeV1Request other) {
            paymentVectorType(other.getPaymentVectorType());
            serviceType(other.getServiceType());
            rateSheetId(other.getRateSheetId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("payment_vector_type")
        public ServiceTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("service_type")
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage rateSheetId(Nullable<String> rateSheetId) {
            if (rateSheetId.isNull()) {
                this.rateSheetId = null;
            } else if (rateSheetId.isEmpty()) {
                this.rateSheetId = Optional.empty();
            } else {
                this.rateSheetId = Optional.of(rateSheetId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage rateSheetId(String rateSheetId) {
            this.rateSheetId = Optional.ofNullable(rateSheetId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rate_sheet_id", nulls = Nulls.SKIP)
        public _FinalStage rateSheetId(Optional<String> rateSheetId) {
            this.rateSheetId = rateSheetId;
            return this;
        }

        @java.lang.Override
        public RateSheetsUpdateOrgDefaultForServiceTypeV1Request build() {
            return new RateSheetsUpdateOrgDefaultForServiceTypeV1Request(
                    paymentVectorType, serviceType, rateSheetId, additionalProperties);
        }
    }
}
