/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.statements;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.statements.requests.BodyStatementsPatchUpdateOffChrtSettlementStateV1BillingUpdateOffChrtSettlementStateV1StatementIdPatch;
import com.chrt.api.resources.billing.statements.requests.BodyStatementsPatchUpdateSettlementTypeV1BillingUpdateSettlementTypeV1StatementIdPatch;
import com.chrt.api.resources.billing.statements.requests.CreateStatementReq;
import com.chrt.api.resources.billing.statements.requests.OpenInvoiceReq;
import com.chrt.api.resources.billing.statements.requests.StatementExpandedRetrieveReq;
import com.chrt.api.resources.billing.statements.requests.StatementsListV1Request;
import com.chrt.api.types.Statement1;
import com.chrt.api.types.StatementExpandedRes;
import com.chrt.api.types.StatementsListRes;
import java.util.concurrent.CompletableFuture;

public class AsyncStatementsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawStatementsClient rawClient;

    public AsyncStatementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawStatementsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawStatementsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Gets a statement by ID. | authz_personas=[statement_org_operators, statement_driver] | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> getV1(String statementId) {
        return this.rawClient.getV1(statementId).thenApply(response -> response.body());
    }

    /**
     * Gets a statement by ID. | authz_personas=[statement_org_operators, statement_driver] | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> getV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.getV1(statementId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Gets a statement by its associated LineItemGroup ID. | authz_personas=[statement_org_operators, statement_driver] | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> getByLigIdV1(String lineItemGroupId) {
        return this.rawClient.getByLigIdV1(lineItemGroupId).thenApply(response -> response.body());
    }

    /**
     * Gets a statement by its associated LineItemGroup ID. | authz_personas=[statement_org_operators, statement_driver] | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> getByLigIdV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.getByLigIdV1(lineItemGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a statement with its associated LineItemGroups expanded. | authz_personas=[statement_org_operators, statement_driver] | (StatementExpandedRetrieveReq) -&gt; (StatementExpandedRes)
     */
    public CompletableFuture<StatementExpandedRes> expandedRetrieveV1(StatementExpandedRetrieveReq request) {
        return this.rawClient.expandedRetrieveV1(request).thenApply(response -> response.body());
    }

    /**
     * Retrieves a statement with its associated LineItemGroups expanded. | authz_personas=[statement_org_operators, statement_driver] | (StatementExpandedRetrieveReq) -&gt; (StatementExpandedRes)
     */
    public CompletableFuture<StatementExpandedRes> expandedRetrieveV1(
            StatementExpandedRetrieveReq request, RequestOptions requestOptions) {
        return this.rawClient.expandedRetrieveV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists statements with filtering, sorting, and pagination. | authz_personas=[statement_org_operators, statement_driver] | () -&gt; (StatementsListRes)
     */
    public CompletableFuture<StatementsListRes> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Lists statements with filtering, sorting, and pagination. | authz_personas=[statement_org_operators, statement_driver] | () -&gt; (StatementsListRes)
     */
    public CompletableFuture<StatementsListRes> listV1(StatementsListV1Request request) {
        return this.rawClient.listV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists statements with filtering, sorting, and pagination. | authz_personas=[statement_org_operators, statement_driver] | () -&gt; (StatementsListRes)
     */
    public CompletableFuture<StatementsListRes> listV1(StatementsListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new statement without LIG IDs, starting in STAGED status. Requires payment vector, origin, and destination. | authz: org_type=[courier, forwarder], min_org_role=operator | (CreateStatementReq) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> createV1(CreateStatementReq request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new statement without LIG IDs, starting in STAGED status. Requires payment vector, origin, and destination. | authz: org_type=[courier, forwarder], min_org_role=operator | (CreateStatementReq) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> createV1(CreateStatementReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a statement. Only allowed if statement has no LineItemGroup IDs. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String statementId) {
        return this.rawClient.deleteV1(statementId).thenApply(response -> response.body());
    }

    /**
     * Deletes a statement. Only allowed if statement has no LineItemGroup IDs. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(statementId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the settlement type of a statement. Statement must be in STAGED status. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators], statement_status=STAGED | (SettlementTypeEnum1) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> updateSettlementTypeV1(
            String statementId,
            BodyStatementsPatchUpdateSettlementTypeV1BillingUpdateSettlementTypeV1StatementIdPatch request) {
        return this.rawClient.updateSettlementTypeV1(statementId, request).thenApply(response -> response.body());
    }

    /**
     * Updates the settlement type of a statement. Statement must be in STAGED status. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators], statement_status=STAGED | (SettlementTypeEnum1) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> updateSettlementTypeV1(
            String statementId,
            BodyStatementsPatchUpdateSettlementTypeV1BillingUpdateSettlementTypeV1StatementIdPatch request,
            RequestOptions requestOptions) {
        return this.rawClient
                .updateSettlementTypeV1(statementId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Updates the status of an off-CHRT settlement statement. Used to manually transition OFF_CHRT statements between STAGED, OPEN, PAID, and VOID. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators] | (StatementStatusEnum1) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> updateOffChrtSettlementStateV1(
            String statementId,
            BodyStatementsPatchUpdateOffChrtSettlementStateV1BillingUpdateOffChrtSettlementStateV1StatementIdPatch
                    request) {
        return this.rawClient
                .updateOffChrtSettlementStateV1(statementId, request)
                .thenApply(response -> response.body());
    }

    /**
     * Updates the status of an off-CHRT settlement statement. Used to manually transition OFF_CHRT statements between STAGED, OPEN, PAID, and VOID. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators] | (StatementStatusEnum1) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> updateOffChrtSettlementStateV1(
            String statementId,
            BodyStatementsPatchUpdateOffChrtSettlementStateV1BillingUpdateOffChrtSettlementStateV1StatementIdPatch
                    request,
            RequestOptions requestOptions) {
        return this.rawClient
                .updateOffChrtSettlementStateV1(statementId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Opens a Stripe Connect invoice for a statement and attempt to send via email. Org must have a Stripe Connect account. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators], statement_status=STAGED, line_item_groups_status=FINALIZED | (OpenInvoiceReq) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> openInvoiceV1(String statementId) {
        return this.rawClient.openInvoiceV1(statementId).thenApply(response -> response.body());
    }

    /**
     * Opens a Stripe Connect invoice for a statement and attempt to send via email. Org must have a Stripe Connect account. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators], statement_status=STAGED, line_item_groups_status=FINALIZED | (OpenInvoiceReq) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> openInvoiceV1(String statementId, OpenInvoiceReq request) {
        return this.rawClient.openInvoiceV1(statementId, request).thenApply(response -> response.body());
    }

    /**
     * Opens a Stripe Connect invoice for a statement and attempt to send via email. Org must have a Stripe Connect account. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators], statement_status=STAGED, line_item_groups_status=FINALIZED | (OpenInvoiceReq) -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> openInvoiceV1(
            String statementId, OpenInvoiceReq request, RequestOptions requestOptions) {
        return this.rawClient
                .openInvoiceV1(statementId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Syncs invoice state from Stripe Connect to the Statement and LineItemGroups. The webhook usually keeps invoices up to date, but users can manually trigger a sync. | authz: org_type=[courier, forwarder, shipper], min_org_role=operator, authz_personas=[statement_org_operators] | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> syncInvoiceV1(String statementId) {
        return this.rawClient.syncInvoiceV1(statementId).thenApply(response -> response.body());
    }

    /**
     * Syncs invoice state from Stripe Connect to the Statement and LineItemGroups. The webhook usually keeps invoices up to date, but users can manually trigger a sync. | authz: org_type=[courier, forwarder, shipper], min_org_role=operator, authz_personas=[statement_org_operators] | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> syncInvoiceV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.syncInvoiceV1(statementId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Voids a Stripe Connect invoice. Statement reverts to STAGED and LIGs revert to FINALIZED. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators], statement_status=OPEN | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> voidInvoiceV1(String statementId) {
        return this.rawClient.voidInvoiceV1(statementId).thenApply(response -> response.body());
    }

    /**
     * Voids a Stripe Connect invoice. Statement reverts to STAGED and LIGs revert to FINALIZED. | authz: org_type=[courier, forwarder], min_org_role=operator, authz_personas=[statement_owner_operators], statement_status=OPEN | () -&gt; (Statement1)
     */
    public CompletableFuture<Statement1> voidInvoiceV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.voidInvoiceV1(statementId, requestOptions).thenApply(response -> response.body());
    }
}
