/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.statements.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.SettlementTypeEnum1;
import com.chrt.api.types.SortOrderEnum;
import com.chrt.api.types.StatementSortByEnum;
import com.chrt.api.types.StatementStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = StatementsListV1Request.Builder.class)
public final class StatementsListV1Request {
    private final Optional<List<StatementStatusEnum1>> filterStatus;

    private final Optional<StatementSortByEnum> sortBy;

    private final Optional<SortOrderEnum> sortOrder;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Optional<SettlementTypeEnum1> filterSettlementType;

    private final Optional<String> filterPaymentOriginOrgId;

    private final Optional<String> filterPaymentDestinationOrgId;

    private final Optional<String> filterOwnedByOrgId;

    private final Optional<OffsetDateTime> filterStagedAtTimestampGte;

    private final Optional<OffsetDateTime> filterStagedAtTimestampLte;

    private final Optional<OffsetDateTime> filterOpenedAtTimestampGte;

    private final Optional<OffsetDateTime> filterOpenedAtTimestampLte;

    private final Optional<OffsetDateTime> filterPaidAtTimestampGte;

    private final Optional<OffsetDateTime> filterPaidAtTimestampLte;

    private final Map<String, Object> additionalProperties;

    private StatementsListV1Request(
            Optional<List<StatementStatusEnum1>> filterStatus,
            Optional<StatementSortByEnum> sortBy,
            Optional<SortOrderEnum> sortOrder,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Optional<SettlementTypeEnum1> filterSettlementType,
            Optional<String> filterPaymentOriginOrgId,
            Optional<String> filterPaymentDestinationOrgId,
            Optional<String> filterOwnedByOrgId,
            Optional<OffsetDateTime> filterStagedAtTimestampGte,
            Optional<OffsetDateTime> filterStagedAtTimestampLte,
            Optional<OffsetDateTime> filterOpenedAtTimestampGte,
            Optional<OffsetDateTime> filterOpenedAtTimestampLte,
            Optional<OffsetDateTime> filterPaidAtTimestampGte,
            Optional<OffsetDateTime> filterPaidAtTimestampLte,
            Map<String, Object> additionalProperties) {
        this.filterStatus = filterStatus;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterSettlementType = filterSettlementType;
        this.filterPaymentOriginOrgId = filterPaymentOriginOrgId;
        this.filterPaymentDestinationOrgId = filterPaymentDestinationOrgId;
        this.filterOwnedByOrgId = filterOwnedByOrgId;
        this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
        this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
        this.filterOpenedAtTimestampGte = filterOpenedAtTimestampGte;
        this.filterOpenedAtTimestampLte = filterOpenedAtTimestampLte;
        this.filterPaidAtTimestampGte = filterPaidAtTimestampGte;
        this.filterPaidAtTimestampLte = filterPaidAtTimestampLte;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter by statement status(es)
     */
    @JsonIgnore
    public Optional<List<StatementStatusEnum1>> getFilterStatus() {
        if (filterStatus == null) {
            return Optional.empty();
        }
        return filterStatus;
    }

    /**
     * @return Field to sort by
     */
    @JsonIgnore
    public Optional<StatementSortByEnum> getSortBy() {
        if (sortBy == null) {
            return Optional.empty();
        }
        return sortBy;
    }

    /**
     * @return Sort order (ascending or descending)
     */
    @JsonIgnore
    public Optional<SortOrderEnum> getSortOrder() {
        if (sortOrder == null) {
            return Optional.empty();
        }
        return sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    /**
     * @return Filter by settlement type
     */
    @JsonIgnore
    public Optional<SettlementTypeEnum1> getFilterSettlementType() {
        if (filterSettlementType == null) {
            return Optional.empty();
        }
        return filterSettlementType;
    }

    /**
     * @return Filter by payment origin org ID
     */
    @JsonIgnore
    public Optional<String> getFilterPaymentOriginOrgId() {
        if (filterPaymentOriginOrgId == null) {
            return Optional.empty();
        }
        return filterPaymentOriginOrgId;
    }

    /**
     * @return Filter by payment destination org ID
     */
    @JsonIgnore
    public Optional<String> getFilterPaymentDestinationOrgId() {
        if (filterPaymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return filterPaymentDestinationOrgId;
    }

    /**
     * @return Filter by owned by org ID
     */
    @JsonIgnore
    public Optional<String> getFilterOwnedByOrgId() {
        if (filterOwnedByOrgId == null) {
            return Optional.empty();
        }
        return filterOwnedByOrgId;
    }

    /**
     * @return Filter by staged_at_timestamp &gt;= value
     */
    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampGte() {
        if (filterStagedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterStagedAtTimestampGte;
    }

    /**
     * @return Filter by staged_at_timestamp &lt;= value
     */
    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampLte() {
        if (filterStagedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterStagedAtTimestampLte;
    }

    /**
     * @return Filter by opened_at_timestamp &gt;= value
     */
    @JsonIgnore
    public Optional<OffsetDateTime> getFilterOpenedAtTimestampGte() {
        if (filterOpenedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterOpenedAtTimestampGte;
    }

    /**
     * @return Filter by opened_at_timestamp &lt;= value
     */
    @JsonIgnore
    public Optional<OffsetDateTime> getFilterOpenedAtTimestampLte() {
        if (filterOpenedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterOpenedAtTimestampLte;
    }

    /**
     * @return Filter by paid_at_timestamp &gt;= value
     */
    @JsonIgnore
    public Optional<OffsetDateTime> getFilterPaidAtTimestampGte() {
        if (filterPaidAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterPaidAtTimestampGte;
    }

    /**
     * @return Filter by paid_at_timestamp &lt;= value
     */
    @JsonIgnore
    public Optional<OffsetDateTime> getFilterPaidAtTimestampLte() {
        if (filterPaidAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterPaidAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_status")
    private Optional<List<StatementStatusEnum1>> _getFilterStatus() {
        return filterStatus;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_by")
    private Optional<StatementSortByEnum> _getSortBy() {
        return sortBy;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_order")
    private Optional<SortOrderEnum> _getSortOrder() {
        return sortOrder;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_settlement_type")
    private Optional<SettlementTypeEnum1> _getFilterSettlementType() {
        return filterSettlementType;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_payment_origin_org_id")
    private Optional<String> _getFilterPaymentOriginOrgId() {
        return filterPaymentOriginOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_payment_destination_org_id")
    private Optional<String> _getFilterPaymentDestinationOrgId() {
        return filterPaymentDestinationOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_owned_by_org_id")
    private Optional<String> _getFilterOwnedByOrgId() {
        return filterOwnedByOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_staged_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampGte() {
        return filterStagedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_staged_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampLte() {
        return filterStagedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_opened_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterOpenedAtTimestampGte() {
        return filterOpenedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_opened_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterOpenedAtTimestampLte() {
        return filterOpenedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_paid_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterPaidAtTimestampGte() {
        return filterPaidAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_paid_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterPaidAtTimestampLte() {
        return filterPaidAtTimestampLte;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof StatementsListV1Request && equalTo((StatementsListV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementsListV1Request other) {
        return filterStatus.equals(other.filterStatus)
                && sortBy.equals(other.sortBy)
                && sortOrder.equals(other.sortOrder)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize)
                && filterSettlementType.equals(other.filterSettlementType)
                && filterPaymentOriginOrgId.equals(other.filterPaymentOriginOrgId)
                && filterPaymentDestinationOrgId.equals(other.filterPaymentDestinationOrgId)
                && filterOwnedByOrgId.equals(other.filterOwnedByOrgId)
                && filterStagedAtTimestampGte.equals(other.filterStagedAtTimestampGte)
                && filterStagedAtTimestampLte.equals(other.filterStagedAtTimestampLte)
                && filterOpenedAtTimestampGte.equals(other.filterOpenedAtTimestampGte)
                && filterOpenedAtTimestampLte.equals(other.filterOpenedAtTimestampLte)
                && filterPaidAtTimestampGte.equals(other.filterPaidAtTimestampGte)
                && filterPaidAtTimestampLte.equals(other.filterPaidAtTimestampLte);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.filterStatus,
                this.sortBy,
                this.sortOrder,
                this.page,
                this.pageSize,
                this.filterSettlementType,
                this.filterPaymentOriginOrgId,
                this.filterPaymentDestinationOrgId,
                this.filterOwnedByOrgId,
                this.filterStagedAtTimestampGte,
                this.filterStagedAtTimestampLte,
                this.filterOpenedAtTimestampGte,
                this.filterOpenedAtTimestampLte,
                this.filterPaidAtTimestampGte,
                this.filterPaidAtTimestampLte);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<StatementStatusEnum1>> filterStatus = Optional.empty();

        private Optional<StatementSortByEnum> sortBy = Optional.empty();

        private Optional<SortOrderEnum> sortOrder = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        private Optional<SettlementTypeEnum1> filterSettlementType = Optional.empty();

        private Optional<String> filterPaymentOriginOrgId = Optional.empty();

        private Optional<String> filterPaymentDestinationOrgId = Optional.empty();

        private Optional<String> filterOwnedByOrgId = Optional.empty();

        private Optional<OffsetDateTime> filterStagedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterStagedAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterOpenedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterOpenedAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterPaidAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterPaidAtTimestampLte = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(StatementsListV1Request other) {
            filterStatus(other.getFilterStatus());
            sortBy(other.getSortBy());
            sortOrder(other.getSortOrder());
            page(other.getPage());
            pageSize(other.getPageSize());
            filterSettlementType(other.getFilterSettlementType());
            filterPaymentOriginOrgId(other.getFilterPaymentOriginOrgId());
            filterPaymentDestinationOrgId(other.getFilterPaymentDestinationOrgId());
            filterOwnedByOrgId(other.getFilterOwnedByOrgId());
            filterStagedAtTimestampGte(other.getFilterStagedAtTimestampGte());
            filterStagedAtTimestampLte(other.getFilterStagedAtTimestampLte());
            filterOpenedAtTimestampGte(other.getFilterOpenedAtTimestampGte());
            filterOpenedAtTimestampLte(other.getFilterOpenedAtTimestampLte());
            filterPaidAtTimestampGte(other.getFilterPaidAtTimestampGte());
            filterPaidAtTimestampLte(other.getFilterPaidAtTimestampLte());
            return this;
        }

        /**
         * <p>Filter by statement status(es)</p>
         */
        @JsonSetter(value = "filter_status", nulls = Nulls.SKIP)
        public Builder filterStatus(Optional<List<StatementStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public Builder filterStatus(List<StatementStatusEnum1> filterStatus) {
            this.filterStatus = Optional.ofNullable(filterStatus);
            return this;
        }

        public Builder filterStatus(Nullable<List<StatementStatusEnum1>> filterStatus) {
            if (filterStatus.isNull()) {
                this.filterStatus = null;
            } else if (filterStatus.isEmpty()) {
                this.filterStatus = Optional.empty();
            } else {
                this.filterStatus = Optional.of(filterStatus.get());
            }
            return this;
        }

        public Builder filterStatus(StatementStatusEnum1 filterStatus) {
            this.filterStatus = Optional.of(Collections.singletonList(filterStatus));
            return this;
        }

        /**
         * <p>Field to sort by</p>
         */
        @JsonSetter(value = "sort_by", nulls = Nulls.SKIP)
        public Builder sortBy(Optional<StatementSortByEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortBy(StatementSortByEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        public Builder sortBy(Nullable<StatementSortByEnum> sortBy) {
            if (sortBy.isNull()) {
                this.sortBy = null;
            } else if (sortBy.isEmpty()) {
                this.sortBy = Optional.empty();
            } else {
                this.sortBy = Optional.of(sortBy.get());
            }
            return this;
        }

        /**
         * <p>Sort order (ascending or descending)</p>
         */
        @JsonSetter(value = "sort_order", nulls = Nulls.SKIP)
        public Builder sortOrder(Optional<SortOrderEnum> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(SortOrderEnum sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<SortOrderEnum> sortOrder) {
            if (sortOrder.isNull()) {
                this.sortOrder = null;
            } else if (sortOrder.isEmpty()) {
                this.sortOrder = Optional.empty();
            } else {
                this.sortOrder = Optional.of(sortOrder.get());
            }
            return this;
        }

        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        public Builder page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        public Builder pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        /**
         * <p>Filter by settlement type</p>
         */
        @JsonSetter(value = "filter_settlement_type", nulls = Nulls.SKIP)
        public Builder filterSettlementType(Optional<SettlementTypeEnum1> filterSettlementType) {
            this.filterSettlementType = filterSettlementType;
            return this;
        }

        public Builder filterSettlementType(SettlementTypeEnum1 filterSettlementType) {
            this.filterSettlementType = Optional.ofNullable(filterSettlementType);
            return this;
        }

        public Builder filterSettlementType(Nullable<SettlementTypeEnum1> filterSettlementType) {
            if (filterSettlementType.isNull()) {
                this.filterSettlementType = null;
            } else if (filterSettlementType.isEmpty()) {
                this.filterSettlementType = Optional.empty();
            } else {
                this.filterSettlementType = Optional.of(filterSettlementType.get());
            }
            return this;
        }

        /**
         * <p>Filter by payment origin org ID</p>
         */
        @JsonSetter(value = "filter_payment_origin_org_id", nulls = Nulls.SKIP)
        public Builder filterPaymentOriginOrgId(Optional<String> filterPaymentOriginOrgId) {
            this.filterPaymentOriginOrgId = filterPaymentOriginOrgId;
            return this;
        }

        public Builder filterPaymentOriginOrgId(String filterPaymentOriginOrgId) {
            this.filterPaymentOriginOrgId = Optional.ofNullable(filterPaymentOriginOrgId);
            return this;
        }

        public Builder filterPaymentOriginOrgId(Nullable<String> filterPaymentOriginOrgId) {
            if (filterPaymentOriginOrgId.isNull()) {
                this.filterPaymentOriginOrgId = null;
            } else if (filterPaymentOriginOrgId.isEmpty()) {
                this.filterPaymentOriginOrgId = Optional.empty();
            } else {
                this.filterPaymentOriginOrgId = Optional.of(filterPaymentOriginOrgId.get());
            }
            return this;
        }

        /**
         * <p>Filter by payment destination org ID</p>
         */
        @JsonSetter(value = "filter_payment_destination_org_id", nulls = Nulls.SKIP)
        public Builder filterPaymentDestinationOrgId(Optional<String> filterPaymentDestinationOrgId) {
            this.filterPaymentDestinationOrgId = filterPaymentDestinationOrgId;
            return this;
        }

        public Builder filterPaymentDestinationOrgId(String filterPaymentDestinationOrgId) {
            this.filterPaymentDestinationOrgId = Optional.ofNullable(filterPaymentDestinationOrgId);
            return this;
        }

        public Builder filterPaymentDestinationOrgId(Nullable<String> filterPaymentDestinationOrgId) {
            if (filterPaymentDestinationOrgId.isNull()) {
                this.filterPaymentDestinationOrgId = null;
            } else if (filterPaymentDestinationOrgId.isEmpty()) {
                this.filterPaymentDestinationOrgId = Optional.empty();
            } else {
                this.filterPaymentDestinationOrgId = Optional.of(filterPaymentDestinationOrgId.get());
            }
            return this;
        }

        /**
         * <p>Filter by owned by org ID</p>
         */
        @JsonSetter(value = "filter_owned_by_org_id", nulls = Nulls.SKIP)
        public Builder filterOwnedByOrgId(Optional<String> filterOwnedByOrgId) {
            this.filterOwnedByOrgId = filterOwnedByOrgId;
            return this;
        }

        public Builder filterOwnedByOrgId(String filterOwnedByOrgId) {
            this.filterOwnedByOrgId = Optional.ofNullable(filterOwnedByOrgId);
            return this;
        }

        public Builder filterOwnedByOrgId(Nullable<String> filterOwnedByOrgId) {
            if (filterOwnedByOrgId.isNull()) {
                this.filterOwnedByOrgId = null;
            } else if (filterOwnedByOrgId.isEmpty()) {
                this.filterOwnedByOrgId = Optional.empty();
            } else {
                this.filterOwnedByOrgId = Optional.of(filterOwnedByOrgId.get());
            }
            return this;
        }

        /**
         * <p>Filter by staged_at_timestamp &gt;= value</p>
         */
        @JsonSetter(value = "filter_staged_at_timestamp_gte", nulls = Nulls.SKIP)
        public Builder filterStagedAtTimestampGte(Optional<OffsetDateTime> filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
            return this;
        }

        public Builder filterStagedAtTimestampGte(OffsetDateTime filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = Optional.ofNullable(filterStagedAtTimestampGte);
            return this;
        }

        public Builder filterStagedAtTimestampGte(Nullable<OffsetDateTime> filterStagedAtTimestampGte) {
            if (filterStagedAtTimestampGte.isNull()) {
                this.filterStagedAtTimestampGte = null;
            } else if (filterStagedAtTimestampGte.isEmpty()) {
                this.filterStagedAtTimestampGte = Optional.empty();
            } else {
                this.filterStagedAtTimestampGte = Optional.of(filterStagedAtTimestampGte.get());
            }
            return this;
        }

        /**
         * <p>Filter by staged_at_timestamp &lt;= value</p>
         */
        @JsonSetter(value = "filter_staged_at_timestamp_lte", nulls = Nulls.SKIP)
        public Builder filterStagedAtTimestampLte(Optional<OffsetDateTime> filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
            return this;
        }

        public Builder filterStagedAtTimestampLte(OffsetDateTime filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = Optional.ofNullable(filterStagedAtTimestampLte);
            return this;
        }

        public Builder filterStagedAtTimestampLte(Nullable<OffsetDateTime> filterStagedAtTimestampLte) {
            if (filterStagedAtTimestampLte.isNull()) {
                this.filterStagedAtTimestampLte = null;
            } else if (filterStagedAtTimestampLte.isEmpty()) {
                this.filterStagedAtTimestampLte = Optional.empty();
            } else {
                this.filterStagedAtTimestampLte = Optional.of(filterStagedAtTimestampLte.get());
            }
            return this;
        }

        /**
         * <p>Filter by opened_at_timestamp &gt;= value</p>
         */
        @JsonSetter(value = "filter_opened_at_timestamp_gte", nulls = Nulls.SKIP)
        public Builder filterOpenedAtTimestampGte(Optional<OffsetDateTime> filterOpenedAtTimestampGte) {
            this.filterOpenedAtTimestampGte = filterOpenedAtTimestampGte;
            return this;
        }

        public Builder filterOpenedAtTimestampGte(OffsetDateTime filterOpenedAtTimestampGte) {
            this.filterOpenedAtTimestampGte = Optional.ofNullable(filterOpenedAtTimestampGte);
            return this;
        }

        public Builder filterOpenedAtTimestampGte(Nullable<OffsetDateTime> filterOpenedAtTimestampGte) {
            if (filterOpenedAtTimestampGte.isNull()) {
                this.filterOpenedAtTimestampGte = null;
            } else if (filterOpenedAtTimestampGte.isEmpty()) {
                this.filterOpenedAtTimestampGte = Optional.empty();
            } else {
                this.filterOpenedAtTimestampGte = Optional.of(filterOpenedAtTimestampGte.get());
            }
            return this;
        }

        /**
         * <p>Filter by opened_at_timestamp &lt;= value</p>
         */
        @JsonSetter(value = "filter_opened_at_timestamp_lte", nulls = Nulls.SKIP)
        public Builder filterOpenedAtTimestampLte(Optional<OffsetDateTime> filterOpenedAtTimestampLte) {
            this.filterOpenedAtTimestampLte = filterOpenedAtTimestampLte;
            return this;
        }

        public Builder filterOpenedAtTimestampLte(OffsetDateTime filterOpenedAtTimestampLte) {
            this.filterOpenedAtTimestampLte = Optional.ofNullable(filterOpenedAtTimestampLte);
            return this;
        }

        public Builder filterOpenedAtTimestampLte(Nullable<OffsetDateTime> filterOpenedAtTimestampLte) {
            if (filterOpenedAtTimestampLte.isNull()) {
                this.filterOpenedAtTimestampLte = null;
            } else if (filterOpenedAtTimestampLte.isEmpty()) {
                this.filterOpenedAtTimestampLte = Optional.empty();
            } else {
                this.filterOpenedAtTimestampLte = Optional.of(filterOpenedAtTimestampLte.get());
            }
            return this;
        }

        /**
         * <p>Filter by paid_at_timestamp &gt;= value</p>
         */
        @JsonSetter(value = "filter_paid_at_timestamp_gte", nulls = Nulls.SKIP)
        public Builder filterPaidAtTimestampGte(Optional<OffsetDateTime> filterPaidAtTimestampGte) {
            this.filterPaidAtTimestampGte = filterPaidAtTimestampGte;
            return this;
        }

        public Builder filterPaidAtTimestampGte(OffsetDateTime filterPaidAtTimestampGte) {
            this.filterPaidAtTimestampGte = Optional.ofNullable(filterPaidAtTimestampGte);
            return this;
        }

        public Builder filterPaidAtTimestampGte(Nullable<OffsetDateTime> filterPaidAtTimestampGte) {
            if (filterPaidAtTimestampGte.isNull()) {
                this.filterPaidAtTimestampGte = null;
            } else if (filterPaidAtTimestampGte.isEmpty()) {
                this.filterPaidAtTimestampGte = Optional.empty();
            } else {
                this.filterPaidAtTimestampGte = Optional.of(filterPaidAtTimestampGte.get());
            }
            return this;
        }

        /**
         * <p>Filter by paid_at_timestamp &lt;= value</p>
         */
        @JsonSetter(value = "filter_paid_at_timestamp_lte", nulls = Nulls.SKIP)
        public Builder filterPaidAtTimestampLte(Optional<OffsetDateTime> filterPaidAtTimestampLte) {
            this.filterPaidAtTimestampLte = filterPaidAtTimestampLte;
            return this;
        }

        public Builder filterPaidAtTimestampLte(OffsetDateTime filterPaidAtTimestampLte) {
            this.filterPaidAtTimestampLte = Optional.ofNullable(filterPaidAtTimestampLte);
            return this;
        }

        public Builder filterPaidAtTimestampLte(Nullable<OffsetDateTime> filterPaidAtTimestampLte) {
            if (filterPaidAtTimestampLte.isNull()) {
                this.filterPaidAtTimestampLte = null;
            } else if (filterPaidAtTimestampLte.isEmpty()) {
                this.filterPaidAtTimestampLte = Optional.empty();
            } else {
                this.filterPaidAtTimestampLte = Optional.of(filterPaidAtTimestampLte.get());
            }
            return this;
        }

        public StatementsListV1Request build() {
            return new StatementsListV1Request(
                    filterStatus,
                    sortBy,
                    sortOrder,
                    page,
                    pageSize,
                    filterSettlementType,
                    filterPaymentOriginOrgId,
                    filterPaymentDestinationOrgId,
                    filterOwnedByOrgId,
                    filterStagedAtTimestampGte,
                    filterStagedAtTimestampLte,
                    filterOpenedAtTimestampGte,
                    filterOpenedAtTimestampLte,
                    filterPaidAtTimestampGte,
                    filterPaidAtTimestampLte,
                    additionalProperties);
        }
    }
}
