/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.stripeconnect;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CreateStripeConnectAccountRes;
import com.chrt.api.types.StripeConnectAccountOnboardingLinkRes;
import java.util.concurrent.CompletableFuture;

public class AsyncStripeConnectClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawStripeConnectClient rawClient;

    public AsyncStripeConnectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawStripeConnectClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawStripeConnectClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created. | () -&gt; (CreateStripeConnectAccountRes)
     */
    public CompletableFuture<CreateStripeConnectAccountRes> createAccountV1() {
        return this.rawClient.createAccountV1().thenApply(response -> response.body());
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created. | () -&gt; (CreateStripeConnectAccountRes)
     */
    public CompletableFuture<CreateStripeConnectAccountRes> createAccountV1(RequestOptions requestOptions) {
        return this.rawClient.createAccountV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup. | () -&gt; (StripeConnectAccountOnboardingLinkRes)
     */
    public CompletableFuture<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1() {
        return this.rawClient.onboardingLinkV1().thenApply(response -> response.body());
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup. | () -&gt; (StripeConnectAccountOnboardingLinkRes)
     */
    public CompletableFuture<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1(RequestOptions requestOptions) {
        return this.rawClient.onboardingLinkV1(requestOptions).thenApply(response -> response.body());
    }
}
