/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.stripeconnect;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CreateStripeConnectAccountRes;
import com.chrt.api.types.StripeConnectAccountOnboardingLinkRes;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawStripeConnectClient {
    protected final ClientOptions clientOptions;

    public RawStripeConnectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created. | () -&gt; (CreateStripeConnectAccountRes)
     */
    public ChrtApiHttpResponse<CreateStripeConnectAccountRes> createAccountV1() {
        return createAccountV1(null);
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created. | () -&gt; (CreateStripeConnectAccountRes)
     */
    public ChrtApiHttpResponse<CreateStripeConnectAccountRes> createAccountV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("billing/stripe_connect/create_account/v1")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CreateStripeConnectAccountRes.class),
                        response);
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup. | () -&gt; (StripeConnectAccountOnboardingLinkRes)
     */
    public ChrtApiHttpResponse<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1() {
        return onboardingLinkV1(null);
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup. | () -&gt; (StripeConnectAccountOnboardingLinkRes)
     */
    public ChrtApiHttpResponse<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("billing/stripe_connect/account_onboarding_link/v1")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, StripeConnectAccountOnboardingLinkRes.class),
                        response);
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
