/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.billing.stripeconnect;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CreateStripeConnectAccountRes;
import com.chrt.api.types.StripeConnectAccountOnboardingLinkRes;

public class StripeConnectClient {
    protected final ClientOptions clientOptions;

    private final RawStripeConnectClient rawClient;

    public StripeConnectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawStripeConnectClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawStripeConnectClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created. | () -&gt; (CreateStripeConnectAccountRes)
     */
    public CreateStripeConnectAccountRes createAccountV1() {
        return this.rawClient.createAccountV1().body();
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created. | () -&gt; (CreateStripeConnectAccountRes)
     */
    public CreateStripeConnectAccountRes createAccountV1(RequestOptions requestOptions) {
        return this.rawClient.createAccountV1(requestOptions).body();
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup. | () -&gt; (StripeConnectAccountOnboardingLinkRes)
     */
    public StripeConnectAccountOnboardingLinkRes onboardingLinkV1() {
        return this.rawClient.onboardingLinkV1().body();
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup. | () -&gt; (StripeConnectAccountOnboardingLinkRes)
     */
    public StripeConnectAccountOnboardingLinkRes onboardingLinkV1(RequestOptions requestOptions) {
        return this.rawClient.onboardingLinkV1(requestOptions).body();
    }
}
