/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.connections.connectiontoforwarder;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CreateConnectionReq;
import java.util.concurrent.CompletableFuture;

public class AsyncConnectionToForwarderClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawConnectionToForwarderClient rawClient;

    public AsyncConnectionToForwarderClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawConnectionToForwarderClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawConnectionToForwarderClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a new connection to a forwarder organization. Only shippers can initiate connections to forwarders. | (CreateConnectionReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(CreateConnectionReq request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new connection to a forwarder organization. Only shippers can initiate connections to forwarders. | (CreateConnectionReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(CreateConnectionReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }
}
