/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.drivers.requests.DriverClientCreate1;
import com.chrt.api.resources.drivers.requests.DriverClientUpdate1;
import com.chrt.api.resources.drivers.requests.DriversListOrgMembersAndDriversV1Request;
import com.chrt.api.resources.drivers.requests.DriversListV1Request;
import com.chrt.api.types.Driver1;
import com.chrt.api.types.DriverUpdateAvailabilityReq;
import com.chrt.api.types.OrgMembersAndDrivers;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncDriversClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDriversClient rawClient;

    public AsyncDriversClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDriversClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDriversClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves driver information for the caller within their organization. | () -&gt; (Driver1)
     */
    public CompletableFuture<Driver1> getForCallerV1() {
        return this.rawClient.getForCallerV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves driver information for the caller within their organization. | () -&gt; (Driver1)
     */
    public CompletableFuture<Driver1> getForCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getForCallerV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves detailed driver information by driver ID within the organization. | () -&gt; (Driver1)
     */
    public CompletableFuture<Driver1> getByDriverIdV1(String driverId) {
        return this.rawClient.getByDriverIdV1(driverId).thenApply(response -> response.body());
    }

    /**
     * Retrieves detailed driver information by driver ID within the organization. | () -&gt; (Driver1)
     */
    public CompletableFuture<Driver1> getByDriverIdV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.getByDriverIdV1(driverId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers. Filter by availability. | () -&gt; (list[OrgMembersAndDrivers])
     */
    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1() {
        return this.rawClient.listOrgMembersAndDriversV1().thenApply(response -> response.body());
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers. Filter by availability. | () -&gt; (list[OrgMembersAndDrivers])
     */
    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1(
            DriversListOrgMembersAndDriversV1Request request) {
        return this.rawClient.listOrgMembersAndDriversV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers. Filter by availability. | () -&gt; (list[OrgMembersAndDrivers])
     */
    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1(
            DriversListOrgMembersAndDriversV1Request request, RequestOptions requestOptions) {
        return this.rawClient
                .listOrgMembersAndDriversV1(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists all drivers belonging to the caller's organization. Filter by availability. | () -&gt; (list[Driver1])
     */
    public CompletableFuture<List<Driver1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Lists all drivers belonging to the caller's organization. Filter by availability. | () -&gt; (list[Driver1])
     */
    public CompletableFuture<List<Driver1>> listV1(DriversListV1Request request) {
        return this.rawClient.listV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists all drivers belonging to the caller's organization. Filter by availability. | () -&gt; (list[Driver1])
     */
    public CompletableFuture<List<Driver1>> listV1(DriversListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver profile for the target user (defaults to caller). Drivers can create themselves; operators+ can create any org member. Courier orgs only. | (DriverClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(DriverClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver profile for the target user (defaults to caller). Drivers can create themselves; operators+ can create any org member. Courier orgs only. | (DriverClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(DriverClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates driver contact details and vehicle type assignments. Courier orgs only; caller must be the driver (self) or an operator+. | (DriverClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(String driverId) {
        return this.rawClient.updateV1(driverId).thenApply(response -> response.body());
    }

    /**
     * Updates driver contact details and vehicle type assignments. Courier orgs only; caller must be the driver (self) or an operator+. | (DriverClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(String driverId, DriverClientUpdate1 request) {
        return this.rawClient.updateV1(driverId, request).thenApply(response -> response.body());
    }

    /**
     * Updates driver contact details and vehicle type assignments. Courier orgs only; caller must be the driver (self) or an operator+. | (DriverClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(
            String driverId, DriverClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(driverId, request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Clears the driver's last known location and timestamp. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> clearLastSeenV1() {
        return this.rawClient.clearLastSeenV1().thenApply(response -> response.body());
    }

    /**
     * Clears the driver's last known location and timestamp. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> clearLastSeenV1(RequestOptions requestOptions) {
        return this.rawClient.clearLastSeenV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the caller's driver availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request) {
        return this.rawClient.updateAvailabilityAccordingToDriverV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the caller's driver availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateAvailabilityAccordingToDriverV1(
            DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateAvailabilityAccordingToDriverV1(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Updates a driver's availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only, min role: operator. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateAvailabilityAccordingToOperatorsV1(
            String driverId, DriverUpdateAvailabilityReq request) {
        return this.rawClient
                .updateAvailabilityAccordingToOperatorsV1(driverId, request)
                .thenApply(response -> response.body());
    }

    /**
     * Updates a driver's availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only, min role: operator. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateAvailabilityAccordingToOperatorsV1(
            String driverId, DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateAvailabilityAccordingToOperatorsV1(driverId, request, requestOptions)
                .thenApply(response -> response.body());
    }
}
