/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.flights;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.FlightInfoForTaskRes;

public class FlightsClient {
    protected final ClientOptions clientOptions;

    private final RawFlightsClient rawClient;

    public FlightsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawFlightsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawFlightsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns flight info from an adjacent FLIGHT task group for TENDER_TO_AIRLINE or RECOVER_FROM_AIRLINE tasks. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators, shipper_org_operators] | () -&gt; (FlightInfoForTaskRes)
     */
    public FlightInfoForTaskRes getFlightInfoForTaskV1(String taskId) {
        return this.rawClient.getFlightInfoForTaskV1(taskId).body();
    }

    /**
     * Returns flight info from an adjacent FLIGHT task group for TENDER_TO_AIRLINE or RECOVER_FROM_AIRLINE tasks. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators, shipper_org_operators] | () -&gt; (FlightInfoForTaskRes)
     */
    public FlightInfoForTaskRes getFlightInfoForTaskV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.getFlightInfoForTaskV1(taskId, requestOptions).body();
    }
}
