/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.notifications.courier;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.notifications.courier.requests.CourierNotificationPreferencesClientCreate1;
import com.chrt.api.types.CourierNotificationPreferences1;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCourierClient rawClient;

    public AsyncCourierClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCourierClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves notification preferences for the caller's courier organization. | () -&gt; (CourierNotificationPreferences1)
     */
    public CompletableFuture<CourierNotificationPreferences1> getPreferencesV1() {
        return this.rawClient.getPreferencesV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves notification preferences for the caller's courier organization. | () -&gt; (CourierNotificationPreferences1)
     */
    public CompletableFuture<CourierNotificationPreferences1> getPreferencesV1(RequestOptions requestOptions) {
        return this.rawClient.getPreferencesV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates or updates notification preferences for the caller's courier organization. | (CourierNotificationPreferencesClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> upsertPreferencesV1(CourierNotificationPreferencesClientCreate1 request) {
        return this.rawClient.upsertPreferencesV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates or updates notification preferences for the caller's courier organization. | (CourierNotificationPreferencesClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> upsertPreferencesV1(
            CourierNotificationPreferencesClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.upsertPreferencesV1(request, requestOptions).thenApply(response -> response.body());
    }
}
