/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.expanded.requests.ExpandedListV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderDraftExpanded;
import com.chrt.api.types.OrderDraftExpandedListRes;
import java.util.concurrent.CompletableFuture;

public class AsyncExpandedClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawExpandedClient rawClient;

    public AsyncExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawExpandedClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public CompletableFuture<OrderDraftExpanded> retrieveV1(String orderIdOrShortId) {
        return this.rawClient.retrieveV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public CompletableFuture<OrderDraftExpanded> retrieveV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.retrieveV1(orderIdOrShortId, request).thenApply(response -> response.body());
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public CompletableFuture<OrderDraftExpanded> retrieveV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .retrieveV1(orderIdOrShortId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists expanded draft orders for the organization with filtering, sorting, and pagination. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpandedListRes)
     */
    public CompletableFuture<OrderDraftExpandedListRes> listV1(ExpandedListV1Request request) {
        return this.rawClient.listV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists expanded draft orders for the organization with filtering, sorting, and pagination. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpandedListRes)
     */
    public CompletableFuture<OrderDraftExpandedListRes> listV1(
            ExpandedListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).thenApply(response -> response.body());
    }
}
