/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.expanded.requests.ExpandedListV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderDraftExpanded;
import com.chrt.api.types.OrderDraftExpandedListRes;

public class ExpandedClient {
    protected final ClientOptions clientOptions;

    private final RawExpandedClient rawClient;

    public ExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawExpandedClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public OrderDraftExpanded retrieveV1(String orderIdOrShortId) {
        return this.rawClient.retrieveV1(orderIdOrShortId).body();
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public OrderDraftExpanded retrieveV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.retrieveV1(orderIdOrShortId, request).body();
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public OrderDraftExpanded retrieveV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .retrieveV1(orderIdOrShortId, request, requestOptions)
                .body();
    }

    /**
     * Lists expanded draft orders for the organization with filtering, sorting, and pagination. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpandedListRes)
     */
    public OrderDraftExpandedListRes listV1(ExpandedListV1Request request) {
        return this.rawClient.listV1(request).body();
    }

    /**
     * Lists expanded draft orders for the organization with filtering, sorting, and pagination. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpandedListRes)
     */
    public OrderDraftExpandedListRes listV1(ExpandedListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).body();
    }
}
