/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.expanded;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.orderdrafts.expanded.requests.ExpandedListV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderDraftExpanded;
import com.chrt.api.types.OrderDraftExpandedListRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawExpandedClient {
    protected final ClientOptions clientOptions;

    public RawExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public ChrtApiHttpResponse<OrderDraftExpanded> retrieveV1(String orderIdOrShortId) {
        return retrieveV1(
                orderIdOrShortId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public ChrtApiHttpResponse<OrderDraftExpanded> retrieveV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return retrieveV1(orderIdOrShortId, request, null);
    }

    /**
     * Fetches a single draft order with optional expanded related data. Any user in the org (with operator+ role) can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public ChrtApiHttpResponse<OrderDraftExpanded> retrieveV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/order_drafts/expanded/retrieve/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderDraftExpanded.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Lists expanded draft orders for the organization with filtering, sorting, and pagination. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpandedListRes)
     */
    public ChrtApiHttpResponse<OrderDraftExpandedListRes> listV1(ExpandedListV1Request request) {
        return listV1(request, null);
    }

    /**
     * Lists expanded draft orders for the organization with filtering, sorting, and pagination. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpandedListRes)
     */
    public ChrtApiHttpResponse<OrderDraftExpandedListRes> listV1(
            ExpandedListV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/order_drafts/expanded/list/v1");
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_timestamp_lte",
                    request.getFilterDraftStartedAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterDraftStartedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_timestamp_gte",
                    request.getFilterDraftStartedAtTimestampGte().get(),
                    false);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderDraftExpandedListRes.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
