/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.task;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.task.requests.OrderDraftAddTaskReqV1;
import com.chrt.api.resources.orderdrafts.task.requests.OrderDraftUpdateTaskReq;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskClient rawClient;

    public AsyncTaskClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a task to an existing task group in a draft order. Validates task action type matches task group type. | authz_personas=[draft_creator_org_operator] | (OrderDraftAddTaskReqV1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskReqV1 request) {
        return this.rawClient.addV1(request).thenApply(response -> response.body());
    }

    /**
     * Adds a task to an existing task group in a draft order. Validates task action type matches task group type. | authz_personas=[draft_creator_org_operator] | (OrderDraftAddTaskReqV1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskReqV1 request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates a task in an existing draft order. | authz_personas=[draft_creator_org_operator] | (OrderDraftUpdateTaskReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> updateV1(OrderDraftUpdateTaskReq request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates a task in an existing draft order. | authz_personas=[draft_creator_org_operator] | (OrderDraftUpdateTaskReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> updateV1(OrderDraftUpdateTaskReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a task from a draft order, including all task artifacts. Cargo is preserved. Task is removed from task group. | authz_personas=[draft_creator_org_operator] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskId) {
        return this.rawClient.deleteV1(taskId).thenApply(response -> response.body());
    }

    /**
     * Deletes a task from a draft order, including all task artifacts. Cargo is preserved. Task is removed from task group. | authz_personas=[draft_creator_org_operator] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskId, requestOptions).thenApply(response -> response.body());
    }
}
