/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.taskgroup;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.OrderDraftAddTaskGroupReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetRateSheetsReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetServiceTypeReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetTaskOrderingDraftReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.UpdateCourierOrgDraftReq;
import com.chrt.api.types.SetFlightInfoReq;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskGroupClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskGroupClient rawClient;

    public AsyncTaskGroupClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskGroupClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller. | (OrderDraftAddTaskGroupReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskGroupReq request) {
        return this.rawClient.addV1(request).thenApply(response -> response.body());
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller. | (OrderDraftAddTaskGroupReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a draft task group. | (SetFlightInfoReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setFlightInfoV1(String taskGroupId) {
        return this.rawClient.setFlightInfoV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a draft task group. | (SetFlightInfoReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setFlightInfoV1(String taskGroupId, SetFlightInfoReq request) {
        return this.rawClient.setFlightInfoV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a draft task group. | (SetFlightInfoReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setFlightInfoV1(
            String taskGroupId, SetFlightInfoReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setFlightInfoV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Updates the courier organization assigned to a draft task group. | (UpdateCourierOrgDraftReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgDraftReq request) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Updates the courier organization assigned to a draft task group. | (UpdateCourierOrgDraftReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateCourierOrgV1(
            String taskGroupId, UpdateCourierOrgDraftReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateCourierOrgV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Removes the courier organization from a draft task group (sets courier_org_id to null). | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> removeCourierOrgV1(String taskGroupId) {
        return this.rawClient.removeCourierOrgV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Removes the courier organization from a draft task group (sets courier_org_id to null). | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> removeCourierOrgV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.removeCourierOrgV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Sets the ordering of tasks within a draft task group. Must provide all task IDs with no duplicates. | (SetTaskOrderingDraftReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setTaskOrderingV1(String taskGroupId, SetTaskOrderingDraftReq request) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Sets the ordering of tasks within a draft task group. Must provide all task IDs with no duplicates. | (SetTaskOrderingDraftReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setTaskOrderingV1(
            String taskGroupId, SetTaskOrderingDraftReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setTaskOrderingV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Sets rate sheet IDs on a draft task group. Forwarder mode (SPF/FPC) and direct shipper mode (SPC) are mutually exclusive. CPD is independent. | (SetRateSheetsReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setRateSheetsV1(String taskGroupId) {
        return this.rawClient.setRateSheetsV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Sets rate sheet IDs on a draft task group. Forwarder mode (SPF/FPC) and direct shipper mode (SPC) are mutually exclusive. CPD is independent. | (SetRateSheetsReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setRateSheetsV1(String taskGroupId, SetRateSheetsReq request) {
        return this.rawClient.setRateSheetsV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Sets rate sheet IDs on a draft task group. Forwarder mode (SPF/FPC) and direct shipper mode (SPC) are mutually exclusive. CPD is independent. | (SetRateSheetsReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setRateSheetsV1(
            String taskGroupId, SetRateSheetsReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setRateSheetsV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Sets the service type on a draft task group. Can only be set when task group is in DRAFT status. | (SetServiceTypeReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setServiceTypeV1(String taskGroupId, SetServiceTypeReq request) {
        return this.rawClient.setServiceTypeV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Sets the service type on a draft task group. Can only be set when task group is in DRAFT status. | (SetServiceTypeReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setServiceTypeV1(
            String taskGroupId, SetServiceTypeReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setServiceTypeV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskGroupId) {
        return this.rawClient.deleteV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }
}
