/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.taskgroup;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.OrderDraftAddTaskGroupReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetRateSheetsReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetServiceTypeReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetTaskOrderingDraftReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.UpdateCourierOrgDraftReq;
import com.chrt.api.types.SetFlightInfoReq;

public class TaskGroupClient {
    protected final ClientOptions clientOptions;

    private final RawTaskGroupClient rawClient;

    public TaskGroupClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskGroupClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTaskGroupClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller. | (OrderDraftAddTaskGroupReq) -&gt; (PydanticObjectId)
     */
    public String addV1(OrderDraftAddTaskGroupReq request) {
        return this.rawClient.addV1(request).body();
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller. | (OrderDraftAddTaskGroupReq) -&gt; (PydanticObjectId)
     */
    public String addV1(OrderDraftAddTaskGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).body();
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a draft task group. | (SetFlightInfoReq) -&gt; (bool)
     */
    public boolean setFlightInfoV1(String taskGroupId) {
        return this.rawClient.setFlightInfoV1(taskGroupId).body();
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a draft task group. | (SetFlightInfoReq) -&gt; (bool)
     */
    public boolean setFlightInfoV1(String taskGroupId, SetFlightInfoReq request) {
        return this.rawClient.setFlightInfoV1(taskGroupId, request).body();
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a draft task group. | (SetFlightInfoReq) -&gt; (bool)
     */
    public boolean setFlightInfoV1(String taskGroupId, SetFlightInfoReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setFlightInfoV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Updates the courier organization assigned to a draft task group. | (UpdateCourierOrgDraftReq) -&gt; (bool)
     */
    public boolean updateCourierOrgV1(String taskGroupId, UpdateCourierOrgDraftReq request) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request).body();
    }

    /**
     * Updates the courier organization assigned to a draft task group. | (UpdateCourierOrgDraftReq) -&gt; (bool)
     */
    public boolean updateCourierOrgV1(
            String taskGroupId, UpdateCourierOrgDraftReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateCourierOrgV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Removes the courier organization from a draft task group (sets courier_org_id to null). | () -&gt; (bool)
     */
    public boolean removeCourierOrgV1(String taskGroupId) {
        return this.rawClient.removeCourierOrgV1(taskGroupId).body();
    }

    /**
     * Removes the courier organization from a draft task group (sets courier_org_id to null). | () -&gt; (bool)
     */
    public boolean removeCourierOrgV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.removeCourierOrgV1(taskGroupId, requestOptions).body();
    }

    /**
     * Sets the ordering of tasks within a draft task group. Must provide all task IDs with no duplicates. | (SetTaskOrderingDraftReq) -&gt; (bool)
     */
    public boolean setTaskOrderingV1(String taskGroupId, SetTaskOrderingDraftReq request) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request).body();
    }

    /**
     * Sets the ordering of tasks within a draft task group. Must provide all task IDs with no duplicates. | (SetTaskOrderingDraftReq) -&gt; (bool)
     */
    public boolean setTaskOrderingV1(
            String taskGroupId, SetTaskOrderingDraftReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setTaskOrderingV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Sets rate sheet IDs on a draft task group. Forwarder mode (SPF/FPC) and direct shipper mode (SPC) are mutually exclusive. CPD is independent. | (SetRateSheetsReq) -&gt; (bool)
     */
    public boolean setRateSheetsV1(String taskGroupId) {
        return this.rawClient.setRateSheetsV1(taskGroupId).body();
    }

    /**
     * Sets rate sheet IDs on a draft task group. Forwarder mode (SPF/FPC) and direct shipper mode (SPC) are mutually exclusive. CPD is independent. | (SetRateSheetsReq) -&gt; (bool)
     */
    public boolean setRateSheetsV1(String taskGroupId, SetRateSheetsReq request) {
        return this.rawClient.setRateSheetsV1(taskGroupId, request).body();
    }

    /**
     * Sets rate sheet IDs on a draft task group. Forwarder mode (SPF/FPC) and direct shipper mode (SPC) are mutually exclusive. CPD is independent. | (SetRateSheetsReq) -&gt; (bool)
     */
    public boolean setRateSheetsV1(String taskGroupId, SetRateSheetsReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setRateSheetsV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Sets the service type on a draft task group. Can only be set when task group is in DRAFT status. | (SetServiceTypeReq) -&gt; (bool)
     */
    public boolean setServiceTypeV1(String taskGroupId, SetServiceTypeReq request) {
        return this.rawClient.setServiceTypeV1(taskGroupId, request).body();
    }

    /**
     * Sets the service type on a draft task group. Can only be set when task group is in DRAFT status. | (SetServiceTypeReq) -&gt; (bool)
     */
    public boolean setServiceTypeV1(String taskGroupId, SetServiceTypeReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setServiceTypeV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskGroupId) {
        return this.rawClient.deleteV1(taskGroupId).body();
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskGroupId, requestOptions).body();
    }
}
