/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.taskgroup.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ServiceTypeEnum1;
import com.chrt.api.types.TaskGroupTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderDraftAddTaskGroupReq.Builder.class)
public final class OrderDraftAddTaskGroupReq {
    private final TaskGroupTypeEnum1 taskGroupType;

    private final String orderId;

    private final Optional<String> courierOrgId;

    private final Optional<ServiceTypeEnum1> serviceType;

    private final Map<String, Object> additionalProperties;

    private OrderDraftAddTaskGroupReq(
            TaskGroupTypeEnum1 taskGroupType,
            String orderId,
            Optional<String> courierOrgId,
            Optional<ServiceTypeEnum1> serviceType,
            Map<String, Object> additionalProperties) {
        this.taskGroupType = taskGroupType;
        this.orderId = orderId;
        this.courierOrgId = courierOrgId;
        this.serviceType = serviceType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_group_type")
    public TaskGroupTypeEnum1 getTaskGroupType() {
        return taskGroupType;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getCourierOrgId() {
        if (courierOrgId == null) {
            return Optional.empty();
        }
        return courierOrgId;
    }

    @JsonIgnore
    public Optional<ServiceTypeEnum1> getServiceType() {
        if (serviceType == null) {
            return Optional.empty();
        }
        return serviceType;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_org_id")
    private Optional<String> _getCourierOrgId() {
        return courierOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("service_type")
    private Optional<ServiceTypeEnum1> _getServiceType() {
        return serviceType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderDraftAddTaskGroupReq && equalTo((OrderDraftAddTaskGroupReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAddTaskGroupReq other) {
        return taskGroupType.equals(other.taskGroupType)
                && orderId.equals(other.orderId)
                && courierOrgId.equals(other.courierOrgId)
                && serviceType.equals(other.serviceType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskGroupType, this.orderId, this.courierOrgId, this.serviceType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupTypeStage builder() {
        return new Builder();
    }

    public interface TaskGroupTypeStage {
        OrderIdStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType);

        Builder from(OrderDraftAddTaskGroupReq other);
    }

    public interface OrderIdStage {
        _FinalStage orderId(@NotNull String orderId);
    }

    public interface _FinalStage {
        OrderDraftAddTaskGroupReq build();

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage courierOrgId(Optional<String> courierOrgId);

        _FinalStage courierOrgId(String courierOrgId);

        _FinalStage courierOrgId(Nullable<String> courierOrgId);

        _FinalStage serviceType(Optional<ServiceTypeEnum1> serviceType);

        _FinalStage serviceType(ServiceTypeEnum1 serviceType);

        _FinalStage serviceType(Nullable<ServiceTypeEnum1> serviceType);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskGroupTypeStage, OrderIdStage, _FinalStage {
        private TaskGroupTypeEnum1 taskGroupType;

        private String orderId;

        private Optional<ServiceTypeEnum1> serviceType = Optional.empty();

        private Optional<String> courierOrgId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderDraftAddTaskGroupReq other) {
            taskGroupType(other.getTaskGroupType());
            orderId(other.getOrderId());
            courierOrgId(other.getCourierOrgId());
            serviceType(other.getServiceType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_type")
        public OrderIdStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType) {
            this.taskGroupType = Objects.requireNonNull(taskGroupType, "taskGroupType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public _FinalStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage serviceType(Nullable<ServiceTypeEnum1> serviceType) {
            if (serviceType.isNull()) {
                this.serviceType = null;
            } else if (serviceType.isEmpty()) {
                this.serviceType = Optional.empty();
            } else {
                this.serviceType = Optional.of(serviceType.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage serviceType(ServiceTypeEnum1 serviceType) {
            this.serviceType = Optional.ofNullable(serviceType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "service_type", nulls = Nulls.SKIP)
        public _FinalStage serviceType(Optional<ServiceTypeEnum1> serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage courierOrgId(Nullable<String> courierOrgId) {
            if (courierOrgId.isNull()) {
                this.courierOrgId = null;
            } else if (courierOrgId.isEmpty()) {
                this.courierOrgId = Optional.empty();
            } else {
                this.courierOrgId = Optional.of(courierOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage courierOrgId(String courierOrgId) {
            this.courierOrgId = Optional.ofNullable(courierOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "courier_org_id", nulls = Nulls.SKIP)
        public _FinalStage courierOrgId(Optional<String> courierOrgId) {
            this.courierOrgId = courierOrgId;
            return this;
        }

        @java.lang.Override
        public OrderDraftAddTaskGroupReq build() {
            return new OrderDraftAddTaskGroupReq(
                    taskGroupType, orderId, courierOrgId, serviceType, additionalProperties);
        }
    }
}
