/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.taskgroup.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ServiceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SetServiceTypeReq.Builder.class)
public final class SetServiceTypeReq {
    private final ServiceTypeEnum1 serviceType;

    private final Map<String, Object> additionalProperties;

    private SetServiceTypeReq(ServiceTypeEnum1 serviceType, Map<String, Object> additionalProperties) {
        this.serviceType = serviceType;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The service type for this task group (routed or on_demand)
     */
    @JsonProperty("service_type")
    public ServiceTypeEnum1 getServiceType() {
        return serviceType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SetServiceTypeReq && equalTo((SetServiceTypeReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SetServiceTypeReq other) {
        return serviceType.equals(other.serviceType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.serviceType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ServiceTypeStage builder() {
        return new Builder();
    }

    public interface ServiceTypeStage {
        /**
         * <p>The service type for this task group (routed or on_demand)</p>
         */
        _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType);

        Builder from(SetServiceTypeReq other);
    }

    public interface _FinalStage {
        SetServiceTypeReq build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ServiceTypeStage, _FinalStage {
        private ServiceTypeEnum1 serviceType;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SetServiceTypeReq other) {
            serviceType(other.getServiceType());
            return this;
        }

        /**
         * <p>The service type for this task group (routed or on_demand)</p>
         * <p>The service type for this task group (routed or on_demand)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("service_type")
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType must not be null");
            return this;
        }

        @java.lang.Override
        public SetServiceTypeReq build() {
            return new SetServiceTypeReq(serviceType, additionalProperties);
        }
    }
}
