/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orders.expanded.ExpandedClient;
import java.util.function.Supplier;

public class OrdersClient {
    protected final ClientOptions clientOptions;

    private final RawOrdersClient rawClient;

    protected final Supplier<ExpandedClient> expandedClient;

    public OrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrdersClient(clientOptions);
        this.expandedClient = Suppliers.memoize(() -> new ExpandedClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawOrdersClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Validates a draft order and stages all related entities in a transaction. | () -&gt; (bool)
     */
    public boolean stageV1(String orderId) {
        return this.rawClient.stageV1(orderId).body();
    }

    /**
     * Validates a draft order and stages all related entities in a transaction. | () -&gt; (bool)
     */
    public boolean stageV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.stageV1(orderId, requestOptions).body();
    }

    /**
     * Cancels an order and all related task groups and tasks in a transaction. | authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public boolean cancelV1(String orderId) {
        return this.rawClient.cancelV1(orderId).body();
    }

    /**
     * Cancels an order and all related task groups and tasks in a transaction. | authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public boolean cancelV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.cancelV1(orderId, requestOptions).body();
    }

    public ExpandedClient expanded() {
        return this.expandedClient.get();
    }
}
