/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForForwarderOperatorsV1Request;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForShipperOperatorsV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderExpanded;
import com.chrt.api.types.OrdersExpandedListRes;
import java.util.concurrent.CompletableFuture;

public class AsyncExpandedClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawExpandedClient rawClient;

    public AsyncExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawExpandedClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves an expanded order with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<OrderExpanded> forShipperOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Retrieves an expanded order with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<OrderExpanded> forShipperOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId, request).thenApply(response -> response.body());
    }

    /**
     * Retrieves an expanded order with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<OrderExpanded> forShipperOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forShipperOperatorsV1(orderIdOrShortId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Retrieves an expanded order with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<OrderExpanded> forForwarderOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Retrieves an expanded order with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<OrderExpanded> forForwarderOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId, request).thenApply(response -> response.body());
    }

    /**
     * Retrieves an expanded order with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<OrderExpanded> forForwarderOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forForwarderOperatorsV1(orderIdOrShortId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists expanded orders for forwarder operators with filtering, sorting, and pagination. | authz: allowed_org_types=[forwarder], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<OrdersExpandedListRes> listForForwarderOperatorsV1(
            ExpandedListForForwarderOperatorsV1Request request) {
        return this.rawClient.listForForwarderOperatorsV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists expanded orders for forwarder operators with filtering, sorting, and pagination. | authz: allowed_org_types=[forwarder], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<OrdersExpandedListRes> listForForwarderOperatorsV1(
            ExpandedListForForwarderOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient
                .listForForwarderOperatorsV1(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists expanded orders for shipper operators with filtering, sorting, and pagination. | authz: allowed_org_types=[shipper], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<OrdersExpandedListRes> listForShipperOperatorsV1(
            ExpandedListForShipperOperatorsV1Request request) {
        return this.rawClient.listForShipperOperatorsV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists expanded orders for shipper operators with filtering, sorting, and pagination. | authz: allowed_org_types=[shipper], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<OrdersExpandedListRes> listForShipperOperatorsV1(
            ExpandedListForShipperOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForShipperOperatorsV1(request, requestOptions).thenApply(response -> response.body());
    }
}
