/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expanded.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.resources.orders.expanded.types.ExpandedListForForwarderOperatorsV1RequestSortOrder;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderSortByEnum;
import com.chrt.api.types.OrderStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ExpandedListForForwarderOperatorsV1Request.Builder.class)
public final class ExpandedListForForwarderOperatorsV1Request {
    private final Optional<List<OrderStatusEnum1>> filterStatus;

    private final Optional<OrderSortByEnum> sortBy;

    private final Optional<ExpandedListForForwarderOperatorsV1RequestSortOrder> sortOrder;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampLte;

    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampGte;

    private final Optional<OffsetDateTime> filterStagedAtTimestampLte;

    private final Optional<OffsetDateTime> filterStagedAtTimestampGte;

    private final Optional<OffsetDateTime> filterInProgressAtTimestampLte;

    private final Optional<OffsetDateTime> filterInProgressAtTimestampGte;

    private final Optional<OffsetDateTime> filterCompletedAtTimestampLte;

    private final Optional<OffsetDateTime> filterCompletedAtTimestampGte;

    private final Optional<OffsetDateTime> filterExceptionAtTimestampLte;

    private final Optional<OffsetDateTime> filterExceptionAtTimestampGte;

    private final Optional<OffsetDateTime> filterOrderCancelledAtTimestampLte;

    private final Optional<OffsetDateTime> filterOrderCancelledAtTimestampGte;

    private final OrderAndTaskGroupExpandedReq body;

    private final Map<String, Object> additionalProperties;

    private ExpandedListForForwarderOperatorsV1Request(
            Optional<List<OrderStatusEnum1>> filterStatus,
            Optional<OrderSortByEnum> sortBy,
            Optional<ExpandedListForForwarderOperatorsV1RequestSortOrder> sortOrder,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Optional<OffsetDateTime> filterDraftStartedAtTimestampLte,
            Optional<OffsetDateTime> filterDraftStartedAtTimestampGte,
            Optional<OffsetDateTime> filterStagedAtTimestampLte,
            Optional<OffsetDateTime> filterStagedAtTimestampGte,
            Optional<OffsetDateTime> filterInProgressAtTimestampLte,
            Optional<OffsetDateTime> filterInProgressAtTimestampGte,
            Optional<OffsetDateTime> filterCompletedAtTimestampLte,
            Optional<OffsetDateTime> filterCompletedAtTimestampGte,
            Optional<OffsetDateTime> filterExceptionAtTimestampLte,
            Optional<OffsetDateTime> filterExceptionAtTimestampGte,
            Optional<OffsetDateTime> filterOrderCancelledAtTimestampLte,
            Optional<OffsetDateTime> filterOrderCancelledAtTimestampGte,
            OrderAndTaskGroupExpandedReq body,
            Map<String, Object> additionalProperties) {
        this.filterStatus = filterStatus;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
        this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
        this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
        this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
        this.filterInProgressAtTimestampLte = filterInProgressAtTimestampLte;
        this.filterInProgressAtTimestampGte = filterInProgressAtTimestampGte;
        this.filterCompletedAtTimestampLte = filterCompletedAtTimestampLte;
        this.filterCompletedAtTimestampGte = filterCompletedAtTimestampGte;
        this.filterExceptionAtTimestampLte = filterExceptionAtTimestampLte;
        this.filterExceptionAtTimestampGte = filterExceptionAtTimestampGte;
        this.filterOrderCancelledAtTimestampLte = filterOrderCancelledAtTimestampLte;
        this.filterOrderCancelledAtTimestampGte = filterOrderCancelledAtTimestampGte;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<OrderStatusEnum1>> getFilterStatus() {
        if (filterStatus == null) {
            return Optional.empty();
        }
        return filterStatus;
    }

    @JsonIgnore
    public Optional<OrderSortByEnum> getSortBy() {
        if (sortBy == null) {
            return Optional.empty();
        }
        return sortBy;
    }

    @JsonIgnore
    public Optional<ExpandedListForForwarderOperatorsV1RequestSortOrder> getSortOrder() {
        if (sortOrder == null) {
            return Optional.empty();
        }
        return sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampLte() {
        if (filterDraftStartedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampGte() {
        if (filterDraftStartedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampLte() {
        if (filterStagedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterStagedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampGte() {
        if (filterStagedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterStagedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterInProgressAtTimestampLte() {
        if (filterInProgressAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterInProgressAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterInProgressAtTimestampGte() {
        if (filterInProgressAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterInProgressAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCompletedAtTimestampLte() {
        if (filterCompletedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterCompletedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCompletedAtTimestampGte() {
        if (filterCompletedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterCompletedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterExceptionAtTimestampLte() {
        if (filterExceptionAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterExceptionAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterExceptionAtTimestampGte() {
        if (filterExceptionAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterExceptionAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterOrderCancelledAtTimestampLte() {
        if (filterOrderCancelledAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterOrderCancelledAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterOrderCancelledAtTimestampGte() {
        if (filterOrderCancelledAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterOrderCancelledAtTimestampGte;
    }

    @JsonProperty("body")
    public OrderAndTaskGroupExpandedReq getBody() {
        return body;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_status")
    private Optional<List<OrderStatusEnum1>> _getFilterStatus() {
        return filterStatus;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_by")
    private Optional<OrderSortByEnum> _getSortBy() {
        return sortBy;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_order")
    private Optional<ExpandedListForForwarderOperatorsV1RequestSortOrder> _getSortOrder() {
        return sortOrder;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampLte() {
        return filterDraftStartedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampGte() {
        return filterDraftStartedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_staged_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampLte() {
        return filterStagedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_staged_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampGte() {
        return filterStagedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_in_progress_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterInProgressAtTimestampLte() {
        return filterInProgressAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_in_progress_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterInProgressAtTimestampGte() {
        return filterInProgressAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_completed_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterCompletedAtTimestampLte() {
        return filterCompletedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_completed_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterCompletedAtTimestampGte() {
        return filterCompletedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_exception_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterExceptionAtTimestampLte() {
        return filterExceptionAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_exception_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterExceptionAtTimestampGte() {
        return filterExceptionAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_order_cancelled_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterOrderCancelledAtTimestampLte() {
        return filterOrderCancelledAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_order_cancelled_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterOrderCancelledAtTimestampGte() {
        return filterOrderCancelledAtTimestampGte;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ExpandedListForForwarderOperatorsV1Request
                && equalTo((ExpandedListForForwarderOperatorsV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpandedListForForwarderOperatorsV1Request other) {
        return filterStatus.equals(other.filterStatus)
                && sortBy.equals(other.sortBy)
                && sortOrder.equals(other.sortOrder)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize)
                && filterDraftStartedAtTimestampLte.equals(other.filterDraftStartedAtTimestampLte)
                && filterDraftStartedAtTimestampGte.equals(other.filterDraftStartedAtTimestampGte)
                && filterStagedAtTimestampLte.equals(other.filterStagedAtTimestampLte)
                && filterStagedAtTimestampGte.equals(other.filterStagedAtTimestampGte)
                && filterInProgressAtTimestampLte.equals(other.filterInProgressAtTimestampLte)
                && filterInProgressAtTimestampGte.equals(other.filterInProgressAtTimestampGte)
                && filterCompletedAtTimestampLte.equals(other.filterCompletedAtTimestampLte)
                && filterCompletedAtTimestampGte.equals(other.filterCompletedAtTimestampGte)
                && filterExceptionAtTimestampLte.equals(other.filterExceptionAtTimestampLte)
                && filterExceptionAtTimestampGte.equals(other.filterExceptionAtTimestampGte)
                && filterOrderCancelledAtTimestampLte.equals(other.filterOrderCancelledAtTimestampLte)
                && filterOrderCancelledAtTimestampGte.equals(other.filterOrderCancelledAtTimestampGte)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.filterStatus,
                this.sortBy,
                this.sortOrder,
                this.page,
                this.pageSize,
                this.filterDraftStartedAtTimestampLte,
                this.filterDraftStartedAtTimestampGte,
                this.filterStagedAtTimestampLte,
                this.filterStagedAtTimestampGte,
                this.filterInProgressAtTimestampLte,
                this.filterInProgressAtTimestampGte,
                this.filterCompletedAtTimestampLte,
                this.filterCompletedAtTimestampGte,
                this.filterExceptionAtTimestampLte,
                this.filterExceptionAtTimestampGte,
                this.filterOrderCancelledAtTimestampLte,
                this.filterOrderCancelledAtTimestampGte,
                this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    public interface BodyStage {
        _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq body);

        Builder from(ExpandedListForForwarderOperatorsV1Request other);
    }

    public interface _FinalStage {
        ExpandedListForForwarderOperatorsV1Request build();

        _FinalStage filterStatus(Optional<List<OrderStatusEnum1>> filterStatus);

        _FinalStage filterStatus(List<OrderStatusEnum1> filterStatus);

        _FinalStage filterStatus(Nullable<List<OrderStatusEnum1>> filterStatus);

        _FinalStage filterStatus(OrderStatusEnum1 filterStatus);

        _FinalStage sortBy(Optional<OrderSortByEnum> sortBy);

        _FinalStage sortBy(OrderSortByEnum sortBy);

        _FinalStage sortBy(Nullable<OrderSortByEnum> sortBy);

        _FinalStage sortOrder(Optional<ExpandedListForForwarderOperatorsV1RequestSortOrder> sortOrder);

        _FinalStage sortOrder(ExpandedListForForwarderOperatorsV1RequestSortOrder sortOrder);

        _FinalStage sortOrder(Nullable<ExpandedListForForwarderOperatorsV1RequestSortOrder> sortOrder);

        _FinalStage page(Optional<Integer> page);

        _FinalStage page(Integer page);

        _FinalStage page(Nullable<Integer> page);

        _FinalStage pageSize(Optional<Integer> pageSize);

        _FinalStage pageSize(Integer pageSize);

        _FinalStage pageSize(Nullable<Integer> pageSize);

        _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> filterDraftStartedAtTimestampGte);

        _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime filterDraftStartedAtTimestampGte);

        _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampGte);

        _FinalStage filterStagedAtTimestampLte(Optional<OffsetDateTime> filterStagedAtTimestampLte);

        _FinalStage filterStagedAtTimestampLte(OffsetDateTime filterStagedAtTimestampLte);

        _FinalStage filterStagedAtTimestampLte(Nullable<OffsetDateTime> filterStagedAtTimestampLte);

        _FinalStage filterStagedAtTimestampGte(Optional<OffsetDateTime> filterStagedAtTimestampGte);

        _FinalStage filterStagedAtTimestampGte(OffsetDateTime filterStagedAtTimestampGte);

        _FinalStage filterStagedAtTimestampGte(Nullable<OffsetDateTime> filterStagedAtTimestampGte);

        _FinalStage filterInProgressAtTimestampLte(Optional<OffsetDateTime> filterInProgressAtTimestampLte);

        _FinalStage filterInProgressAtTimestampLte(OffsetDateTime filterInProgressAtTimestampLte);

        _FinalStage filterInProgressAtTimestampLte(Nullable<OffsetDateTime> filterInProgressAtTimestampLte);

        _FinalStage filterInProgressAtTimestampGte(Optional<OffsetDateTime> filterInProgressAtTimestampGte);

        _FinalStage filterInProgressAtTimestampGte(OffsetDateTime filterInProgressAtTimestampGte);

        _FinalStage filterInProgressAtTimestampGte(Nullable<OffsetDateTime> filterInProgressAtTimestampGte);

        _FinalStage filterCompletedAtTimestampLte(Optional<OffsetDateTime> filterCompletedAtTimestampLte);

        _FinalStage filterCompletedAtTimestampLte(OffsetDateTime filterCompletedAtTimestampLte);

        _FinalStage filterCompletedAtTimestampLte(Nullable<OffsetDateTime> filterCompletedAtTimestampLte);

        _FinalStage filterCompletedAtTimestampGte(Optional<OffsetDateTime> filterCompletedAtTimestampGte);

        _FinalStage filterCompletedAtTimestampGte(OffsetDateTime filterCompletedAtTimestampGte);

        _FinalStage filterCompletedAtTimestampGte(Nullable<OffsetDateTime> filterCompletedAtTimestampGte);

        _FinalStage filterExceptionAtTimestampLte(Optional<OffsetDateTime> filterExceptionAtTimestampLte);

        _FinalStage filterExceptionAtTimestampLte(OffsetDateTime filterExceptionAtTimestampLte);

        _FinalStage filterExceptionAtTimestampLte(Nullable<OffsetDateTime> filterExceptionAtTimestampLte);

        _FinalStage filterExceptionAtTimestampGte(Optional<OffsetDateTime> filterExceptionAtTimestampGte);

        _FinalStage filterExceptionAtTimestampGte(OffsetDateTime filterExceptionAtTimestampGte);

        _FinalStage filterExceptionAtTimestampGte(Nullable<OffsetDateTime> filterExceptionAtTimestampGte);

        _FinalStage filterOrderCancelledAtTimestampLte(Optional<OffsetDateTime> filterOrderCancelledAtTimestampLte);

        _FinalStage filterOrderCancelledAtTimestampLte(OffsetDateTime filterOrderCancelledAtTimestampLte);

        _FinalStage filterOrderCancelledAtTimestampLte(Nullable<OffsetDateTime> filterOrderCancelledAtTimestampLte);

        _FinalStage filterOrderCancelledAtTimestampGte(Optional<OffsetDateTime> filterOrderCancelledAtTimestampGte);

        _FinalStage filterOrderCancelledAtTimestampGte(OffsetDateTime filterOrderCancelledAtTimestampGte);

        _FinalStage filterOrderCancelledAtTimestampGte(Nullable<OffsetDateTime> filterOrderCancelledAtTimestampGte);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements BodyStage, _FinalStage {
        private OrderAndTaskGroupExpandedReq body;

        private Optional<OffsetDateTime> filterOrderCancelledAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterOrderCancelledAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterExceptionAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterExceptionAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterCompletedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterCompletedAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterInProgressAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterInProgressAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterStagedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterStagedAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterDraftStartedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterDraftStartedAtTimestampLte = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<ExpandedListForForwarderOperatorsV1RequestSortOrder> sortOrder = Optional.empty();

        private Optional<OrderSortByEnum> sortBy = Optional.empty();

        private Optional<List<OrderStatusEnum1>> filterStatus = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ExpandedListForForwarderOperatorsV1Request other) {
            filterStatus(other.getFilterStatus());
            sortBy(other.getSortBy());
            sortOrder(other.getSortOrder());
            page(other.getPage());
            pageSize(other.getPageSize());
            filterDraftStartedAtTimestampLte(other.getFilterDraftStartedAtTimestampLte());
            filterDraftStartedAtTimestampGte(other.getFilterDraftStartedAtTimestampGte());
            filterStagedAtTimestampLte(other.getFilterStagedAtTimestampLte());
            filterStagedAtTimestampGte(other.getFilterStagedAtTimestampGte());
            filterInProgressAtTimestampLte(other.getFilterInProgressAtTimestampLte());
            filterInProgressAtTimestampGte(other.getFilterInProgressAtTimestampGte());
            filterCompletedAtTimestampLte(other.getFilterCompletedAtTimestampLte());
            filterCompletedAtTimestampGte(other.getFilterCompletedAtTimestampGte());
            filterExceptionAtTimestampLte(other.getFilterExceptionAtTimestampLte());
            filterExceptionAtTimestampGte(other.getFilterExceptionAtTimestampGte());
            filterOrderCancelledAtTimestampLte(other.getFilterOrderCancelledAtTimestampLte());
            filterOrderCancelledAtTimestampGte(other.getFilterOrderCancelledAtTimestampGte());
            body(other.getBody());
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelledAtTimestampGte(
                Nullable<OffsetDateTime> filterOrderCancelledAtTimestampGte) {
            if (filterOrderCancelledAtTimestampGte.isNull()) {
                this.filterOrderCancelledAtTimestampGte = null;
            } else if (filterOrderCancelledAtTimestampGte.isEmpty()) {
                this.filterOrderCancelledAtTimestampGte = Optional.empty();
            } else {
                this.filterOrderCancelledAtTimestampGte = Optional.of(filterOrderCancelledAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelledAtTimestampGte(OffsetDateTime filterOrderCancelledAtTimestampGte) {
            this.filterOrderCancelledAtTimestampGte = Optional.ofNullable(filterOrderCancelledAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_order_cancelled_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterOrderCancelledAtTimestampGte(
                Optional<OffsetDateTime> filterOrderCancelledAtTimestampGte) {
            this.filterOrderCancelledAtTimestampGte = filterOrderCancelledAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelledAtTimestampLte(
                Nullable<OffsetDateTime> filterOrderCancelledAtTimestampLte) {
            if (filterOrderCancelledAtTimestampLte.isNull()) {
                this.filterOrderCancelledAtTimestampLte = null;
            } else if (filterOrderCancelledAtTimestampLte.isEmpty()) {
                this.filterOrderCancelledAtTimestampLte = Optional.empty();
            } else {
                this.filterOrderCancelledAtTimestampLte = Optional.of(filterOrderCancelledAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelledAtTimestampLte(OffsetDateTime filterOrderCancelledAtTimestampLte) {
            this.filterOrderCancelledAtTimestampLte = Optional.ofNullable(filterOrderCancelledAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_order_cancelled_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterOrderCancelledAtTimestampLte(
                Optional<OffsetDateTime> filterOrderCancelledAtTimestampLte) {
            this.filterOrderCancelledAtTimestampLte = filterOrderCancelledAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampGte(Nullable<OffsetDateTime> filterExceptionAtTimestampGte) {
            if (filterExceptionAtTimestampGte.isNull()) {
                this.filterExceptionAtTimestampGte = null;
            } else if (filterExceptionAtTimestampGte.isEmpty()) {
                this.filterExceptionAtTimestampGte = Optional.empty();
            } else {
                this.filterExceptionAtTimestampGte = Optional.of(filterExceptionAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampGte(OffsetDateTime filterExceptionAtTimestampGte) {
            this.filterExceptionAtTimestampGte = Optional.ofNullable(filterExceptionAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_exception_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterExceptionAtTimestampGte(Optional<OffsetDateTime> filterExceptionAtTimestampGte) {
            this.filterExceptionAtTimestampGte = filterExceptionAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampLte(Nullable<OffsetDateTime> filterExceptionAtTimestampLte) {
            if (filterExceptionAtTimestampLte.isNull()) {
                this.filterExceptionAtTimestampLte = null;
            } else if (filterExceptionAtTimestampLte.isEmpty()) {
                this.filterExceptionAtTimestampLte = Optional.empty();
            } else {
                this.filterExceptionAtTimestampLte = Optional.of(filterExceptionAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampLte(OffsetDateTime filterExceptionAtTimestampLte) {
            this.filterExceptionAtTimestampLte = Optional.ofNullable(filterExceptionAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_exception_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterExceptionAtTimestampLte(Optional<OffsetDateTime> filterExceptionAtTimestampLte) {
            this.filterExceptionAtTimestampLte = filterExceptionAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampGte(Nullable<OffsetDateTime> filterCompletedAtTimestampGte) {
            if (filterCompletedAtTimestampGte.isNull()) {
                this.filterCompletedAtTimestampGte = null;
            } else if (filterCompletedAtTimestampGte.isEmpty()) {
                this.filterCompletedAtTimestampGte = Optional.empty();
            } else {
                this.filterCompletedAtTimestampGte = Optional.of(filterCompletedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampGte(OffsetDateTime filterCompletedAtTimestampGte) {
            this.filterCompletedAtTimestampGte = Optional.ofNullable(filterCompletedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_completed_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterCompletedAtTimestampGte(Optional<OffsetDateTime> filterCompletedAtTimestampGte) {
            this.filterCompletedAtTimestampGte = filterCompletedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampLte(Nullable<OffsetDateTime> filterCompletedAtTimestampLte) {
            if (filterCompletedAtTimestampLte.isNull()) {
                this.filterCompletedAtTimestampLte = null;
            } else if (filterCompletedAtTimestampLte.isEmpty()) {
                this.filterCompletedAtTimestampLte = Optional.empty();
            } else {
                this.filterCompletedAtTimestampLte = Optional.of(filterCompletedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampLte(OffsetDateTime filterCompletedAtTimestampLte) {
            this.filterCompletedAtTimestampLte = Optional.ofNullable(filterCompletedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_completed_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterCompletedAtTimestampLte(Optional<OffsetDateTime> filterCompletedAtTimestampLte) {
            this.filterCompletedAtTimestampLte = filterCompletedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampGte(Nullable<OffsetDateTime> filterInProgressAtTimestampGte) {
            if (filterInProgressAtTimestampGte.isNull()) {
                this.filterInProgressAtTimestampGte = null;
            } else if (filterInProgressAtTimestampGte.isEmpty()) {
                this.filterInProgressAtTimestampGte = Optional.empty();
            } else {
                this.filterInProgressAtTimestampGte = Optional.of(filterInProgressAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampGte(OffsetDateTime filterInProgressAtTimestampGte) {
            this.filterInProgressAtTimestampGte = Optional.ofNullable(filterInProgressAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_in_progress_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterInProgressAtTimestampGte(Optional<OffsetDateTime> filterInProgressAtTimestampGte) {
            this.filterInProgressAtTimestampGte = filterInProgressAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampLte(Nullable<OffsetDateTime> filterInProgressAtTimestampLte) {
            if (filterInProgressAtTimestampLte.isNull()) {
                this.filterInProgressAtTimestampLte = null;
            } else if (filterInProgressAtTimestampLte.isEmpty()) {
                this.filterInProgressAtTimestampLte = Optional.empty();
            } else {
                this.filterInProgressAtTimestampLte = Optional.of(filterInProgressAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampLte(OffsetDateTime filterInProgressAtTimestampLte) {
            this.filterInProgressAtTimestampLte = Optional.ofNullable(filterInProgressAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_in_progress_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterInProgressAtTimestampLte(Optional<OffsetDateTime> filterInProgressAtTimestampLte) {
            this.filterInProgressAtTimestampLte = filterInProgressAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampGte(Nullable<OffsetDateTime> filterStagedAtTimestampGte) {
            if (filterStagedAtTimestampGte.isNull()) {
                this.filterStagedAtTimestampGte = null;
            } else if (filterStagedAtTimestampGte.isEmpty()) {
                this.filterStagedAtTimestampGte = Optional.empty();
            } else {
                this.filterStagedAtTimestampGte = Optional.of(filterStagedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampGte(OffsetDateTime filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = Optional.ofNullable(filterStagedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_staged_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterStagedAtTimestampGte(Optional<OffsetDateTime> filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampLte(Nullable<OffsetDateTime> filterStagedAtTimestampLte) {
            if (filterStagedAtTimestampLte.isNull()) {
                this.filterStagedAtTimestampLte = null;
            } else if (filterStagedAtTimestampLte.isEmpty()) {
                this.filterStagedAtTimestampLte = Optional.empty();
            } else {
                this.filterStagedAtTimestampLte = Optional.of(filterStagedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampLte(OffsetDateTime filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = Optional.ofNullable(filterStagedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_staged_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterStagedAtTimestampLte(Optional<OffsetDateTime> filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            if (filterDraftStartedAtTimestampGte.isNull()) {
                this.filterDraftStartedAtTimestampGte = null;
            } else if (filterDraftStartedAtTimestampGte.isEmpty()) {
                this.filterDraftStartedAtTimestampGte = Optional.empty();
            } else {
                this.filterDraftStartedAtTimestampGte = Optional.of(filterDraftStartedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = Optional.ofNullable(filterDraftStartedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            if (filterDraftStartedAtTimestampLte.isNull()) {
                this.filterDraftStartedAtTimestampLte = null;
            } else if (filterDraftStartedAtTimestampLte.isEmpty()) {
                this.filterDraftStartedAtTimestampLte = Optional.empty();
            } else {
                this.filterDraftStartedAtTimestampLte = Optional.of(filterDraftStartedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = Optional.ofNullable(filterDraftStartedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public _FinalStage pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(Nullable<ExpandedListForForwarderOperatorsV1RequestSortOrder> sortOrder) {
            if (sortOrder.isNull()) {
                this.sortOrder = null;
            } else if (sortOrder.isEmpty()) {
                this.sortOrder = Optional.empty();
            } else {
                this.sortOrder = Optional.of(sortOrder.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(ExpandedListForForwarderOperatorsV1RequestSortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_order", nulls = Nulls.SKIP)
        public _FinalStage sortOrder(Optional<ExpandedListForForwarderOperatorsV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(Nullable<OrderSortByEnum> sortBy) {
            if (sortBy.isNull()) {
                this.sortBy = null;
            } else if (sortBy.isEmpty()) {
                this.sortBy = Optional.empty();
            } else {
                this.sortBy = Optional.of(sortBy.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(OrderSortByEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_by", nulls = Nulls.SKIP)
        public _FinalStage sortBy(Optional<OrderSortByEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatus(OrderStatusEnum1 filterStatus) {
            this.filterStatus = Optional.of(Collections.singletonList(filterStatus));
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatus(Nullable<List<OrderStatusEnum1>> filterStatus) {
            if (filterStatus.isNull()) {
                this.filterStatus = null;
            } else if (filterStatus.isEmpty()) {
                this.filterStatus = Optional.empty();
            } else {
                this.filterStatus = Optional.of(filterStatus.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatus(List<OrderStatusEnum1> filterStatus) {
            this.filterStatus = Optional.ofNullable(filterStatus);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_status", nulls = Nulls.SKIP)
        public _FinalStage filterStatus(Optional<List<OrderStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        @java.lang.Override
        public ExpandedListForForwarderOperatorsV1Request build() {
            return new ExpandedListForForwarderOperatorsV1Request(
                    filterStatus,
                    sortBy,
                    sortOrder,
                    page,
                    pageSize,
                    filterDraftStartedAtTimestampLte,
                    filterDraftStartedAtTimestampGte,
                    filterStagedAtTimestampLte,
                    filterStagedAtTimestampGte,
                    filterInProgressAtTimestampLte,
                    filterInProgressAtTimestampGte,
                    filterCompletedAtTimestampLte,
                    filterCompletedAtTimestampGte,
                    filterExceptionAtTimestampLte,
                    filterExceptionAtTimestampGte,
                    filterOrderCancelledAtTimestampLte,
                    filterOrderCancelledAtTimestampGte,
                    body,
                    additionalProperties);
        }
    }
}
