/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgprofiles;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgprofiles.requests.CourierOrgProfileClientCreate1;
import com.chrt.api.resources.orgprofiles.requests.CourierOrgProfileClientUpdate1;
import com.chrt.api.resources.orgprofiles.requests.ForwarderOrgProfileClientCreate1;
import com.chrt.api.resources.orgprofiles.requests.ForwarderOrgProfileClientUpdate1;
import com.chrt.api.types.OrgProfileRes1;
import java.util.concurrent.CompletableFuture;

public class AsyncOrgProfilesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawOrgProfilesClient rawClient;

    public AsyncOrgProfilesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrgProfilesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawOrgProfilesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the courier or forwarder organization profile for the caller's organization. | () -&gt; (OrgProfileRes1)
     */
    public CompletableFuture<OrgProfileRes1> getV1() {
        return this.rawClient.getV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves the courier or forwarder organization profile for the caller's organization. | () -&gt; (OrgProfileRes1)
     */
    public CompletableFuture<OrgProfileRes1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new courier organization profile. Fails if a profile already exists for the organization. | (CourierOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createCourierV1(CourierOrgProfileClientCreate1 request) {
        return this.rawClient.createCourierV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new courier organization profile. Fails if a profile already exists for the organization. | (CourierOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createCourierV1(
            CourierOrgProfileClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createCourierV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new forwarder organization profile. Fails if a profile already exists for the organization. | (ForwarderOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createForwarderV1(ForwarderOrgProfileClientCreate1 request) {
        return this.rawClient.createForwarderV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new forwarder organization profile. Fails if a profile already exists for the organization. | (ForwarderOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createForwarderV1(
            ForwarderOrgProfileClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createForwarderV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates an existing courier organization profile. Can update one or more fields. | (CourierOrgProfileClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateCourierV1() {
        return this.rawClient.updateCourierV1().thenApply(response -> response.body());
    }

    /**
     * Updates an existing courier organization profile. Can update one or more fields. | (CourierOrgProfileClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateCourierV1(CourierOrgProfileClientUpdate1 request) {
        return this.rawClient.updateCourierV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates an existing courier organization profile. Can update one or more fields. | (CourierOrgProfileClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateCourierV1(
            CourierOrgProfileClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateCourierV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates an existing forwarder organization profile. Can update one or more fields. | (ForwarderOrgProfileClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateForwarderV1() {
        return this.rawClient.updateForwarderV1().thenApply(response -> response.body());
    }

    /**
     * Updates an existing forwarder organization profile. Can update one or more fields. | (ForwarderOrgProfileClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateForwarderV1(ForwarderOrgProfileClientUpdate1 request) {
        return this.rawClient.updateForwarderV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates an existing forwarder organization profile. Can update one or more fields. | (ForwarderOrgProfileClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateForwarderV1(
            ForwarderOrgProfileClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateForwarderV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a courier or forwarder organization profile using the organization's handle for public profile viewing. | () -&gt; (OrgProfileRes1)
     */
    public CompletableFuture<OrgProfileRes1> getByHandleV1(String handle) {
        return this.rawClient.getByHandleV1(handle).thenApply(response -> response.body());
    }

    /**
     * Retrieves a courier or forwarder organization profile using the organization's handle for public profile viewing. | () -&gt; (OrgProfileRes1)
     */
    public CompletableFuture<OrgProfileRes1> getByHandleV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getByHandleV1(handle, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the organization avatar image URL from Clerk or a placeholder if not found. | () -&gt; (str)
     */
    public CompletableFuture<String> getAvatarV1(String handle) {
        return this.rawClient.getAvatarV1(handle).thenApply(response -> response.body());
    }

    /**
     * Returns the organization avatar image URL from Clerk or a placeholder if not found. | () -&gt; (str)
     */
    public CompletableFuture<String> getAvatarV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getAvatarV1(handle, requestOptions).thenApply(response -> response.body());
    }
}
