/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgprofiles.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierOrgProfileClientCreate1.Builder.class)
public final class CourierOrgProfileClientCreate1 {
    private final int schemaVersion;

    private final String description;

    private final String emailAddressPrimary;

    private final String phoneNumberPrimary;

    private final Map<String, Object> additionalProperties;

    private CourierOrgProfileClientCreate1(
            int schemaVersion,
            String description,
            String emailAddressPrimary,
            String phoneNumberPrimary,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.description = description;
        this.emailAddressPrimary = emailAddressPrimary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("email_address_primary")
    public String getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonProperty("phone_number_primary")
    public String getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierOrgProfileClientCreate1 && equalTo((CourierOrgProfileClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierOrgProfileClientCreate1 other) {
        return schemaVersion == other.schemaVersion
                && description.equals(other.description)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.description, this.emailAddressPrimary, this.phoneNumberPrimary);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        DescriptionStage schemaVersion(int schemaVersion);

        Builder from(CourierOrgProfileClientCreate1 other);
    }

    public interface DescriptionStage {
        EmailAddressPrimaryStage description(@NotNull String description);
    }

    public interface EmailAddressPrimaryStage {
        PhoneNumberPrimaryStage emailAddressPrimary(@NotNull String emailAddressPrimary);
    }

    public interface PhoneNumberPrimaryStage {
        _FinalStage phoneNumberPrimary(@NotNull String phoneNumberPrimary);
    }

    public interface _FinalStage {
        CourierOrgProfileClientCreate1 build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    DescriptionStage,
                    EmailAddressPrimaryStage,
                    PhoneNumberPrimaryStage,
                    _FinalStage {
        private int schemaVersion;

        private String description;

        private String emailAddressPrimary;

        private String phoneNumberPrimary;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CourierOrgProfileClientCreate1 other) {
            schemaVersion(other.getSchemaVersion());
            description(other.getDescription());
            emailAddressPrimary(other.getEmailAddressPrimary());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public DescriptionStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public EmailAddressPrimaryStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("email_address_primary")
        public PhoneNumberPrimaryStage emailAddressPrimary(@NotNull String emailAddressPrimary) {
            this.emailAddressPrimary =
                    Objects.requireNonNull(emailAddressPrimary, "emailAddressPrimary must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("phone_number_primary")
        public _FinalStage phoneNumberPrimary(@NotNull String phoneNumberPrimary) {
            this.phoneNumberPrimary = Objects.requireNonNull(phoneNumberPrimary, "phoneNumberPrimary must not be null");
            return this;
        }

        @java.lang.Override
        public CourierOrgProfileClientCreate1 build() {
            return new CourierOrgProfileClientCreate1(
                    schemaVersion, description, emailAddressPrimary, phoneNumberPrimary, additionalProperties);
        }
    }
}
